/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;

public class LogSystemCommonsLog
implements Log {
    protected static VelocityEngine handler = null;
    private boolean printStackTrace = false;
    private String name;

    public static void setVelocityEngine(VelocityEngine velocityEngine) {
        handler = velocityEngine;
    }

    public LogSystemCommonsLog() {
        this("");
    }

    public LogSystemCommonsLog(String string) {
        if (string == null) {
            throw new NullPointerException("Log name cannot be null");
        }
    }

    public LogSystemCommonsLog(boolean bl) {
        this(bl, null);
    }

    public LogSystemCommonsLog(boolean bl, String string) {
        this(string);
        this.printStackTrace = bl;
    }

    private void log(int n, Object object) {
        if (handler != null) {
            switch (n) {
                case 2: {
                    handler.warn(object);
                    break;
                }
                case 1: {
                    handler.info(object);
                    break;
                }
                case 0: {
                    handler.debug(object);
                    break;
                }
                case 3: {
                    handler.error(object);
                    break;
                }
                default: {
                    handler.debug(object);
                    break;
                }
            }
        } else {
            switch (n) {
                case 2: {
                    Velocity.warn((Object)object);
                    break;
                }
                case 1: {
                    Velocity.info((Object)object);
                    break;
                }
                case 0: {
                    Velocity.debug((Object)object);
                    break;
                }
                case 3: {
                    Velocity.error((Object)object);
                    break;
                }
                default: {
                    Velocity.debug((Object)object);
                }
            }
        }
    }

    private void log(int n, Object object, Throwable throwable) {
        if (this.printStackTrace) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(String.valueOf(object));
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.log(n, stringWriter);
        } else {
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(object));
            stringBuffer.append(" - ");
            stringBuffer.append(throwable.getMessage());
            this.log(n, stringBuffer);
        }
    }

    public void trace(Object object) {
        this.log(0, object);
    }

    public void trace(Object object, Throwable throwable) {
        this.log(0, object, throwable);
    }

    public void debug(Object object) {
        this.log(0, object);
    }

    public void debug(Object object, Throwable throwable) {
        this.log(0, object, throwable);
    }

    public void info(Object object) {
        this.log(1, object);
    }

    public void info(Object object, Throwable throwable) {
        this.log(1, object, throwable);
    }

    public void warn(Object object) {
        this.log(2, object);
    }

    public void warn(Object object, Throwable throwable) {
        this.log(2, object, throwable);
    }

    public void error(Object object) {
        this.log(3, object);
    }

    public void error(Object object, Throwable throwable) {
        this.log(3, object, throwable);
    }

    public void fatal(Object object) {
        this.log(3, object);
    }

    public void fatal(Object object, Throwable throwable) {
        this.log(3, object, throwable);
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }
}

