/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ValueParser {
    private Map source = null;

    public ValueParser() {
    }

    public ValueParser(Map map) {
        this.setSource(map);
    }

    protected void setSource(Map map) {
        this.source = map;
    }

    protected Map getSource() {
        if (this.source == null) {
            throw new NullPointerException("You must set a Map source for values to be parsed.");
        }
        return this.source;
    }

    public boolean exists(String string) {
        return this.getString(string) != null;
    }

    public String get(String string) {
        return this.getString(string);
    }

    public String getString(String string) {
        Object object = this.getSource().get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (!collection.isEmpty()) {
                object = collection.iterator().next();
            }
        } else if (object.getClass().isArray() && Array.getLength(object) > 0) {
            object = Array.get(object, 0);
        }
        return String.valueOf(object);
    }

    public String getString(String string, String string2) {
        String string3 = this.getString(string);
        return string3 != null ? string3 : string2;
    }

    public Boolean getBoolean(String string) {
        String string2 = this.getString(string);
        return string2 != null ? this.parseBoolean(string2) : null;
    }

    public boolean getBoolean(String string, boolean bl) {
        Boolean bl2 = this.getBoolean(string);
        return bl2 != null ? bl2 : bl;
    }

    public Boolean getBoolean(String string, Boolean bl) {
        Boolean bl2 = this.getBoolean(string);
        return bl2 != null ? bl2 : bl;
    }

    public Number getNumber(String string) {
        String string2 = this.getString(string);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        try {
            return this.parseNumber(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Number getNumber(String string, Number number) {
        Number number2 = this.getNumber(string);
        return number2 != null ? (Number)number2 : (Number)number;
    }

    public int getInt(String string, int n) {
        Number number = this.getNumber(string);
        return number != null ? number.intValue() : n;
    }

    public double getDouble(String string, double d) {
        Number number = this.getNumber(string);
        return number != null ? number.doubleValue() : d;
    }

    public String[] getStrings(String string) {
        Object v = this.getSource().get(string);
        if (v == null) {
            return null;
        }
        String[] stringArray = null;
        if (v instanceof Collection) {
            Collection collection = (Collection)v;
            if (!collection.isEmpty()) {
                stringArray = new String[collection.size()];
                int n = 0;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    stringArray[n++] = String.valueOf(iterator.next());
                }
            }
        } else if (v.getClass().isArray()) {
            stringArray = new String[Array.getLength(v)];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = String.valueOf(Array.get(v, i));
            }
        } else {
            stringArray = new String[]{String.valueOf(v)};
        }
        return stringArray;
    }

    public Boolean[] getBooleans(String string) {
        String[] stringArray = this.getStrings(string);
        if (stringArray == null) {
            return null;
        }
        Boolean[] booleanArray = new Boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
            booleanArray[i] = this.parseBoolean(stringArray[i]);
        }
        return booleanArray;
    }

    public Number[] getNumbers(String string) {
        String[] stringArray = this.getStrings(string);
        if (stringArray == null) {
            return null;
        }
        Number[] numberArray = new Number[stringArray.length];
        try {
            for (int i = 0; i < numberArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                numberArray[i] = this.parseNumber(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return numberArray;
    }

    public int[] getInts(String string) {
        String[] stringArray = this.getStrings(string);
        if (stringArray == null) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        try {
            for (int i = 0; i < nArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                nArray[i] = this.parseNumber(stringArray[i]).intValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return nArray;
    }

    public double[] getDoubles(String string) {
        String[] stringArray = this.getStrings(string);
        if (stringArray == null) {
            return null;
        }
        double[] dArray = new double[stringArray.length];
        try {
            for (int i = 0; i < dArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                dArray[i] = this.parseNumber(stringArray[i]).doubleValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return dArray;
    }

    protected Number parseNumber(String string) throws NumberFormatException {
        if (string.indexOf(46) >= 0) {
            return new Double(string);
        }
        return new Long(string);
    }

    protected Boolean parseBoolean(String string) {
        return Boolean.valueOf(string);
    }
}

