/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class NumberTool {
    public static final String DEFAULT_FORMAT = "default";
    private static final int STYLE_NUMBER = 0;
    private static final int STYLE_CURRENCY = 1;
    private static final int STYLE_PERCENT = 2;
    private static final int STYLE_INTEGER = 4;

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public String getFormat() {
        return DEFAULT_FORMAT;
    }

    public String format(Object object) {
        return this.format(this.getFormat(), object);
    }

    public String format(String string, Object object) {
        return this.format(string, object, this.getLocale());
    }

    public String format(String string, Object object, Locale locale) {
        Number number = this.toNumber(object);
        NumberFormat numberFormat = this.getNumberFormat(string, locale);
        if (number == null || numberFormat == null) {
            return null;
        }
        return numberFormat.format(number);
    }

    public NumberFormat getNumberFormat(String string, Locale locale) {
        if (string == null) {
            return null;
        }
        NumberFormat numberFormat = null;
        int n = this.getStyleAsInt(string);
        numberFormat = n < 0 ? new DecimalFormat(string, new DecimalFormatSymbols(locale)) : this.getNumberFormat(n, locale);
        return numberFormat;
    }

    protected NumberFormat getNumberFormat(int n, Locale locale) {
        try {
            NumberFormat numberFormat;
            switch (n) {
                case 0: {
                    numberFormat = NumberFormat.getNumberInstance(locale);
                    break;
                }
                case 1: {
                    numberFormat = NumberFormat.getCurrencyInstance(locale);
                    break;
                }
                case 2: {
                    numberFormat = NumberFormat.getPercentInstance(locale);
                    break;
                }
                case 4: {
                    numberFormat = this.getIntegerInstance(locale);
                    break;
                }
                default: {
                    numberFormat = null;
                }
            }
            return numberFormat;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private NumberFormat getIntegerInstance(Locale locale) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        decimalFormat.setMaximumFractionDigits(0);
        decimalFormat.setDecimalSeparatorAlwaysShown(false);
        decimalFormat.setParseIntegerOnly(true);
        return decimalFormat;
    }

    protected int getStyleAsInt(String string) {
        if (string == null || string.length() < 6 || string.length() > 8) {
            return -1;
        }
        if (string.equalsIgnoreCase(DEFAULT_FORMAT)) {
            return 0;
        }
        if (string.equalsIgnoreCase("number")) {
            return 0;
        }
        if (string.equalsIgnoreCase("currency")) {
            return 1;
        }
        if (string.equalsIgnoreCase("percent")) {
            return 2;
        }
        if (string.equalsIgnoreCase("integer")) {
            return 4;
        }
        return -1;
    }

    public Number toNumber(Object object) {
        return this.toNumber(this.getFormat(), object, this.getLocale());
    }

    public Number toNumber(String string, Object object) {
        return this.toNumber(string, object, this.getLocale());
    }

    public Number toNumber(String string, Object object, Locale locale) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        try {
            NumberFormat numberFormat = this.getNumberFormat(string, locale);
            return numberFormat.parse(String.valueOf(object));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

