/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.aws.request;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import vc.inreach.aws.request.AWSSigner;

public class AWSSigningRequestInterceptor
implements HttpRequestInterceptor {
    private static final Splitter.MapSplitter SPLITTER = Splitter.on((char)'&').trimResults().withKeyValueSeparator('=');
    private final AWSSigner signer;
    private static final Function<HttpEntity, byte[]> TO_BYTE_ARRAY = entity -> {
        try {
            return ByteStreams.toByteArray((InputStream)entity.getContent());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    };

    public AWSSigningRequestInterceptor(AWSSigner signer) {
        this.signer = signer;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        request.setHeaders(this.headers(this.signer.getSignedHeaders(this.path(request), request.getRequestLine().getMethod(), this.params(request), this.headers(request), this.body(request))));
    }

    private Map<String, String> params(HttpRequest request) {
        String query = ((HttpRequestWrapper)request).getURI().getQuery();
        if (Strings.isNullOrEmpty((String)query)) {
            return ImmutableMap.of();
        }
        return SPLITTER.split((CharSequence)query);
    }

    private String path(HttpRequest request) {
        return ((HttpRequestWrapper)request).getURI().getPath();
    }

    private Map<String, Object> headers(HttpRequest request) {
        ImmutableMap.Builder headers = ImmutableMap.builder();
        for (Header header : request.getAllHeaders()) {
            headers.put((Object)header.getName(), (Object)header.getValue());
        }
        return headers.build();
    }

    private Optional<byte[]> body(HttpRequest request) throws IOException {
        HttpEntityEnclosingRequest original = (HttpEntityEnclosingRequest)((HttpRequestWrapper)request).getOriginal();
        return Optional.fromNullable((Object)original.getEntity()).transform(TO_BYTE_ARRAY);
    }

    private Header[] headers(Map<String, Object> from) {
        return from.entrySet().stream().map(entry -> new BasicHeader((String)entry.getKey(), entry.getValue().toString())).collect(Collectors.toList()).toArray(new Header[from.size()]);
    }
}

