/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.aws.request;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class AWSSigner {
    private static final char[] BASE16MAP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String SLASH = "/";
    private static final String X_AMZ_DATE = "x-amz-date";
    private static final String RETURN = "\n";
    private static final String AWS4_HMAC_SHA256 = "AWS4-HMAC-SHA256\n";
    private static final String AWS4_REQUEST = "/aws4_request";
    private static final String AWS4_HMAC_SHA256_CREDENTIAL = "AWS4-HMAC-SHA256 Credential=";
    private static final String SIGNED_HEADERS = ", SignedHeaders=";
    private static final String SIGNATURE = ", Signature=";
    private static final String SHA_256 = "SHA-256";
    private static final String AWS4 = "AWS4";
    private static final String AWS_4_REQUEST = "aws4_request";
    private static final Joiner JOINER = Joiner.on((char)';');
    private static final String CONNECTION = "connection";
    private static final String CLOSE = ":close";
    private static final DateTimeFormatter BASIC_TIME_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('Z').toFormatter();
    private static final String EMPTY = "";
    private static final String ZERO = "0";
    private static final Joiner AMPERSAND_JOINER = Joiner.on((char)'&');
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String AUTHORIZATION = "Authorization";
    private final String awsAccessKeyId;
    private final String awsSecretKey;
    private final String region;
    private final String service;
    private final Supplier<LocalDateTime> clock;

    public AWSSigner(String awsAccessKeyId, String awsSecretKey, String region, String service, Supplier<LocalDateTime> clock) {
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretKey = awsSecretKey;
        this.region = region;
        this.service = service;
        this.clock = clock;
    }

    public Map<String, Object> getSignedHeaders(String uri, String method, Map<String, String> queryParams, Map<String, Object> headers, Optional<byte[]> payload) {
        LocalDateTime now = (LocalDateTime)this.clock.get();
        ImmutableMap.Builder result = ImmutableMap.builder();
        result.putAll(headers);
        result.put((Object)X_AMZ_DATE, (Object)now.format(BASIC_TIME_FORMAT));
        StringBuilder headersString = new StringBuilder();
        ImmutableList.Builder signedHeaders = ImmutableList.builder();
        for (Map.Entry<String, Object> entry : new TreeMap(result.build()).entrySet()) {
            headersString.append(this.headerAsString(entry)).append(RETURN);
            signedHeaders.add((Object)entry.getKey().toLowerCase());
        }
        String signedHeaderKeys = JOINER.join((Iterable)signedHeaders.build());
        String string = method + RETURN + uri + RETURN + this.queryParamsString(queryParams) + RETURN + headersString.toString() + RETURN + signedHeaderKeys + RETURN + this.toBase16(this.hash((byte[])payload.or((Object)EMPTY.getBytes(Charsets.UTF_8))));
        String stringToSign = this.createStringToSign(string, now);
        String signature = this.sign(stringToSign, now);
        String autorizationHeader = AWS4_HMAC_SHA256_CREDENTIAL + this.awsAccessKeyId + SLASH + this.getCredentialScope(now) + SIGNED_HEADERS + signedHeaderKeys + SIGNATURE + signature;
        result.put((Object)AUTHORIZATION, (Object)autorizationHeader);
        return result.build();
    }

    private String queryParamsString(Map<String, String> queryParams) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry<String, String> param : new TreeMap<String, String>(queryParams).entrySet()) {
            result.add((Object)(param.getKey() + '=' + param.getValue()));
        }
        return AMPERSAND_JOINER.join((Iterable)result.build());
    }

    private String headerAsString(Map.Entry<String, Object> header) {
        if (header.getKey().equalsIgnoreCase(CONNECTION)) {
            return "connection:close";
        }
        if (header.getKey().equalsIgnoreCase(CONTENT_LENGTH) && header.getValue().equals(ZERO)) {
            return header.getKey().toLowerCase() + ':';
        }
        return header.getKey().toLowerCase() + ':' + header.getValue();
    }

    private String sign(String stringToSign, LocalDateTime now) {
        return Hex.encodeHexString((byte[])this.hmacSHA256(stringToSign, this.getSignatureKey(now)));
    }

    private String createStringToSign(String canonicalRequest, LocalDateTime now) {
        return AWS4_HMAC_SHA256 + now.format(BASIC_TIME_FORMAT) + RETURN + this.getCredentialScope(now) + RETURN + this.toBase16(this.hash(canonicalRequest.getBytes(Charsets.UTF_8)));
    }

    private String getCredentialScope(LocalDateTime now) {
        return now.format(DateTimeFormatter.BASIC_ISO_DATE) + SLASH + this.region + SLASH + this.service + AWS4_REQUEST;
    }

    private byte[] hash(byte[] payload) {
        try {
            MessageDigest md = MessageDigest.getInstance(SHA_256);
            md.update(payload);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private String toBase16(byte[] data) {
        StringBuilder hexBuffer = new StringBuilder(data.length * 2);
        for (byte aData : data) {
            hexBuffer.append(BASE16MAP[aData >> 4 & 0xF]);
            hexBuffer.append(BASE16MAP[aData & 0xF]);
        }
        return hexBuffer.toString();
    }

    private byte[] getSignatureKey(LocalDateTime now) {
        byte[] kSecret = (AWS4 + this.awsSecretKey).getBytes(Charsets.UTF_8);
        byte[] kDate = this.hmacSHA256(now.format(DateTimeFormatter.BASIC_ISO_DATE), kSecret);
        byte[] kRegion = this.hmacSHA256(this.region, kDate);
        byte[] kService = this.hmacSHA256(this.service, kRegion);
        return this.hmacSHA256(AWS_4_REQUEST, kService);
    }

    private byte[] hmacSHA256(String data, byte[] key) {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA256);
            mac.init(new SecretKeySpec(key, HMAC_SHA256));
            return mac.doFinal(data.getBytes(Charsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

