/*
 * Decompiled with CFR 0.152.
 */
package uz.paycom.payment.api.task;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Parcelable;
import java.lang.ref.WeakReference;
import org.json.JSONObject;
import uz.paycom.payment.ConfirmActivity;
import uz.paycom.payment.PaymentActivity;
import uz.paycom.payment.R;
import uz.paycom.payment.api.JsonParser;
import uz.paycom.payment.api.JsonRpcRequest;

public class VerifyCardTask
extends AsyncTask<Void, Void, String> {
    private Double amount;
    private boolean hasError;
    private boolean save;
    private JsonParser jsonParser = new JsonParser();
    private String id;
    private String number;
    private String expire;
    private String token;
    private WeakReference<PaymentActivity> weakActivity;

    public VerifyCardTask(PaymentActivity activity) {
        this.weakActivity = new WeakReference<PaymentActivity>(activity);
    }

    protected void onPreExecute() {
        PaymentActivity activity = (PaymentActivity)((Object)this.weakActivity.get());
        if (activity != null) {
            this.id = PaymentActivity.id;
            this.amount = activity.amount * 100.0;
            this.number = activity.activityMainCardNumber.getText().toString().replace(" ", "");
            this.expire = activity.activityMainDateExpire.getText().toString().replace("/", "");
            this.save = activity.activityMainCardRemember.isChecked();
        }
    }

    protected String doInBackground(Void ... params) {
        JsonRpcRequest jsonRpcRequest = new JsonRpcRequest(this.id);
        JSONObject jsonObject = this.jsonParser.getCardsCreate(this.number, this.expire, this.amount, this.save);
        String result = jsonRpcRequest.callApiMethod(jsonObject, "cards.create");
        if (result == null) {
            return null;
        }
        if (this.jsonParser.checkError(result) != null) {
            this.hasError = true;
            return this.jsonParser.checkError(result);
        }
        this.token = this.jsonParser.getCardToken(result);
        jsonObject = this.jsonParser.getCardsVerifyCode(this.token);
        result = jsonRpcRequest.callApiMethod(jsonObject, "cards.get_verify_code");
        return result;
    }

    protected void onPostExecute(String s) {
        PaymentActivity activity = (PaymentActivity)((Object)this.weakActivity.get());
        if (activity == null) {
            return;
        }
        if (s == null) {
            activity.showError(activity.getString(R.string.tryAgainMessage));
        } else if (this.hasError) {
            activity.showError(s);
        } else {
            Intent intent = new Intent((Context)activity, ConfirmActivity.class);
            intent.putExtra("CONFIRM", (Parcelable)this.jsonParser.getConfirm(s));
            intent.putExtra("TOKEN", this.token);
            intent.putExtra("LANG", activity.lang);
            intent.setFlags(0x2000000);
            activity.startActivity(intent);
            activity.finish();
        }
        activity.activityMainContinue.setEnabled(true);
        activity.activityMainProgress.setVisibility(8);
    }
}

