/*
 * Decompiled with CFR 0.152.
 */
package uz.paycom.payment;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import uz.paycom.payment.R;
import uz.paycom.payment.api.task.VerifyCardTask;
import uz.paycom.payment.utils.CardNumberFormat;
import uz.paycom.payment.utils.DateExpireFormat;
import uz.paycom.payment.utils.LocaleHelper;
import uz.paycom.payment.utils.PaycomSandBox;

public class PaymentActivity
extends AppCompatActivity {
    public static final String EXTRA_ID = "ID";
    public static final String EXTRA_LANG = "LANG";
    public static final String EXTRA_SAVE = "SAVE";
    public static final String EXTRA_AMOUNT = "AMOUNT";
    public static final String EXTRA_RESULT = "RESULT";
    private RelativeLayout activityMainErrorLayout;
    private TextView activityMainErrorLayoutError;
    private TextView activityMainErrorMessage;
    private TextView activityMainClose;
    private TextView activityMainPaymentSumTitle;
    private TextView activityMainPaymentSum;
    private TextView activityMainCardNumberTitle;
    private TextView activityMainUzcardOnlyText;
    private TextView activityMainDateExpireTitle;
    private DecimalFormat decimalFormat;
    public EditText activityMainCardNumber;
    public EditText activityMainDateExpire;
    public CheckBox activityMainCardRemember;
    public Button activityMainContinue;
    public ProgressBar activityMainProgress;
    public static String id;
    public String lang;
    public Double amount;
    public boolean save;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.paycom_payment_main);
        this.activityMainErrorLayout = (RelativeLayout)this.findViewById(R.id.activity_main_errorLayout);
        this.activityMainErrorLayoutError = (TextView)this.findViewById(R.id.activity_main_errorLayout_error);
        this.activityMainErrorMessage = (TextView)this.findViewById(R.id.activity_main_errorMessage);
        this.activityMainClose = (TextView)this.findViewById(R.id.activity_main_close);
        this.activityMainPaymentSumTitle = (TextView)this.findViewById(R.id.activity_main_paymentSumTitle);
        this.activityMainPaymentSum = (TextView)this.findViewById(R.id.activity_main_paymentSum);
        this.activityMainCardNumberTitle = (TextView)this.findViewById(R.id.activity_main_cardNumberTitle);
        this.activityMainCardNumber = (EditText)this.findViewById(R.id.activity_main_cardNumber);
        this.activityMainUzcardOnlyText = (TextView)this.findViewById(R.id.activity_main_uzcardOnlyText);
        this.activityMainDateExpireTitle = (TextView)this.findViewById(R.id.activity_main_dateExpireTitle);
        this.activityMainDateExpire = (EditText)this.findViewById(R.id.activity_main_dateExpire);
        this.activityMainCardRemember = (CheckBox)this.findViewById(R.id.activity_main_cardRemember);
        this.activityMainContinue = (Button)this.findViewById(R.id.activity_main_continue);
        this.activityMainProgress = (ProgressBar)this.findViewById(R.id.activity_main_progress);
        this.initUI();
        this.activityMainCardNumber.addTextChangedListener((TextWatcher)new CardNumberFormat((View)this.activityMainContinue));
        this.activityMainDateExpire.addTextChangedListener((TextWatcher)new DateExpireFormat((View)this.activityMainContinue));
        this.activityMainContinue.setEnabled(false);
        this.activityMainContinue.setAlpha(0.3f);
        this.activityMainContinue.setClickable(false);
        this.activityMainContinue.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String number = PaymentActivity.this.activityMainCardNumber.getText().toString().replace(" ", "");
                if (!PaymentActivity.this.isOnline(number) && !PaycomSandBox.isSandBox()) {
                    PaymentActivity.this.showError(PaymentActivity.this.getString(R.string.uzcardOnly));
                    return;
                }
                if (!PaymentActivity.this.isValid(number)) {
                    PaymentActivity.this.showError(PaymentActivity.this.getString(R.string.invalidCard));
                }
                new VerifyCardTask(PaymentActivity.this).execute(new Void[0]);
                PaymentActivity.this.activityMainContinue.setEnabled(false);
                PaymentActivity.this.activityMainProgress.setVisibility(0);
                PaymentActivity.this.activityMainErrorLayout.setVisibility(8);
            }
        });
        this.activityMainClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PaymentActivity.this.activityMainErrorLayout.setVisibility(8);
            }
        });
    }

    private void initUI() {
        this.lang = this.getIntent().getStringExtra(EXTRA_LANG);
        Context context = LocaleHelper.onAttach((Context)this, this.lang);
        Resources resources = context.getResources();
        this.setTitle(resources.getString(R.string.paycomTitle));
        this.activityMainErrorLayoutError.setText((CharSequence)resources.getString(R.string.error));
        this.activityMainClose.setText((CharSequence)resources.getString(R.string.close));
        this.activityMainPaymentSumTitle.setText((CharSequence)resources.getString(R.string.paymentSum));
        this.activityMainCardNumberTitle.setText((CharSequence)resources.getString(R.string.cardNumber));
        this.activityMainUzcardOnlyText.setText((CharSequence)resources.getString(R.string.uzcardOnly));
        this.activityMainDateExpireTitle.setText((CharSequence)resources.getString(R.string.dateExpire));
        this.activityMainDateExpire.setHint((CharSequence)resources.getString(R.string.dateExpireHint));
        this.activityMainContinue.setText((CharSequence)resources.getString(R.string.continueText));
        this.activityMainCardRemember.setText((CharSequence)resources.getString(R.string.cardRemember));
        id = this.getIntent().getStringExtra(EXTRA_ID);
        this.amount = this.getIntent().getDoubleExtra(EXTRA_AMOUNT, 0.0);
        this.amount = Math.floor(this.amount * 100.0) / 100.0;
        this.save = this.getIntent().getBooleanExtra(EXTRA_SAVE, false);
        if (this.amount <= 0.0) {
            this.setResult(0);
            this.finish();
        }
        this.activityMainPaymentSum.setText((CharSequence)(this.formatMoney(this.amount, true) + " " + resources.getString(R.string.card_balance_currency)));
        this.activityMainCardRemember.setVisibility(this.save ? 0 : 8);
    }

    public boolean isValid(String code) {
        int sum = 0;
        boolean alternate = false;
        for (int i = code.length() - 1; i >= 0; --i) {
            int n = Integer.parseInt(code.substring(i, i + 1));
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate = !alternate;
        }
        return sum % 10 == 0;
    }

    public String formatMoney(double value, boolean showDecimal) {
        if (this.decimalFormat == null) {
            this.decimalFormat = new DecimalFormat("###,###,###.00");
            this.decimalFormat.setGroupingSize(3);
            this.decimalFormat.setMinimumFractionDigits(0);
            DecimalFormatSymbols s = new DecimalFormatSymbols();
            s.setGroupingSeparator(' ');
            DecimalFormatSymbols symbols = this.decimalFormat.getDecimalFormatSymbols();
            s.setDecimalSeparator(symbols.getDecimalSeparator());
            this.decimalFormat.setDecimalFormatSymbols(s);
        }
        this.decimalFormat.setMinimumFractionDigits(showDecimal ? 2 : 0);
        this.decimalFormat.setMaximumFractionDigits(showDecimal ? 2 : 0);
        return this.decimalFormat.format(value);
    }

    public boolean isOnline(String code) {
        return code.substring(0, 4).equals("8600");
    }

    public void showError(String s) {
        if (!TextUtils.isEmpty((CharSequence)s)) {
            this.activityMainErrorLayout.setVisibility(0);
            this.activityMainErrorMessage.setText((CharSequence)s);
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResult(0);
    }
}

