/*
 * Decompiled with CFR 0.152.
 */
package uz.click.mobilesdk.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Luz/click/mobilesdk/utils/LanguageUtils;", "", "()V", "getLocaleStringResource", "", "requestedLocale", "Ljava/util/Locale;", "resourceId", "", "context", "Landroid/content/Context;", "mobilesdk_release"})
public final class LanguageUtils {
    public static final LanguageUtils INSTANCE;

    @NotNull
    public final String getLocaleStringResource(@NotNull Locale requestedLocale, int resourceId, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)requestedLocale, (String)"requestedLocale");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String result = null;
        if (Build.VERSION.SDK_INT >= 17) {
            Resources resources = context.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            Configuration config = new Configuration(resources.getConfiguration());
            config.setLocale(requestedLocale);
            result = ((Object)context.createConfigurationContext(config).getText(resourceId)).toString();
        } else {
            Resources resources;
            Resources resources2 = resources = context.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
            Configuration conf = resources2.getConfiguration();
            Locale savedLocale = conf.locale;
            conf.locale = requestedLocale;
            resources.updateConfiguration(conf, null);
            String string2 = resources.getString(resourceId);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resources.getString(resourceId)");
            result = string2;
            conf.locale = savedLocale;
            resources.updateConfiguration(conf, null);
        }
        return result;
    }

    private LanguageUtils() {
    }

    static {
        LanguageUtils languageUtils;
        INSTANCE = languageUtils = new LanguageUtils();
    }
}

