/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android.network.request;

import com.recurly.android.RecurlyValidator;
import com.recurly.android.network.RecurlyError;
import com.recurly.android.network.request.GetRequest;
import java.util.HashMap;
import java.util.Map;

public class TaxRequest
extends GetRequest {
    private String postalCode;
    private String countryCode;

    public TaxRequest(String postalCode, String countryCode) {
        this.postalCode = postalCode;
        this.countryCode = countryCode;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Override
    public Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("postal_code", this.postalCode);
        params.put("country", this.countryCode);
        return params;
    }

    @Override
    public boolean isListRequest() {
        return true;
    }

    @Override
    public String getEndpoint() {
        return "tax";
    }

    @Override
    public RecurlyError validate() {
        if (this.postalCode == null || this.postalCode.isEmpty()) {
            return RecurlyError.validationError("postal code");
        }
        if (this.countryCode == null || this.countryCode.isEmpty() || !RecurlyValidator.validateCountryCode(this.countryCode)) {
            return RecurlyError.validationError("country code");
        }
        return null;
    }

    public static class Builder {
        private String mPostalCode;
        private String mCountryCode;

        public Builder setPostalCode(String postalCode) {
            this.mPostalCode = postalCode;
            return this;
        }

        public Builder setCountryCode(String countryCode) {
            this.mCountryCode = countryCode;
            return this;
        }

        public TaxRequest build() {
            return new TaxRequest(this.mPostalCode, this.mCountryCode);
        }
    }
}

