/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android.network.request;

import com.recurly.android.network.RecurlyError;
import com.recurly.android.network.request.GetRequest;
import java.util.HashMap;
import java.util.Map;

public class PlanRequest
extends GetRequest {
    private String planCode;

    public PlanRequest(String planCode) {
        this.planCode = planCode;
    }

    public String getPlanCode() {
        return this.planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    @Override
    public Map<String, String> getParams() {
        return new HashMap<String, String>();
    }

    @Override
    public boolean isListRequest() {
        return false;
    }

    @Override
    public String getEndpoint() {
        return "plans/" + this.planCode;
    }

    @Override
    public RecurlyError validate() {
        if (this.planCode == null || this.planCode.isEmpty()) {
            return RecurlyError.validationError("plan code");
        }
        return null;
    }

    public static class Builder {
        private String mPlanCode;

        public Builder setPlanCode(String planCode) {
            this.mPlanCode = planCode;
            return this;
        }

        public PlanRequest build() {
            return new PlanRequest(this.mPlanCode);
        }
    }
}

