/*
 * Decompiled with CFR 0.152.
 */
package us.monoid.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import us.monoid.web.Resty;

public abstract class AbstractResource
extends Resty {
    protected URLConnection urlConnection;
    protected InputStream inputStream;

    public AbstractResource(Resty.Option ... options) {
        super(options);
    }

    abstract String getAcceptedTypes();

    void fill(URLConnection anUrlConnection) throws IOException {
        this.urlConnection = anUrlConnection;
        this.inputStream = anUrlConnection.getInputStream();
    }

    public URLConnection getUrlConnection() {
        return this.urlConnection;
    }

    public HttpURLConnection http() {
        return (HttpURLConnection)this.urlConnection;
    }

    public InputStream stream() {
        return this.inputStream;
    }

    public boolean status(int responseCode) {
        if (this.urlConnection instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)this.urlConnection;
            try {
                return http.getResponseCode() == responseCode;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public URI location() {
        String loc = this.http().getHeaderField("Location");
        if (loc != null) {
            return URI.create(loc);
        }
        return null;
    }
}

