/*
 * Decompiled with CFR 0.152.
 */
package us.monoid.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.xml.xpath.XPathException;
import us.monoid.json.JSONObject;
import us.monoid.web.AbstractContent;
import us.monoid.web.AbstractResource;
import us.monoid.web.BinaryResource;
import us.monoid.web.Content;
import us.monoid.web.Deletion;
import us.monoid.web.FormContent;
import us.monoid.web.FormData;
import us.monoid.web.JSONPathQuery;
import us.monoid.web.JSONResource;
import us.monoid.web.Replacement;
import us.monoid.web.TextResource;
import us.monoid.web.XMLResource;
import us.monoid.web.XPathQuery;
import us.monoid.web.auth.RestyAuthenticator;
import us.monoid.web.mime.MultipartContent;

public class Resty {
    protected static String MOZILLA = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.6; en-US; rv:1.9.2.13) Gecko/20101203 Firefox/3.6.13";
    protected static String DEFAULT_USER_AGENT = "Resty/0.1 (Java)";
    static RestyAuthenticator rath = new RestyAuthenticator();
    protected String userAgent = DEFAULT_USER_AGENT;

    public void authenticate(URI aSite, String aLogin, char[] aPwd) {
        rath.addSite(aSite, aLogin, aPwd);
    }

    public void authenticate(String string, String aLogin, char[] charArray) {
        this.authenticate(URI.create(string), aLogin, charArray);
    }

    public Resty identifyAsMozilla() {
        this.userAgent = MOZILLA;
        return this;
    }

    public Resty identifyAsResty() {
        this.userAgent = DEFAULT_USER_AGENT;
        return this;
    }

    public JSONResource json(String string) throws IOException {
        return this.json(URI.create(string));
    }

    public JSONResource json(URI anUri) throws IOException {
        return this.doGET(anUri, new JSONResource());
    }

    public JSONResource json(URI anUri, AbstractContent requestContent) throws IOException {
        return this.doPOSTOrPUT(anUri, requestContent, new JSONResource());
    }

    public JSONResource json(String anUri, AbstractContent content) throws IOException {
        return this.json(URI.create(anUri), content);
    }

    public TextResource text(URI anUri) throws IOException {
        return this.doGET(anUri, new TextResource());
    }

    public TextResource text(URI anUri, AbstractContent content) throws IOException {
        return this.doPOSTOrPUT(anUri, content, new TextResource());
    }

    public TextResource text(String anUri) throws IOException {
        return this.text(URI.create(anUri));
    }

    public TextResource text(String anUri, AbstractContent content) throws IOException {
        return this.text(URI.create(anUri), content);
    }

    public XMLResource xml(String string) throws IOException {
        return this.xml(URI.create(string));
    }

    public XMLResource xml(URI anUri) throws IOException {
        return this.doGET(anUri, new XMLResource());
    }

    public XMLResource xml(URI anUri, AbstractContent requestContent) throws IOException {
        return this.doPOSTOrPUT(anUri, requestContent, new XMLResource());
    }

    public XMLResource xml(String anUri, AbstractContent content) throws IOException {
        return this.xml(URI.create(anUri), content);
    }

    public BinaryResource bytes(String anUri) throws IOException {
        return this.bytes(URI.create(anUri));
    }

    public BinaryResource bytes(URI anUri) throws IOException {
        return this.doGET(anUri, new BinaryResource());
    }

    public BinaryResource bytes(String anUri, AbstractContent someContent) throws IOException {
        return this.bytes(URI.create(anUri), someContent);
    }

    public BinaryResource bytes(URI anUri, AbstractContent someContent) throws IOException {
        return this.doPOSTOrPUT(anUri, someContent, new BinaryResource());
    }

    protected <T extends AbstractResource> T doGET(URI anUri, T resource) throws IOException {
        URLConnection con = this.openConnection(anUri, resource);
        return this.fillResourceFromURL(con, resource);
    }

    protected <T extends AbstractResource> T doPOSTOrPUT(URI anUri, AbstractContent requestContent, T resource) throws IOException {
        URLConnection con = this.openConnection(anUri, resource);
        requestContent.addContent(con);
        return this.fillResourceFromURL(con, resource);
    }

    protected <T extends AbstractResource> URLConnection openConnection(URI anUri, T resource) throws IOException, MalformedURLException {
        URLConnection con = anUri.toURL().openConnection();
        this.addStandardHeaders(con, resource);
        return con;
    }

    protected <T extends AbstractResource> void addStandardHeaders(URLConnection con, T resource) {
        con.setRequestProperty("User-Agent", this.userAgent);
        con.setRequestProperty("Accept", resource.getAcceptedTypes());
    }

    protected <T extends AbstractResource> T fillResourceFromURL(URLConnection con, T resource) throws IOException {
        resource.fill(con);
        return resource;
    }

    public static JSONPathQuery path(String string) {
        return new JSONPathQuery(string);
    }

    public static XPathQuery xpath(String anXPathExpression) throws XPathException {
        return new XPathQuery(anXPathExpression);
    }

    public static Content content(JSONObject someJson) {
        Content c = null;
        try {
            c = new Content("application/json; charset=UTF-8", someJson.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return c;
    }

    public static Content content(String somePlainText) {
        Content c = null;
        try {
            c = new Content("text/plain; charset=UTF-8", somePlainText.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return c;
    }

    public static Content content(byte[] bytes) {
        return new Content("application/octet-stream", bytes);
    }

    public static FormContent form(String query) {
        FormContent fc = new FormContent(query);
        return fc;
    }

    public static MultipartContent form(FormData ... formData) {
        MultipartContent mc = new MultipartContent("form-data", formData);
        return mc;
    }

    public static FormData data(String name, String plainTextValue) {
        return Resty.data(name, Resty.content(plainTextValue));
    }

    public static FormData data(String name, AbstractContent content) {
        return new FormData(name, content);
    }

    public static String enc(String unencodedString) {
        try {
            return URLEncoder.encode(unencodedString, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static AbstractContent put(Content someContent) {
        return new Replacement(someContent);
    }

    public static AbstractContent delete() {
        return new Deletion();
    }

    static {
        CookieHandler.setDefault(new CookieManager());
        Authenticator.setDefault(rath);
    }
}

