/*
 * Decompiled with CFR 0.152.
 */
package us.monoid.web.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RestyAuthenticator
extends Authenticator {
    List<Site> sites = Collections.synchronizedList(new ArrayList());

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        URL requestURL = this.getRequestingURL();
        try {
            String uri = requestURL.toURI().normalize().toString();
            Site site = this.findBestMatch(uri);
            if (site != null) {
                return new PasswordAuthentication(site.login, site.pwd);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public void addSite(URI aRootUrl, String login, char[] pwd) {
        String rootUri = aRootUrl.normalize().toString();
        boolean replaced = false;
        for (Site site : this.sites) {
            if (!site.root.equals(rootUri)) continue;
            site.login = login;
            site.pwd = pwd;
            replaced = true;
            break;
        }
        if (!replaced) {
            Site s = new Site();
            s.root = rootUri;
            s.login = login;
            s.pwd = pwd;
            this.sites.add(s);
        }
    }

    private Site findBestMatch(String uri) {
        int max = 0;
        Site bestSite = null;
        for (Site s : this.sites) {
            int prefixLength = s.match(uri);
            if (prefixLength <= max) continue;
            max = prefixLength;
            bestSite = s;
        }
        return bestSite;
    }

    static class Site {
        String root;
        String login;
        char[] pwd;

        Site() {
        }

        public int match(String uri) {
            if (uri.startsWith(this.root)) {
                return this.root.length();
            }
            return 0;
        }
    }
}

