/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.engine.featherstone;

import java.util.ArrayList;
import java.util.Collection;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.robotDescription.Plane;
import us.ihmc.simulationconstructionset.FloatingPlanarJoint;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.GroundContactPointGroup;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.KinematicPoint;
import us.ihmc.simulationconstructionset.SpatialVector;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.JointPhysics;

public class FloatingPlanarJointPhysics
extends JointPhysics<FloatingPlanarJoint> {
    private double[] k_qdd_t1 = new double[4];
    private double[] k_qdd_t2 = new double[4];
    private double[] k_qd_t1 = new double[4];
    private double[] k_qd_t2 = new double[4];
    private double[] k_qdd_rot = new double[4];
    private double[] k_qd_rot = new double[4];
    private double q_t1_n;
    private double q_t2_n;
    private double qd_t1_n;
    private double qd_t2_n;
    private double q_rot_n;
    private double qd_rot_n;
    private Vector3D wdXr = new Vector3D();
    private Vector3D wXr = new Vector3D();
    private Vector3D wXwXr = new Vector3D();
    private Vector3D delta_qd_xyz = new Vector3D();
    private DMatrixRMaj I_hat_matrix = new DMatrixRMaj(3, 3);
    private DMatrixRMaj Z_hat_matrix = new DMatrixRMaj(3, 1);
    private DMatrixRMaj a_hat_matrix = new DMatrixRMaj(3, 1);
    private final Vector3D a_hat_world_bot = new Vector3D();
    private DMatrixRMaj Y_hat_matrix = new DMatrixRMaj(3, 1);
    private DMatrixRMaj I_hat_inverse = new DMatrixRMaj(3, 3);

    public FloatingPlanarJointPhysics(FloatingPlanarJoint owner) {
        super(owner);
    }

    @Override
    protected void jointDependentChangeVelocity(double delta_qd) {
        System.err.println("Error!!!! FloatingPlanarJoint.jointDependentChangeVelocity should never be called!!!");
    }

    @Override
    public void featherstonePassOne(Vector3DReadOnly w_h, Vector3DReadOnly v_h, RotationMatrixReadOnly Rh_0) {
        this.jointDependentSetAndGetRotation((RotationMatrixBasics)this.Ri_0);
        this.Ri_0.prepend((Orientation3DReadOnly)((FloatingPlanarJoint)this.owner).getOffsetTransform3D().getRotation());
        this.Ri_0.transpose();
        this.Rh_i = null;
        this.Ri_h = null;
        this.d_i = null;
        this.u_iXd_i = null;
        this.r_i = null;
        this.jointDependentFeatherstonePassOne();
        this.R0_i.set(this.Ri_0);
        this.R0_i.transpose();
        if (this.groundContactPointGroups != null) {
            Collection groups = this.groundContactPointGroups.values();
            for (GroundContactPointGroup groundContactPointGroup : groups) {
                ArrayList<GroundContactPoint> groundContactPoints = groundContactPointGroup.getGroundContactPointsInContact();
                for (int i = 0; i < groundContactPoints.size(); ++i) {
                    GroundContactPoint point = groundContactPoints.get(i);
                    point.updatePointVelocity((RotationMatrixReadOnly)this.R0_i, (Vector3DReadOnly)((FloatingPlanarJoint)this.owner).link.comOffset, (Vector3DReadOnly)this.v_i, (Vector3DReadOnly)this.w_i);
                }
            }
        }
        if (this.kinematicPoints != null) {
            for (int i = 0; i < this.kinematicPoints.size(); ++i) {
                KinematicPoint point = (KinematicPoint)this.kinematicPoints.get(i);
                point.updatePointVelocity((RotationMatrixReadOnly)this.R0_i, (Vector3DReadOnly)((FloatingPlanarJoint)this.owner).link.comOffset, (Vector3DReadOnly)this.v_i, (Vector3DReadOnly)this.w_i);
            }
        }
        for (int i = 0; i < ((FloatingPlanarJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingPlanarJoint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassOne((Vector3DReadOnly)this.w_i, (Vector3DReadOnly)this.v_i, (RotationMatrixReadOnly)this.Ri_0);
        }
    }

    @Override
    protected void jointDependentFeatherstonePassOne() {
        this.Q_i = 0.0;
        if (((FloatingPlanarJoint)this.owner).type == Plane.YZ) {
            this.w_i.set(((FloatingPlanarJoint)this.owner).qd_rot.getDoubleValue(), 0.0, 0.0);
            this.v_i.set(0.0, ((FloatingPlanarJoint)this.owner).qd_t1.getDoubleValue(), ((FloatingPlanarJoint)this.owner).qd_t2.getDoubleValue());
        } else if (((FloatingPlanarJoint)this.owner).type == Plane.XZ) {
            this.w_i.set(0.0, ((FloatingPlanarJoint)this.owner).qd_rot.getDoubleValue(), 0.0);
            this.v_i.set(((FloatingPlanarJoint)this.owner).qd_t1.getDoubleValue(), 0.0, ((FloatingPlanarJoint)this.owner).qd_t2.getDoubleValue());
        } else {
            this.w_i.set(0.0, 0.0, ((FloatingPlanarJoint)this.owner).qd_rot.getDoubleValue());
            this.v_i.set(((FloatingPlanarJoint)this.owner).qd_t1.getDoubleValue(), ((FloatingPlanarJoint)this.owner).qd_t2.getDoubleValue(), 0.0);
        }
        this.Ri_0.transform((Tuple3DBasics)this.w_i);
        this.Ri_0.transform((Tuple3DBasics)this.v_i);
    }

    @Override
    protected void jointDependentSet_d_i() {
        System.err.println("Error!!!! FloatingPlanarJoint.jointDependentSet_d_i should never be called!!!");
    }

    @Override
    protected void jointDependentFeatherstonePassTwo(Vector3DReadOnly w_h) {
        this.c_hat_i.top = null;
        this.c_hat_i.bottom = null;
        this.s_hat_i.top = null;
        this.s_hat_i.bottom = null;
    }

    @Override
    public void featherstonePassThree() {
        for (int i = 0; i < ((FloatingPlanarJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingPlanarJoint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassThree(this.I_hat_i, this.Z_hat_i);
        }
    }

    @Override
    public void featherstonePassFour(SpatialVector a_hat_h, int passNumber) throws UnreasonableAccelerationException {
        if (((FloatingPlanarJoint)this.owner).type == Plane.XY) {
            this.I_hat_i.getPlanarXYMatrix((DMatrix)this.I_hat_matrix);
            CommonOps_DDRM.invert((DMatrixRMaj)this.I_hat_matrix, (DMatrixRMaj)this.I_hat_inverse);
            this.Z_hat_i.getPlanarXYMatrix((DMatrix)this.Z_hat_matrix);
            CommonOps_DDRM.mult((DMatrix1Row)this.I_hat_inverse, (DMatrix1Row)this.Z_hat_matrix, (DMatrix1Row)this.a_hat_matrix);
            this.a_hat_i.top.set(0.0, 0.0, -this.a_hat_matrix.get(0, 0));
            this.a_hat_i.bottom.set(-this.a_hat_matrix.get(1, 0), -this.a_hat_matrix.get(2, 0), 0.0);
        } else if (((FloatingPlanarJoint)this.owner).type == Plane.XZ) {
            this.I_hat_i.getPlanarXZMatrix((DMatrix)this.I_hat_matrix);
            CommonOps_DDRM.invert((DMatrixRMaj)this.I_hat_matrix, (DMatrixRMaj)this.I_hat_inverse);
            this.Z_hat_i.getPlanarXZMatrix((DMatrix)this.Z_hat_matrix);
            CommonOps_DDRM.mult((DMatrix1Row)this.I_hat_inverse, (DMatrix1Row)this.Z_hat_matrix, (DMatrix1Row)this.a_hat_matrix);
            this.a_hat_i.top.set(0.0, -this.a_hat_matrix.get(0, 0), 0.0);
            this.a_hat_i.bottom.set(-this.a_hat_matrix.get(1, 0), 0.0, -this.a_hat_matrix.get(2, 0));
        } else {
            this.I_hat_i.getPlanarYZMatrix((DMatrix)this.I_hat_matrix);
            CommonOps_DDRM.invert((DMatrixRMaj)this.I_hat_matrix, (DMatrixRMaj)this.I_hat_inverse);
            this.Z_hat_i.getPlanarYZMatrix((DMatrix)this.Z_hat_matrix);
            CommonOps_DDRM.mult((DMatrix1Row)this.I_hat_inverse, (DMatrix1Row)this.Z_hat_matrix, (DMatrix1Row)this.a_hat_matrix);
            this.a_hat_i.top.set(-this.a_hat_matrix.get(0, 0), 0.0, 0.0);
            this.a_hat_i.bottom.set(0.0, -this.a_hat_matrix.get(1, 0), -this.a_hat_matrix.get(2, 0));
        }
        this.R0_i.set(this.Ri_0);
        this.R0_i.transpose();
        this.a_hat_world_bot.set(this.a_hat_i.bottom);
        this.wXr.cross((Tuple3DReadOnly)this.w_i, (Tuple3DReadOnly)((FloatingPlanarJoint)this.owner).link.comOffset);
        this.wXwXr.cross((Tuple3DReadOnly)this.w_i, (Tuple3DReadOnly)this.wXr);
        this.wdXr.cross((Tuple3DReadOnly)this.a_hat_i.top, (Tuple3DReadOnly)((FloatingPlanarJoint)this.owner).link.comOffset);
        this.a_hat_world_bot.sub((Tuple3DReadOnly)this.wdXr);
        this.a_hat_world_bot.sub((Tuple3DReadOnly)this.wXwXr);
        this.R0_i.transform((Tuple3DBasics)this.a_hat_world_bot);
        if (((FloatingPlanarJoint)this.owner).type == Plane.YZ) {
            ((FloatingPlanarJoint)this.owner).qdd_t1.set(this.a_hat_world_bot.getY());
            ((FloatingPlanarJoint)this.owner).qdd_t2.set(this.a_hat_world_bot.getZ());
            ((FloatingPlanarJoint)this.owner).qdd_rot.set(this.a_hat_i.top.getX());
        } else if (((FloatingPlanarJoint)this.owner).type == Plane.XZ) {
            ((FloatingPlanarJoint)this.owner).qdd_t1.set(this.a_hat_world_bot.getX());
            ((FloatingPlanarJoint)this.owner).qdd_t2.set(this.a_hat_world_bot.getZ());
            ((FloatingPlanarJoint)this.owner).qdd_rot.set(this.a_hat_i.top.getY());
        } else {
            ((FloatingPlanarJoint)this.owner).qdd_t1.set(this.a_hat_world_bot.getX());
            ((FloatingPlanarJoint)this.owner).qdd_t2.set(this.a_hat_world_bot.getY());
            ((FloatingPlanarJoint)this.owner).qdd_rot.set(this.a_hat_i.top.getZ());
        }
        this.k_qdd_t1[passNumber] = ((FloatingPlanarJoint)this.owner).qdd_t1.getDoubleValue();
        this.k_qdd_t2[passNumber] = ((FloatingPlanarJoint)this.owner).qdd_t2.getDoubleValue();
        this.k_qd_t1[passNumber] = ((FloatingPlanarJoint)this.owner).qd_t1.getDoubleValue();
        this.k_qd_t2[passNumber] = ((FloatingPlanarJoint)this.owner).qd_t2.getDoubleValue();
        this.k_qdd_rot[passNumber] = ((FloatingPlanarJoint)this.owner).qdd_rot.getDoubleValue();
        this.k_qd_rot[passNumber] = ((FloatingPlanarJoint)this.owner).qd_rot.getDoubleValue();
        if (!this.jointDependentVerifyReasonableAccelerations()) {
            ArrayList<Joint> unreasonableAccelerationJoints = new ArrayList<Joint>();
            unreasonableAccelerationJoints.add(this.owner);
            throw new UnreasonableAccelerationException(unreasonableAccelerationJoints);
        }
        for (int i = 0; i < ((FloatingPlanarJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingPlanarJoint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassFour(this.a_hat_i, passNumber);
        }
    }

    @Override
    protected void jointDependentRecordK(int passNumber) {
        this.k_qdd_t1[passNumber] = ((FloatingPlanarJoint)this.owner).qdd_t1.getDoubleValue();
        this.k_qdd_t2[passNumber] = ((FloatingPlanarJoint)this.owner).qdd_t2.getDoubleValue();
        this.k_qd_t1[passNumber] = ((FloatingPlanarJoint)this.owner).qd_t1.getDoubleValue();
        this.k_qd_t2[passNumber] = ((FloatingPlanarJoint)this.owner).qd_t2.getDoubleValue();
        this.k_qdd_rot[passNumber] = ((FloatingPlanarJoint)this.owner).qdd_rot.getDoubleValue();
        this.k_qd_rot[passNumber] = ((FloatingPlanarJoint)this.owner).qd_rot.getDoubleValue();
    }

    @Override
    protected void jointDependentFeatherstonePassFour(double Q, int passNumber) {
    }

    @Override
    public void recursiveEulerIntegrate(double stepSize) {
        ((FloatingPlanarJoint)this.owner).q_t1.set(this.q_t1_n + ((FloatingPlanarJoint)this.owner).qd_t1.getDoubleValue() * stepSize);
        ((FloatingPlanarJoint)this.owner).q_t2.set(this.q_t2_n + ((FloatingPlanarJoint)this.owner).qd_t2.getDoubleValue() * stepSize);
        ((FloatingPlanarJoint)this.owner).q_rot.set(this.q_rot_n + ((FloatingPlanarJoint)this.owner).qd_rot.getDoubleValue() * stepSize);
        ((FloatingPlanarJoint)this.owner).qd_t1.set(this.qd_t1_n + ((FloatingPlanarJoint)this.owner).qdd_t1.getDoubleValue() * stepSize);
        ((FloatingPlanarJoint)this.owner).qd_t2.set(this.qd_t2_n + ((FloatingPlanarJoint)this.owner).qdd_t2.getDoubleValue() * stepSize);
        ((FloatingPlanarJoint)this.owner).qd_rot.set(this.qd_rot_n + ((FloatingPlanarJoint)this.owner).qdd_rot.getDoubleValue() * stepSize);
        for (int i = 0; i < ((FloatingPlanarJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingPlanarJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveEulerIntegrate(stepSize);
        }
    }

    @Override
    public void recursiveRungeKuttaSum(double stepSize) {
        ((FloatingPlanarJoint)this.owner).q_t1.set(this.q_t1_n + stepSize * (this.k_qd_t1[0] / 6.0 + this.k_qd_t1[1] / 3.0 + this.k_qd_t1[2] / 3.0 + this.k_qd_t1[3] / 6.0));
        ((FloatingPlanarJoint)this.owner).q_t2.set(this.q_t2_n + stepSize * (this.k_qd_t2[0] / 6.0 + this.k_qd_t2[1] / 3.0 + this.k_qd_t2[2] / 3.0 + this.k_qd_t2[3] / 6.0));
        ((FloatingPlanarJoint)this.owner).q_rot.set(this.q_rot_n + stepSize * (this.k_qd_rot[0] / 6.0 + this.k_qd_rot[1] / 3.0 + this.k_qd_rot[2] / 3.0 + this.k_qd_rot[3] / 6.0));
        ((FloatingPlanarJoint)this.owner).qd_t1.set(this.qd_t1_n + stepSize * (this.k_qdd_t1[0] / 6.0 + this.k_qdd_t1[1] / 3.0 + this.k_qdd_t1[2] / 3.0 + this.k_qdd_t1[3] / 6.0));
        ((FloatingPlanarJoint)this.owner).qd_t2.set(this.qd_t2_n + stepSize * (this.k_qdd_t2[0] / 6.0 + this.k_qdd_t2[1] / 3.0 + this.k_qdd_t2[2] / 3.0 + this.k_qdd_t2[3] / 6.0));
        ((FloatingPlanarJoint)this.owner).qd_rot.set(this.qd_rot_n + stepSize * (this.k_qdd_rot[0] / 6.0 + this.k_qdd_rot[1] / 3.0 + this.k_qdd_rot[2] / 3.0 + this.k_qdd_rot[3] / 6.0));
        for (int i = 0; i < ((FloatingPlanarJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingPlanarJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveRungeKuttaSum(stepSize);
        }
    }

    @Override
    public void recursiveSaveTempState() {
        this.q_t1_n = ((FloatingPlanarJoint)this.owner).q_t1.getDoubleValue();
        this.q_t2_n = ((FloatingPlanarJoint)this.owner).q_t2.getDoubleValue();
        this.q_rot_n = ((FloatingPlanarJoint)this.owner).q_rot.getDoubleValue();
        this.qd_t1_n = ((FloatingPlanarJoint)this.owner).qd_t1.getDoubleValue();
        this.qd_t2_n = ((FloatingPlanarJoint)this.owner).qd_t2.getDoubleValue();
        this.qd_rot_n = ((FloatingPlanarJoint)this.owner).qd_rot.getDoubleValue();
        for (int i = 0; i < ((FloatingPlanarJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingPlanarJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveSaveTempState();
        }
    }

    @Override
    public void recursiveRestoreTempState() {
        ((FloatingPlanarJoint)this.owner).q_t1.set(this.q_t1_n);
        ((FloatingPlanarJoint)this.owner).q_t2.set(this.q_t2_n);
        ((FloatingPlanarJoint)this.owner).q_rot.set(this.q_rot_n);
        ((FloatingPlanarJoint)this.owner).qd_t1.set(this.qd_t1_n);
        ((FloatingPlanarJoint)this.owner).qd_t2.set(this.qd_t2_n);
        ((FloatingPlanarJoint)this.owner).qd_rot.set(this.qd_rot_n);
        for (int i = 0; i < ((FloatingPlanarJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((FloatingPlanarJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveRestoreTempState();
        }
    }

    @Override
    protected void impulseResponseComputeDeltaV(SpatialVector delta_v_parent, SpatialVector delta_v_me) {
        if (((FloatingPlanarJoint)this.owner).type == Plane.XY) {
            this.Y_hat_i.getPlanarXYMatrix((DMatrix)this.Y_hat_matrix);
            CommonOps_DDRM.mult((DMatrix1Row)this.I_hat_inverse, (DMatrix1Row)this.Y_hat_matrix, (DMatrix1Row)this.a_hat_matrix);
            delta_v_me.top.set(0.0, 0.0, -this.a_hat_matrix.get(0, 0));
            delta_v_me.bottom.set(-this.a_hat_matrix.get(1, 0), -this.a_hat_matrix.get(2, 0), 0.0);
        } else if (((FloatingPlanarJoint)this.owner).type == Plane.XZ) {
            this.Y_hat_i.getPlanarXZMatrix((DMatrix)this.Y_hat_matrix);
            CommonOps_DDRM.mult((DMatrix1Row)this.I_hat_inverse, (DMatrix1Row)this.Y_hat_matrix, (DMatrix1Row)this.a_hat_matrix);
            delta_v_me.top.set(0.0, -this.a_hat_matrix.get(0, 0), 0.0);
            delta_v_me.bottom.set(-this.a_hat_matrix.get(1, 0), 0.0, -this.a_hat_matrix.get(2, 0));
        } else {
            this.Y_hat_i.getPlanarYZMatrix((DMatrix)this.Y_hat_matrix);
            CommonOps_DDRM.mult((DMatrix1Row)this.I_hat_inverse, (DMatrix1Row)this.Y_hat_matrix, (DMatrix1Row)this.a_hat_matrix);
            delta_v_me.top.set(-this.a_hat_matrix.get(0, 0), 0.0, 0.0);
            delta_v_me.bottom.set(0.0, -this.a_hat_matrix.get(1, 0), -this.a_hat_matrix.get(2, 0));
        }
    }

    @Override
    protected void propagateImpulseSetDeltaVOnPath(SpatialVector delta_v_parent, SpatialVector delta_v_me) {
        if (((FloatingPlanarJoint)this.owner).type == Plane.XY) {
            this.Y_hat_i.getPlanarXYMatrix((DMatrix)this.Y_hat_matrix);
            CommonOps_DDRM.mult((DMatrix1Row)this.I_hat_inverse, (DMatrix1Row)this.Y_hat_matrix, (DMatrix1Row)this.a_hat_matrix);
            delta_v_me.top.set(0.0, 0.0, -this.a_hat_matrix.get(0, 0));
            delta_v_me.bottom.set(-this.a_hat_matrix.get(1, 0), -this.a_hat_matrix.get(2, 0), 0.0);
            this.delta_qd_xyz.set(delta_v_me.bottom);
            this.R0_i.transform((Tuple3DBasics)this.delta_qd_xyz);
            ((FloatingPlanarJoint)this.owner).qd_rot.set(((FloatingPlanarJoint)this.owner).qd_rot.getDoubleValue() + delta_v_me.top.getZ());
            ((FloatingPlanarJoint)this.owner).qd_t1.set(((FloatingPlanarJoint)this.owner).qd_t1.getDoubleValue() + this.delta_qd_xyz.getX());
            ((FloatingPlanarJoint)this.owner).qd_t2.set(((FloatingPlanarJoint)this.owner).qd_t2.getDoubleValue() + this.delta_qd_xyz.getY());
        } else if (((FloatingPlanarJoint)this.owner).type == Plane.XZ) {
            this.Y_hat_i.getPlanarXZMatrix((DMatrix)this.Y_hat_matrix);
            CommonOps_DDRM.mult((DMatrix1Row)this.I_hat_inverse, (DMatrix1Row)this.Y_hat_matrix, (DMatrix1Row)this.a_hat_matrix);
            delta_v_me.top.set(0.0, -this.a_hat_matrix.get(0, 0), 0.0);
            delta_v_me.bottom.set(-this.a_hat_matrix.get(1, 0), 0.0, -this.a_hat_matrix.get(2, 0));
            this.delta_qd_xyz.set(delta_v_me.bottom);
            this.R0_i.transform((Tuple3DBasics)this.delta_qd_xyz);
            ((FloatingPlanarJoint)this.owner).qd_rot.set(((FloatingPlanarJoint)this.owner).qd_rot.getDoubleValue() + delta_v_me.top.getY());
            ((FloatingPlanarJoint)this.owner).qd_t1.set(((FloatingPlanarJoint)this.owner).qd_t1.getDoubleValue() + this.delta_qd_xyz.getX());
            ((FloatingPlanarJoint)this.owner).qd_t2.set(((FloatingPlanarJoint)this.owner).qd_t2.getDoubleValue() + this.delta_qd_xyz.getZ());
        } else {
            this.Y_hat_i.getPlanarYZMatrix((DMatrix)this.Y_hat_matrix);
            CommonOps_DDRM.mult((DMatrix1Row)this.I_hat_inverse, (DMatrix1Row)this.Y_hat_matrix, (DMatrix1Row)this.a_hat_matrix);
            delta_v_me.top.set(-this.a_hat_matrix.get(0, 0), 0.0, 0.0);
            delta_v_me.bottom.set(0.0, -this.a_hat_matrix.get(1, 0), -this.a_hat_matrix.get(2, 0));
            this.delta_qd_xyz.set(delta_v_me.bottom);
            this.R0_i.transform((Tuple3DBasics)this.delta_qd_xyz);
            ((FloatingPlanarJoint)this.owner).qd_rot.set(((FloatingPlanarJoint)this.owner).qd_rot.getDoubleValue() + delta_v_me.top.getX());
            ((FloatingPlanarJoint)this.owner).qd_t1.set(((FloatingPlanarJoint)this.owner).qd_t1.getDoubleValue() + this.delta_qd_xyz.getY());
            ((FloatingPlanarJoint)this.owner).qd_t2.set(((FloatingPlanarJoint)this.owner).qd_t2.getDoubleValue() + this.delta_qd_xyz.getZ());
        }
    }

    @Override
    protected boolean jointDependentVerifyReasonableAccelerations() {
        if (Math.abs(((FloatingPlanarJoint)this.owner).qdd_t1.getDoubleValue()) > 1.0E12) {
            return false;
        }
        if (Math.abs(((FloatingPlanarJoint)this.owner).qdd_t2.getDoubleValue()) > 1.0E12) {
            return false;
        }
        return !(Math.abs(((FloatingPlanarJoint)this.owner).qdd_rot.getDoubleValue()) > 1.0E7);
    }

    @Override
    protected void jointDependentSetAndGetRotation(RotationMatrixBasics Rh_i) {
        Rh_i.setIdentity();
        if (((FloatingPlanarJoint)this.owner).type == Plane.YZ) {
            Rh_i.setToRollOrientation(((FloatingPlanarJoint)this.owner).q_rot.getDoubleValue());
        } else if (((FloatingPlanarJoint)this.owner).type == Plane.XZ) {
            Rh_i.setToPitchOrientation(((FloatingPlanarJoint)this.owner).q_rot.getDoubleValue());
        } else {
            Rh_i.setToYawOrientation(((FloatingPlanarJoint)this.owner).q_rot.getDoubleValue());
        }
    }
}

