/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.hierarchyTree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import us.ihmc.yoVariables.registry.YoRegistry;

public class NamespaceHierarchyNodeRenderer
extends JPanel
implements TreeCellRenderer {
    private static final long serialVersionUID = -6793795042915360102L;
    protected TreeLabel label;
    private final HashMap<DefaultMutableTreeNode, YoRegistry> treeNodeRegistryMap;

    public NamespaceHierarchyNodeRenderer(HashMap<DefaultMutableTreeNode, YoRegistry> treeNodeRegistryMap) {
        this.setLayout(null);
        this.label = new TreeLabel();
        this.add(this.label);
        this.label.setForeground(UIManager.getColor("Tree.textForeground"));
        this.treeNodeRegistryMap = treeNodeRegistryMap;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value != null) {
            String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
            this.setEnabled(tree.isEnabled());
            this.label.setFont(tree.getFont());
            this.label.setText(stringValue);
            this.label.setSelected(isSelected);
            this.label.setFocus(hasFocus);
            if (leaf) {
                this.label.setIcon(UIManager.getIcon("Tree.leafIcon"));
            } else if (expanded) {
                this.label.setIcon(UIManager.getIcon("Tree.openIcon"));
            } else {
                this.label.setIcon(UIManager.getIcon("Tree.closedIcon"));
            }
        }
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension labelDimension = this.label.getPreferredSize();
        int nodeWidth = labelDimension.width;
        int nodeHeight = labelDimension.height;
        return new Dimension(nodeWidth, nodeHeight);
    }

    @Override
    public void doLayout() {
        Dimension labelDimension = this.label.getPreferredSize();
        boolean yCheck = false;
        int yLabel = 0;
        this.label.setLocation(0, yLabel);
        this.label.setBounds(0, yLabel, labelDimension.width, labelDimension.height);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    private static class TreeLabel
    extends JLabel {
        private static final long serialVersionUID = -1853871616367478400L;
        boolean isSelected;
        boolean hasFocus;

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        @Override
        public void paint(Graphics g) {
            String labelString = this.getText();
            if (labelString != null && labelString.length() > 0) {
                if (this.isSelected) {
                    g.setColor(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    g.setColor(UIManager.getColor("Tree.textBackground"));
                }
                Dimension d = this.getPreferredSize();
                int imageOffset = 0;
                Icon currentI = this.getIcon();
                if (currentI != null) {
                    imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                if (this.hasFocus) {
                    g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                    g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height - 1);
                }
            }
            super.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height);
            }
            return retDimension;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public void setFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }
    }
}

