/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraPropertiesHolder;
import us.ihmc.simulationconstructionset.gui.ActiveCameraHolder;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;

public class DollyCheckBox
extends JCheckBox
implements ActionListener {
    private static final String DOLLY = "Dolly";
    private static final long serialVersionUID = -6898471398304979545L;
    private ActiveCameraHolder cameraHolder;

    public DollyCheckBox(ActiveCameraHolder cameraHolder) {
        super(DOLLY);
        this.setName(DOLLY);
        this.cameraHolder = cameraHolder;
        CameraPropertiesHolder camera = cameraHolder.getCameraPropertiesForActiveCamera();
        this.setSelected(camera.isDolly());
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        CameraPropertiesHolder camera = this.cameraHolder.getCameraPropertiesForActiveCamera();
        camera.setDolly(this.isSelected());
    }

    public void makeCameraConsistent() {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CameraPropertiesHolder camera = DollyCheckBox.this.cameraHolder.getCameraPropertiesForActiveCamera();
                camera.setDolly(DollyCheckBox.this.isSelected());
            }
        });
    }

    public void makeCheckBoxConsistent() {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CameraPropertiesHolder camera = DollyCheckBox.this.cameraHolder.getCameraPropertiesForActiveCamera();
                if (camera != null) {
                    DollyCheckBox.this.setSelected(camera.isDolly());
                }
            }
        });
    }
}

