/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class IMUMount {
    private final String name;
    private RigidBodyTransform transformFromMountToJoint;
    private Joint parentJoint;
    private Robot robot;
    private final YoFrameVector3D angularVelocityInBody;
    private final YoFrameVector3D angularAccelerationInBody;
    private final YoFrameVector3D linearVelocityInBody;
    private final YoFrameVector3D linearVelocityInWorld;
    private final YoFrameVector3D linearAccelerationInBody;
    private final YoFrameVector3D linearAccelerationInWorld;
    private final YoFrameQuaternion orientation;
    private double accelerationGaussianNoiseMean = 0.0;
    private double accelerationGaussianNoiseStdDev = 0.0;
    private double accelerationGaussianBiasMean = 0.0;
    private double accelerationGaussianBiasStdDev = 0.0;
    private double angularVelocityGaussianNoiseMean = 0.0;
    private double angularVelocityGaussianNoiseStdDev = 0.0;
    private double angularVelocityGaussianBiasMean = 0.0;
    private double angularVelocityGaussianBiasStdDev = 0.0;
    private final RigidBodyTransform imuTransformToWorld = new RigidBodyTransform();
    private final Vector3D tempGravity = new Vector3D();

    public IMUMount(String name, RigidBodyTransform offset, Robot robot) {
        this.name = name;
        this.robot = robot;
        this.transformFromMountToJoint = new RigidBodyTransform((RigidBodyTransformReadOnly)offset);
        YoRegistry registry = robot.getRobotsYoRegistry();
        this.orientation = new YoFrameQuaternion(name + "Orientation", null, registry);
        this.linearVelocityInBody = new YoFrameVector3D(name + "LinearVelocity", null, registry);
        this.linearVelocityInWorld = new YoFrameVector3D(name + "LinearVelocityWorld", null, registry);
        this.angularVelocityInBody = new YoFrameVector3D(name + "AngularVelocity", null, registry);
        this.angularAccelerationInBody = new YoFrameVector3D(name + "AngularAcceleration", null, registry);
        this.linearAccelerationInBody = new YoFrameVector3D(name + "LinearAcceleration", null, registry);
        this.linearAccelerationInWorld = new YoFrameVector3D(name + "LinearAccelerationWorld", null, registry);
    }

    public String getName() {
        return this.name;
    }

    protected void setParentJoint(Joint parent) {
        this.parentJoint = parent;
    }

    public Joint getParentJoint() {
        return this.parentJoint;
    }

    protected void updateIMUMountPositionAndVelocity() {
        this.parentJoint.getTransformToWorld((RigidBodyTransformBasics)this.imuTransformToWorld);
        this.imuTransformToWorld.multiply((RigidBodyTransformReadOnly)this.transformFromMountToJoint);
        this.orientation.set((Orientation3DReadOnly)this.imuTransformToWorld.getRotation());
        this.parentJoint.physics.getLinearVelocityInBody((Vector3DBasics)this.linearVelocityInBody, this.transformFromMountToJoint.getTranslation());
        this.transformFromMountToJoint.inverseTransform((Vector3DBasics)this.linearVelocityInBody);
        this.imuTransformToWorld.transform((Vector3DReadOnly)this.linearVelocityInBody, (Vector3DBasics)this.linearVelocityInWorld);
        this.parentJoint.physics.getAngularVelocityInBody((Vector3DBasics)this.angularVelocityInBody);
        this.transformFromMountToJoint.inverseTransform((Vector3DBasics)this.angularVelocityInBody);
    }

    protected void updateIMUMountAcceleration() {
        this.parentJoint.getTransformToWorld((RigidBodyTransformBasics)this.imuTransformToWorld);
        this.imuTransformToWorld.multiply((RigidBodyTransformReadOnly)this.transformFromMountToJoint);
        this.parentJoint.physics.getLinearAccelerationInBody((Vector3DBasics)this.linearAccelerationInBody, this.transformFromMountToJoint.getTranslation());
        this.transformFromMountToJoint.inverseTransform((Vector3DBasics)this.linearAccelerationInBody);
        this.robot.getGravity(this.tempGravity);
        this.tempGravity.scale(-1.0);
        this.imuTransformToWorld.inverseTransform((Vector3DBasics)this.tempGravity);
        this.linearAccelerationInBody.add((Tuple3DReadOnly)this.tempGravity);
        this.parentJoint.physics.getLinearAccelerationInWorld((Vector3DBasics)this.linearAccelerationInWorld, this.transformFromMountToJoint.getTranslation());
        this.robot.getGravity(this.tempGravity);
        this.tempGravity.scale(-1.0);
        this.linearAccelerationInWorld.add((Tuple3DReadOnly)this.tempGravity);
        this.parentJoint.physics.getAngularAccelerationsInBodyFrame((Vector3DBasics)this.angularAccelerationInBody);
        this.transformFromMountToJoint.inverseTransform((Vector3DBasics)this.angularAccelerationInBody);
    }

    public void setOrientation(Quaternion orientation) {
        this.orientation.set((QuaternionReadOnly)orientation);
    }

    public void getOrientation(Quaternion orientationToPack) {
        orientationToPack.set((QuaternionReadOnly)this.orientation);
    }

    public void getOrientation(RotationMatrix rotationMatrixToPack) {
        rotationMatrixToPack.set((Orientation3DReadOnly)this.orientation);
    }

    public void setAngularVelocityInBody(Vector3D angularVelocityInBody) {
        this.angularVelocityInBody.set((Tuple3DReadOnly)angularVelocityInBody);
    }

    public void getAngularVelocityInBody(Vector3D angularVelocityInBodyToPack) {
        angularVelocityInBodyToPack.set((Tuple3DReadOnly)this.angularVelocityInBody);
    }

    public void setAngularAccelerationInBody(Vector3D angularAccelerationInBody) {
        this.angularAccelerationInBody.set((Tuple3DReadOnly)angularAccelerationInBody);
    }

    public void getAngularAccelerationInBody(Vector3D angularAccelerationInBodyToPack) {
        angularAccelerationInBodyToPack.set((Tuple3DReadOnly)this.angularAccelerationInBody);
    }

    public void setLinearAccelerationInBody(Vector3D linearAccelerationInBody) {
        this.linearAccelerationInBody.set((Tuple3DReadOnly)linearAccelerationInBody);
    }

    public void getLinearAccelerationInBody(Vector3D linearAccelerationInBodyToPack) {
        linearAccelerationInBodyToPack.set((Tuple3DReadOnly)this.linearAccelerationInBody);
    }

    public void getTransformFromMountToJoint(RigidBodyTransform transformToPack) {
        transformToPack.set(this.transformFromMountToJoint);
    }

    public void setOffset(RigidBodyTransform newTransformFromMountToJoint) {
        this.transformFromMountToJoint.set(newTransformFromMountToJoint);
    }

    public void setAngularVelocityNoiseParameters(double angularVelocityGaussianNoiseMean, double angularVelocityGaussianNoiseStdDev) {
        this.angularVelocityGaussianNoiseMean = angularVelocityGaussianNoiseMean;
        this.angularVelocityGaussianNoiseStdDev = angularVelocityGaussianNoiseStdDev;
    }

    public void setAngularVelocityBiasParameters(double angularVelocityGaussianBiasMean, double angularVelocityGaussianBiasStdDev) {
        this.angularVelocityGaussianBiasMean = angularVelocityGaussianBiasMean;
        this.angularVelocityGaussianBiasStdDev = angularVelocityGaussianBiasStdDev;
    }

    public void setAccelerationNoiseParameters(double accelerationGaussianNoiseMean, double accelerationGaussianNoiseStdDev) {
        this.accelerationGaussianNoiseMean = accelerationGaussianNoiseMean;
        this.accelerationGaussianNoiseStdDev = accelerationGaussianNoiseStdDev;
    }

    public void setAccelerationBiasParameters(double accelerationGaussianBiasMean, double accelerationGaussianBiasStdDev) {
        this.accelerationGaussianBiasMean = accelerationGaussianBiasMean;
        this.accelerationGaussianBiasStdDev = accelerationGaussianBiasStdDev;
    }

    public double getAccelerationGaussianNoiseMean() {
        return this.accelerationGaussianNoiseMean;
    }

    public double getAccelerationGaussianNoiseStdDev() {
        return this.accelerationGaussianNoiseStdDev;
    }

    public double getAccelerationGaussianBiasMean() {
        return this.accelerationGaussianBiasMean;
    }

    public double getAccelerationGaussianBiasStdDev() {
        return this.accelerationGaussianBiasStdDev;
    }

    public double getAngularVelocityGaussianNoiseMean() {
        return this.angularVelocityGaussianNoiseMean;
    }

    public double getAngularVelocityGaussianNoiseStdDev() {
        return this.angularVelocityGaussianNoiseStdDev;
    }

    public double getAngularVelocityGaussianBiasMean() {
        return this.angularVelocityGaussianBiasMean;
    }

    public double getAngularVelocityGaussianBiasStdDev() {
        return this.angularVelocityGaussianBiasStdDev;
    }
}

