/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import java.util.Random;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class RandomRockyGroundProfile
extends GroundProfileFromHeightMap {
    private double resolution;
    private double startRocksAtX;
    private int fieldLength;
    private int minRockRadius;
    private int maxRockRadius;
    private int minRockLength;
    private int maxRockLength;
    private int minRockWidth;
    private int maxRockWidth;
    private float minRockHeight;
    private float maxRockHeight;
    private final BoundingBox3D boundingBox;
    private float[][] terrainMap;
    Random rand = new Random(1000L);

    public RandomRockyGroundProfile() {
        this(20.0);
    }

    public RandomRockyGroundProfile(double fieldLength) {
        this(fieldLength, 6000);
    }

    public RandomRockyGroundProfile(double fieldLength, int numberOfRocks) {
        this(fieldLength, numberOfRocks, 0.001, 0.02, -fieldLength / 2.0);
    }

    public RandomRockyGroundProfile(double fieldLength, int numberOfRocks, double minRockHeight, double maxRockHeight, double startRocksAtX) {
        this(fieldLength, numberOfRocks, minRockHeight, maxRockHeight, 0.01, 0.1, 0.05, 0.1, 0.05, 0.1);
        this.startRocksAtX = startRocksAtX;
    }

    public RandomRockyGroundProfile(double fieldLength, int numberOfRocks, double minRockHeight, double maxRockHeight, double minRockRadius, double maxRockRadius, double minRockLength, double maxRockLength, double minRockWidth, double maxRockWidth) {
        this(fieldLength, numberOfRocks, minRockHeight, maxRockHeight, minRockRadius, maxRockRadius, minRockLength, maxRockLength, minRockWidth, maxRockWidth, 0.01);
    }

    public RandomRockyGroundProfile(double fieldLength, int numberOfRocks, double minRockHeight, double maxRockHeight, double minRockRadius, double maxRockRadius, double minRockLength, double maxRockLength, double minRockWidth, double maxRockWidth, double resolution) {
        this.resolution = resolution;
        this.fieldLength = (int)(fieldLength / resolution);
        this.minRockHeight = (float)minRockHeight;
        this.maxRockHeight = (float)maxRockHeight;
        this.minRockRadius = (int)(minRockRadius / resolution);
        this.maxRockRadius = (int)(maxRockRadius / resolution);
        this.minRockLength = (int)(minRockLength / resolution);
        this.maxRockLength = (int)(maxRockLength / resolution);
        this.minRockWidth = (int)(minRockWidth / resolution);
        this.maxRockWidth = (int)(maxRockWidth / resolution);
        double xMin = (double)(-this.fieldLength) * resolution / 2.0;
        double xMax = (double)this.fieldLength * resolution / 2.0;
        double yMin = (double)(-this.fieldLength) * resolution / 2.0;
        double yMax = (double)this.fieldLength * resolution / 2.0;
        this.boundingBox = new BoundingBox3D(xMin, yMin, Double.NEGATIVE_INFINITY, xMax, yMax, Double.POSITIVE_INFINITY);
        this.terrainMap = new float[this.fieldLength][this.fieldLength];
        for (int i = 0; i < numberOfRocks; ++i) {
            float height = this.rand.nextFloat() * (this.maxRockHeight - this.minRockHeight) + this.minRockHeight;
            int xPos = this.rand.nextInt(this.fieldLength);
            int yPos = this.rand.nextInt(this.fieldLength);
            if (this.rand.nextBoolean()) {
                int radius = this.rand.nextInt(this.maxRockRadius - this.minRockRadius) + this.minRockRadius;
                for (int x = xPos - radius; x <= xPos + radius; ++x) {
                    if (x >= this.fieldLength || x < 0) continue;
                    for (int y = yPos - radius; y <= yPos + radius; ++y) {
                        if (y >= this.fieldLength || y < 0 || (x - xPos) * (x - xPos) + (y - yPos) * (y - yPos) >= radius * radius) continue;
                        this.terrainMap[x][y] = height;
                    }
                }
                continue;
            }
            int xSize = this.rand.nextInt(this.maxRockLength - this.minRockLength) + this.minRockLength;
            int ySize = this.rand.nextInt(this.maxRockWidth - this.minRockWidth) + this.minRockWidth;
            for (int x = xPos - xSize / 2; x <= xPos + xSize / 2; ++x) {
                if (x >= this.fieldLength || x < 0) continue;
                for (int y = yPos - ySize / 2; y <= yPos + ySize / 2; ++y) {
                    if (y >= this.fieldLength || y < 0) continue;
                    this.terrainMap[x][y] = height;
                }
            }
        }
    }

    private boolean withinBounds(int x, int y) {
        return x > 0 && x < this.fieldLength && y > 0 && y < this.fieldLength;
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double height = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return height;
    }

    public double heightAt(double x_world, double y_world, double z_world) {
        int xPos1 = (int)Math.floor((x_world - this.boundingBox.getMinX()) / this.resolution);
        int yPos1 = (int)Math.floor((y_world - this.boundingBox.getMinY()) / this.resolution);
        int xPos2 = (int)Math.ceil((x_world - this.boundingBox.getMinX()) / this.resolution);
        int yPos2 = (int)Math.ceil((y_world - this.boundingBox.getMinY()) / this.resolution);
        if (!this.withinBounds(xPos1, yPos1) || !this.withinBounds(xPos2, yPos2)) {
            return 0.0;
        }
        if (x_world < this.startRocksAtX) {
            return 0.0;
        }
        return (double)(this.terrainMap[xPos1][yPos1] + this.terrainMap[xPos2][yPos2]) / 2.0;
    }

    public void surfaceNormalAt(double x_world, double y_world, double z_world, Vector3DBasics normal) {
        normal.setX(0.0);
        normal.setY(0.0);
        normal.setZ(1.0);
        int xPos1 = (int)Math.floor((x_world - this.boundingBox.getMinX()) / this.resolution);
        int yPos1 = (int)Math.floor((y_world - this.boundingBox.getMinY()) / this.resolution);
        int xPos2 = (int)Math.ceil((x_world - this.boundingBox.getMinX()) / this.resolution);
        int yPos2 = (int)Math.ceil((y_world - this.boundingBox.getMinY()) / this.resolution);
        if (!this.withinBounds(xPos1, yPos1) || !this.withinBounds(xPos2, yPos2)) {
            return;
        }
        double h1 = this.terrainMap[xPos1][yPos1];
        double h2 = this.terrainMap[xPos2][yPos2];
        Point3D p1 = null;
        Point3D p2 = null;
        if (h1 > h2) {
            p1 = new Point3D((double)xPos1, (double)yPos1, h1);
            p2 = new Point3D((double)xPos2, (double)yPos2, h2);
        } else {
            p1 = new Point3D((double)xPos1, (double)yPos1, h2);
            p2 = new Point3D((double)xPos2, (double)yPos2, h1);
        }
        Vector3D v1 = new Vector3D();
        v1.sub((Tuple3DReadOnly)p1, (Tuple3DReadOnly)p2);
        Vector3D v2 = new Vector3D(-v1.getY(), v1.getX(), 0.0);
        normal.cross((Tuple3DReadOnly)v1, (Tuple3DReadOnly)v2);
        normal.normalize();
        if (normal.getZ() < 0.0) {
            System.out.println("The z value of the normal force should be positive");
        }
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

