/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.DummyOneDegreeOfFreedomJointPhysics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoDouble;

public class DummyOneDegreeOfFreedomJoint
extends OneDegreeOfFreedomJoint {
    private static final long serialVersionUID = 1341493615657008348L;
    private boolean hasLimitStops = false;
    private double q_min;
    private double q_max;
    private double k_limit;
    private double b_limit;
    private double b_damp;
    private boolean hasVelocityLimits = false;
    private double qd_max;
    private double b_vel_limit;
    private boolean hasTorqueLimits = false;
    private double tau_max;
    private final YoDouble q;
    private final YoDouble qd;
    private final YoDouble qdd;
    private final YoDouble tau;
    private YoVariableList jointVars;
    private AxisAngle axisAngle = new AxisAngle();

    public DummyOneDegreeOfFreedomJoint(String jname, Tuple3DReadOnly offset, Robot rob, Vector3DReadOnly u_hat) {
        super(jname, offset, rob);
        this.physics = new DummyOneDegreeOfFreedomJointPhysics(this);
        this.physics.u_i = new Vector3D();
        this.physics.u_i.set((Tuple3DReadOnly)u_hat);
        this.physics.u_i.normalize();
        YoRegistry registry = rob.getRobotsYoRegistry();
        this.q = new YoDouble("q_" + jname, "PinJoint angle", registry);
        this.qd = new YoDouble("qd_" + jname, "PinJoint anglular velocity", registry);
        this.qdd = new YoDouble("qdd_" + jname, "PinJoint angular acceleration", registry);
        this.tau = new YoDouble("tau_" + jname, "PinJoint torque", registry);
        this.setPinTransform3D(this.jointTransform3D, this.physics.u_i);
    }

    protected YoVariableList getJointVars() {
        return this.jointVars;
    }

    @Override
    protected void update() {
        this.setPinTransform3D(this.jointTransform3D, this.physics.u_i, this.q.getDoubleValue());
    }

    protected void setPinTransform3D(RigidBodyTransform t1, Vector3D u_i) {
        this.setPinTransform3D(t1, u_i, 0.0);
    }

    protected void setPinTransform3D(RigidBodyTransform t1, Vector3D u_i, double rotAng) {
        t1.setIdentity();
        this.axisAngle.set((Vector3DReadOnly)u_i, rotAng);
        t1.getRotation().set((Orientation3DReadOnly)this.axisAngle);
    }

    @Override
    public YoDouble getQDDYoVariable() {
        return this.qdd;
    }

    @Override
    public YoDouble getQDYoVariable() {
        return this.qd;
    }

    @Override
    public YoDouble getQYoVariable() {
        return this.q;
    }

    @Override
    public void setQdd(double qdd) {
    }

    @Override
    public void setQd(double qd) {
    }

    @Override
    public void setQ(double q) {
    }

    @Override
    public void setTau(double tau) {
    }

    @Override
    public YoDouble getTauYoVariable() {
        return this.tau;
    }

    @Override
    public double getDamping() {
        return 0.0;
    }

    @Override
    public void setDamping(double b_damp) {
    }

    @Override
    public double getTorqueLimit() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getVelocityLimit() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getJointUpperLimit() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getJointLowerLimit() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getJointStiction() {
        return 0.0;
    }

    @Override
    public double getQDD() {
        return this.qdd.getDoubleValue();
    }

    @Override
    public double getQD() {
        return this.qd.getDoubleValue();
    }

    @Override
    public double getQ() {
        return this.q.getDoubleValue();
    }

    @Override
    public double getTau() {
        return this.tau.getDoubleValue();
    }
}

