/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.engine.featherstone;

import java.io.Serializable;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.SpatialVector;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.SpatialInertiaMatrix;

public final class SpatialTransformationMatrix
implements Serializable {
    private static final long serialVersionUID = -1437839453250728870L;
    private final RotationMatrix R = new RotationMatrix();
    private final Matrix3D r_Twidle = new Matrix3D();
    private final Vector3D temp1 = new Vector3D();
    private final Matrix3D x_Twidle = new Matrix3D();
    private final RotationMatrix Rt = new RotationMatrix();
    private final Matrix3D R_IA_Rt = new Matrix3D();
    private final Matrix3D R_IB_Rt = new Matrix3D();
    private final Matrix3D R_IC_Rt = new Matrix3D();
    private final Matrix3D R_IB_Rt_r_Twidle = new Matrix3D();
    private final Matrix3D r_Twidle_R_IA_Rt = new Matrix3D();
    private final Matrix3D r_Twidle_R_IB_Rt = new Matrix3D();
    private final Matrix3D r_Twidle_R_IB_Rt_r_Twidle = new Matrix3D();

    public String toString() {
        String ret = "R = " + this.R + "\nr_Twidle = " + this.r_Twidle;
        return ret;
    }

    public void setFromOffsetAndRotation(Vector3DReadOnly r_i, RotationMatrixReadOnly Rin) {
        this.R.set(Rin);
        this.r_Twidle.setM00(0.0);
        this.r_Twidle.setM01(-r_i.getZ());
        this.r_Twidle.setM02(r_i.getY());
        this.r_Twidle.setM10(r_i.getZ());
        this.r_Twidle.setM11(0.0);
        this.r_Twidle.setM12(-r_i.getX());
        this.r_Twidle.setM20(-r_i.getY());
        this.r_Twidle.setM21(r_i.getX());
        this.r_Twidle.setM22(0.0);
    }

    public void set(SpatialTransformationMatrix Min) {
        this.R.set(Min.R);
        this.r_Twidle.set(Min.r_Twidle);
    }

    public void invert() {
        this.Rt.set(this.R);
        this.Rt.transpose();
        this.x_Twidle.set((RotationMatrixReadOnly)this.Rt);
        this.x_Twidle.multiply((Matrix3DReadOnly)this.r_Twidle);
        this.x_Twidle.multiply((Matrix3DReadOnly)this.R);
        this.x_Twidle.scale(-1.0);
        this.R.set(this.Rt);
        this.r_Twidle.set(this.x_Twidle);
    }

    public void transform(SpatialVector v1) {
        this.R.transform((Tuple3DBasics)v1.top);
        this.temp1.set(v1.top);
        this.r_Twidle.transform((Tuple3DBasics)this.temp1);
        this.temp1.scale(-1.0);
        this.R.transform((Tuple3DBasics)v1.bottom);
        v1.bottom.add((Tuple3DReadOnly)this.temp1);
    }

    public void transformSpatialInertia(SpatialInertiaMatrix I) {
        this.Rt.set(this.R);
        this.Rt.transpose();
        this.R_IA_Rt.set((RotationMatrixReadOnly)this.R);
        this.R_IA_Rt.multiply((Matrix3DReadOnly)I.A);
        this.R_IA_Rt.multiply((Matrix3DReadOnly)this.Rt);
        this.R_IB_Rt.set((RotationMatrixReadOnly)this.R);
        this.R_IB_Rt.multiply((Matrix3DReadOnly)I.B);
        this.R_IB_Rt.multiply((Matrix3DReadOnly)this.Rt);
        this.R_IC_Rt.set((RotationMatrixReadOnly)this.R);
        this.R_IC_Rt.multiply((Matrix3DReadOnly)I.C);
        this.R_IC_Rt.multiply((Matrix3DReadOnly)this.Rt);
        this.R_IB_Rt_r_Twidle.set(this.R_IB_Rt);
        this.R_IB_Rt_r_Twidle.multiply((Matrix3DReadOnly)this.r_Twidle);
        this.r_Twidle_R_IB_Rt.set(this.r_Twidle);
        this.r_Twidle_R_IB_Rt.multiply((Matrix3DReadOnly)this.R_IB_Rt);
        this.r_Twidle_R_IA_Rt.set(this.r_Twidle);
        this.r_Twidle_R_IA_Rt.multiply((Matrix3DReadOnly)this.R_IA_Rt);
        this.r_Twidle_R_IB_Rt_r_Twidle.set(this.r_Twidle);
        this.r_Twidle_R_IB_Rt_r_Twidle.multiply((Matrix3DReadOnly)this.R_IB_Rt_r_Twidle);
        I.A.add((Matrix3DReadOnly)this.R_IA_Rt, (Matrix3DReadOnly)this.R_IB_Rt_r_Twidle);
        I.B.set(this.R_IB_Rt);
        I.C.sub((Matrix3DReadOnly)this.R_IC_Rt, (Matrix3DReadOnly)this.r_Twidle_R_IB_Rt_r_Twidle);
        I.C.sub((Matrix3DReadOnly)this.r_Twidle_R_IA_Rt);
        this.r_Twidle_R_IA_Rt.transpose();
        I.C.sub((Matrix3DReadOnly)this.r_Twidle_R_IA_Rt);
        I.D.set(I.A);
        I.D.transpose();
    }
}

