/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class RollingGroundProfile
extends GroundProfileFromHeightMap {
    private static final double xMinDefault = -20.0;
    private static final double xMaxDefault = 20.0;
    private static final double yMinDefault = -20.0;
    private static final double yMaxDefault = 20.0;
    private static final double amplitudeDefault = 0.1;
    private static final double frequencyDefault = 0.3;
    private static final double offsetDefault = 0.0;
    private final BoundingBox3D boundingBox;
    protected final double amplitude;
    protected final double frequency;
    protected final double offset;

    public RollingGroundProfile() {
        this(0.1, 0.3, 0.0);
    }

    public RollingGroundProfile(double amplitude, double frequency, double offset) {
        this(amplitude, frequency, offset, -20.0, 20.0, -20.0, 20.0);
    }

    public RollingGroundProfile(double amplitude, double frequency, double offset, double xMin, double xMax, double yMin, double yMax) {
        this.amplitude = amplitude;
        this.frequency = frequency;
        this.offset = offset;
        double zMin = Double.NEGATIVE_INFINITY;
        double zMax = Math.abs(amplitude) + 1.0E-4;
        this.boundingBox = new BoundingBox3D((Point3DReadOnly)new Point3D(xMin, yMin, zMin), (Point3DReadOnly)new Point3D(xMax, yMax, zMax));
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public double heightAt(double x, double y, double z) {
        double height = this.amplitude * Math.sin(Math.PI * 2 * this.frequency * (x + this.offset));
        return height;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        double dzdx = 0.0;
        dzdx = this.amplitude * 2.0 * Math.PI * this.frequency * Math.cos(Math.PI * 2 * this.frequency * (x + this.offset));
        normal.setX(-dzdx);
        normal.setY(0.0);
        normal.setZ(1.0);
        normal.normalize();
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double heightAt = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return heightAt;
    }

    public static void main(String[] args) {
        RollingGroundProfile rollingGroundProfile = new RollingGroundProfile();
        SimulationConstructionSet scs = new SimulationConstructionSet(new Robot("Null"));
        scs.setGroundVisible(false);
        scs.startOnAThread();
        ThreadTools.sleep((long)1000L);
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.translate((Tuple3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        linkGraphics.addSphere(0.5);
        scs.addStaticLinkGraphics(linkGraphics);
        MeshDataHolder meshData = MeshDataGenerator.Cone((double)0.8, (double)0.4, (int)20);
        Graphics3DObject meshLinkGraphics = new Graphics3DObject();
        meshLinkGraphics.translate(2.0, 0.0, 0.0);
        meshLinkGraphics.addMeshData(meshData, YoAppearance.Green());
        scs.addStaticLinkGraphics(meshLinkGraphics);
        Graphics3DObject groundLinkGraphics = new Graphics3DObject();
        groundLinkGraphics.addCoordinateSystem(1.0);
        RollingGroundProfile heightMap = rollingGroundProfile;
        groundLinkGraphics.addHeightMap((HeightMap)heightMap, 300, 300, YoAppearance.Red());
        scs.addStaticLinkGraphics(groundLinkGraphics);
    }
}

