/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import com.jmatio.io.MatFileWriter;
import com.jmatio.types.MLDouble;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.nio.WriteOption;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.GraphArrayPanel;
import us.ihmc.simulationconstructionset.gui.GraphArrayWindow;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.YoGraph;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportGraphsToFileConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.GUIEnablerAndDisabler;
import us.ihmc.tools.gui.MyFileFilter;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryReader;
import us.ihmc.yoVariables.variable.YoVariable;

public class ExportGraphsToFileGenerator
implements ExportGraphsToFileConstructor {
    private static final String matEnding = ".mat";
    private static final String csvEnding = ".csv";
    private FileFilter matFileFilter = new MyFileFilter(new String[]{".mat"}, "Matlab/octave file (.mat)");
    private FileFilter csvFileFilter = new MyFileFilter(new String[]{".csv"}, "CSV file (.csv)");
    private JFileChooser dataFileChooser;
    private JFrame frame;
    private GUIEnablerAndDisabler guiEnablerAndDisabler;
    private GraphArrayPanel graphArrayPanel;
    private StandardSimulationGUI myGUI;
    private JPanel accessory;
    private JCheckBox saveAllGraphs;
    private YoBuffer dataBuffer;

    public ExportGraphsToFileGenerator(SimulationConstructionSet scs, JFrame frame, GraphArrayPanel graphArrayPanel, StandardSimulationGUI myGUI) {
        this.frame = frame;
        this.guiEnablerAndDisabler = scs;
        this.graphArrayPanel = graphArrayPanel;
        this.myGUI = myGUI;
        this.dataBuffer = scs.getDataBuffer();
        this.dataFileChooser = new JFileChooser();
        this.dataFileChooser.setAcceptAllFileFilterUsed(false);
        this.dataFileChooser.addChoosableFileFilter(this.matFileFilter);
        this.dataFileChooser.addChoosableFileFilter(this.csvFileFilter);
        this.accessory = new JPanel();
        this.saveAllGraphs = new JCheckBox("Save graphs in all graph windows");
        this.accessory.setLayout(new BorderLayout());
        this.accessory.add((Component)this.saveAllGraphs, "South");
        this.dataFileChooser.setAccessory(this.accessory);
    }

    @Override
    public void constructDialog() {
        this.guiEnablerAndDisabler.disableGUIComponents();
        this.saveAllGraphs.setSelected(false);
        if (this.dataFileChooser.showSaveDialog(this.frame) == 0) {
            ArrayList<YoBufferVariableEntryReader> entriesToExport = new ArrayList<YoBufferVariableEntryReader>();
            if (this.saveAllGraphs.isSelected()) {
                for (YoGraph graph : this.myGUI.getGraphArrayPanel().getGraphsOnThisPanel()) {
                    entriesToExport.addAll(graph.getEntriesOnThisGraph());
                }
                for (GraphArrayWindow graphArrayWindow : this.myGUI.getGraphArrayWindows()) {
                    for (YoGraph graph : graphArrayWindow.getGraphArrayPanel().getGraphsOnThisPanel()) {
                        entriesToExport.addAll(graph.getEntriesOnThisGraph());
                    }
                }
            } else {
                for (YoGraph graph : this.graphArrayPanel.getGraphsOnThisPanel()) {
                    entriesToExport.addAll(graph.getEntriesOnThisGraph());
                }
            }
            if (this.dataFileChooser.getFileFilter() == this.matFileFilter) {
                this.exportToMAT(this.dataFileChooser.getSelectedFile(), entriesToExport);
            } else if (this.dataFileChooser.getFileFilter() == this.csvFileFilter) {
                this.exportToCSV(this.dataFileChooser.getSelectedFile(), entriesToExport);
            } else {
                throw new RuntimeException("Unknown data type selected " + this.dataFileChooser.getFileFilter());
            }
        }
        this.guiEnablerAndDisabler.enableGUIComponents();
    }

    private void exportToCSV(File chosenFile, ArrayList<YoBufferVariableEntryReader> entriesToExport) {
        String filename = chosenFile.getName();
        if (!filename.endsWith(csvEnding)) {
            chosenFile = new File(chosenFile.getParent(), filename.concat(csvEnding));
        }
        PrintWriter writer = FileTools.newPrintWriter((Path)chosenFile.toPath(), (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        for (YoBufferVariableEntryReader dataEntry : entriesToExport) {
            writer.print(dataEntry.getVariableName() + ",");
        }
        writer.println();
        for (int i = this.dataBuffer.getInPoint(); i < this.dataBuffer.getOutPoint(); ++i) {
            for (YoBufferVariableEntryReader dataEntry : entriesToExport) {
                writer.print(dataEntry.getBuffer()[i] + ",");
            }
            writer.println();
        }
        writer.close();
    }

    private void exportToMAT(File chosenFile, ArrayList<YoBufferVariableEntryReader> entriesToExport) {
        String filename = chosenFile.getName();
        if (!filename.endsWith(matEnding)) {
            chosenFile = new File(chosenFile.getParent(), filename.concat(matEnding));
        }
        ArrayList<MLDouble> matlabData = new ArrayList<MLDouble>();
        for (YoBufferVariableEntryReader entry : entriesToExport) {
            matlabData.add(ExportGraphsToFileGenerator.convertToMatlabArray(entry, this.dataBuffer.getInPoint(), this.dataBuffer.getOutPoint()));
        }
        try {
            new MatFileWriter(chosenFile, matlabData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void closeAndDispose() {
        this.matFileFilter = null;
        this.csvFileFilter = null;
        this.dataFileChooser = null;
        this.frame = null;
        this.myGUI = null;
        this.accessory = null;
        this.saveAllGraphs = null;
    }

    public static MLDouble convertToMatlabArray(YoBufferVariableEntryReader entry, int inPoint, int outPoint) {
        double[] data;
        YoVariable variable = entry.getVariable();
        double[] inData = entry.getBuffer();
        if (inPoint == outPoint) {
            data = new double[]{inData[inPoint]};
        } else if (inPoint < outPoint) {
            data = new double[outPoint + 1 - inPoint];
            System.arraycopy(inData, inPoint, data, 0, data.length);
        } else {
            int length = inData.length - inPoint + outPoint + 1;
            data = new double[length];
            System.arraycopy(inData, inPoint, data, 0, inData.length - inPoint);
            System.arraycopy(inData, 0, data, inData.length - inPoint, outPoint + 1);
        }
        return new MLDouble(variable.getName(), data, 1);
    }
}

