/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.engine.featherstone;

import java.io.Serializable;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.CollisionDerivativeException;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.CollisionDerivativeVector;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.CollisionRungeKutta;
import us.ihmc.simulationconstructionset.util.QuarticRootFinder;

public class CollisionIntegrator
implements Serializable {
    private static final long serialVersionUID = -6083539629185172597L;
    private static final double U_STUCK_THRESH = 1.0E-4;
    private static final double ACCURACY = 1.0E-7;
    private static final double H_MIN = 1.0E-10;
    private static final double H_START = 0.001;
    private static final double UZ_OVERSHOOT = 5.0E-4;
    private static final double PZ_STEP_SIZE_MIN = 1.0E-7;
    private static final double PZ_STEP_SIZE_MAX = 10.0;
    private Matrix3DReadOnly K;
    private Matrix3D K_inv = new Matrix3D();
    private double epsilon;
    private double mu;
    private boolean stableSticking;
    private boolean amStuck;
    private Vector3DReadOnly u0 = new Vector3D();
    Vector3D Kx = new Vector3D();
    Vector3D Ky = new Vector3D();
    Vector3D Kz = new Vector3D();
    private RotationMatrix K_pseudo = new RotationMatrix();
    private RotationMatrix K_trans = new RotationMatrix();
    private final Vector3D u_final = new Vector3D();
    private final Vector3D delta_u = new Vector3D();
    private Vector3D zeta_B = new Vector3D();
    double[] pz_output = new double[4];
    double[] compression_output = new double[4];
    double[] restitution_output = new double[4];
    private double[] coeffs = new double[5];
    private double[] solutions = new double[4];
    private QuarticRootFinder rootFinder = new QuarticRootFinder();
    private CollisionRungeKutta collisionRungeKutta;
    private CollisionRungeKutta pzRungeKutta;
    double[] rk_input = new double[4];
    double[] rk_range = new double[2];
    PZDerivativeVector pzDerivativeVector = new PZDerivativeVector();
    CompressionDerivativeVector compressionDerivativeVector = new CompressionDerivativeVector();
    RestitutionDerivativeVector restitutionDerivativeVector = new RestitutionDerivativeVector();
    Vector3D zeta = new Vector3D();

    public CollisionIntegrator() {
        this.collisionRungeKutta = new CollisionRungeKutta(3);
        this.pzRungeKutta = new CollisionRungeKutta(4);
    }

    public static void main(String[] args) {
        System.out.println("Hello World");
        CollisionIntegrator integrator = new CollisionIntegrator();
        Matrix3D K_test = new Matrix3D(1.9795607798930628, -0.23966928371230545, 0.2574790610887272, -0.23966928371230545, 0.06310349438764432, -0.012154180483161334, 0.2574790610887272, -0.012154180483161352, 0.19089180777144152);
        double mu = 0.7;
        double epsilon = 3.0;
        Vector3D u0_test = new Vector3D(-0.46351582426916077, 0.061475623099959374, -4.4499062468302507E-4);
        Matrix3D K_test_inv = new Matrix3D((Matrix3DReadOnly)K_test);
        K_test_inv.invert();
        System.out.println("K_test_inv: " + K_test_inv);
        integrator.setup((Matrix3DReadOnly)K_test, (Vector3DReadOnly)u0_test, epsilon, mu);
        Vector3D final_output = new Vector3D();
        integrator.integrate(final_output);
        System.out.println("u0: " + u0_test);
        System.out.println("final ux: " + final_output.getX() + ", uy: " + final_output.getY() + ", uz: " + final_output.getZ());
        Vector3D delta_u = new Vector3D();
        delta_u.sub((Tuple3DReadOnly)final_output, (Tuple3DReadOnly)u0_test);
        System.out.println("delta_u: " + delta_u);
        Vector3D impulse = new Vector3D((Tuple3DReadOnly)delta_u);
        K_test_inv.transform((Tuple3DBasics)impulse);
        System.out.println("Impulse:  " + impulse);
    }

    public void setup(Matrix3DReadOnly K, Vector3DReadOnly u0, double epsilon, double mu) {
        this.collisionRungeKutta.setAdaptive();
        this.collisionRungeKutta.setStepSize(0.001);
        this.collisionRungeKutta.setMinimumStepSize(1.0E-10);
        this.collisionRungeKutta.setVerbose(false);
        this.collisionRungeKutta.setAccuracy(1.0E-7);
        this.pzRungeKutta.setAdaptive();
        this.pzRungeKutta.setStepSize(0.001);
        this.pzRungeKutta.setMinimumStepSize(1.0E-10);
        this.pzRungeKutta.setVerbose(false);
        this.pzRungeKutta.setAccuracy(1.0E-7);
        this.K = K;
        this.u0 = u0;
        this.epsilon = epsilon;
        this.mu = mu;
        this.K_inv.set(K);
        double inverseMinimum = 1.0E-11;
        if (Math.abs(this.K_inv.determinant()) < inverseMinimum) {
            System.err.println("Warning: K is not invertible in " + this.getClass().getSimpleName() + ". K_inv.determinant() = " + this.K_inv.determinant());
            System.err.println("K = " + K);
            if (Math.abs(this.K_inv.getM00()) < inverseMinimum) {
                this.K_inv.setM00(inverseMinimum);
            }
            if (Math.abs(this.K_inv.getM11()) < inverseMinimum) {
                this.K_inv.setM11(inverseMinimum);
            }
            if (Math.abs(this.K_inv.getM22()) < inverseMinimum) {
                this.K_inv.setM22(inverseMinimum);
            }
            if (Math.abs(this.K_inv.determinant()) < inverseMinimum) {
                this.K_inv.setM00(this.K_inv.getM00() + inverseMinimum);
                this.K_inv.setM11(this.K_inv.getM11() + inverseMinimum);
                this.K_inv.setM22(this.K_inv.getM22() + inverseMinimum);
            }
        }
        this.K_inv.invert();
        K.getRow(0, (Tuple3DBasics)this.Kx);
        K.getRow(1, (Tuple3DBasics)this.Ky);
        K.getRow(2, (Tuple3DBasics)this.Kz);
        this.stableSticking = this.K_inv.getElement(0, 2) * this.K_inv.getElement(0, 2) + this.K_inv.getElement(1, 2) * this.K_inv.getElement(1, 2) <= mu * mu * this.K_inv.getElement(2, 2) * this.K_inv.getElement(2, 2);
        this.amStuck = false;
    }

    public void computeImpulse(Vector3DBasics impulse) {
        this.integrate(this.u_final);
        this.delta_u.set(this.u_final);
        this.delta_u.sub((Tuple3DReadOnly)this.u0);
        impulse.set((Tuple3DReadOnly)this.delta_u);
        this.K_inv.transform((Tuple3DBasics)impulse);
    }

    public void computeMicroImpulse(Vector3DBasics impulse) {
        impulse.set((Tuple3DReadOnly)this.u0);
        impulse.scale(-2.1);
        this.K_inv.transform((Tuple3DBasics)impulse);
    }

    public void integrate(Vector3D u_fin) {
        double ux = this.u0.getX();
        double uy = this.u0.getY();
        double uz = this.u0.getZ();
        double Wz = 0.0;
        double utot = Math.sqrt(this.u0.getX() * this.u0.getX() + this.u0.getY() * this.u0.getY());
        this.zeta.set(-this.mu * this.u0.getX() / utot, -this.mu * this.u0.getY() / utot, 1.0);
        int nn = 0;
        while (this.Kz.dot((Tuple3DReadOnly)this.zeta) < 0.0) {
            double pz_step_size;
            if ((pz_step_size = (double)(++nn) / 1000.0 * Math.abs(uz / this.K.getM22())) > 10.0) {
                pz_step_size = 10.0;
            }
            if (pz_step_size < 1.0E-7) {
                pz_step_size = 1.0E-7;
            }
            this.integrateWRTpz(ux, uy, uz, Wz, pz_step_size, this.pz_output);
            ux = this.pz_output[0];
            uy = this.pz_output[1];
            uz = this.pz_output[2];
            Wz = this.pz_output[3];
            utot = Math.sqrt(ux * ux + uy * uy);
            this.zeta.set(-this.mu * ux / utot, -this.mu * uy / utot, 1.0);
            if (!this.amStuck) continue;
            break;
        }
        if (!this.amStuck && uz < 5.0E-4) {
            try {
                this.integrateCompression(ux, uy, uz, Wz, this.compression_output);
                ux = this.compression_output[0];
                uy = this.compression_output[1];
                uz = this.compression_output[2];
                Wz = this.compression_output[3];
            }
            catch (CollisionDerivativeException e) {
                if (!this.amStuck) {
                    // empty if block
                }
                uz = 5.0E-4;
            }
        }
        if (this.amStuck) {
            if (Wz > 0.0) {
                Wz = 0.0;
            }
            if (this.stableSticking) {
                u_fin.setX(0.0);
                u_fin.setY(0.0);
                if (uz < 0.0) {
                    Wz += 0.5 * this.K_inv.getElement(2, 2) * (0.0 - uz * uz);
                }
                uz = (Wz = Wz * this.epsilon * this.epsilon) < 0.0 ? Math.sqrt(0.0 + 2.0 * (0.0 - Wz) / this.K_inv.getElement(2, 2)) : 0.0;
                u_fin.setZ(uz);
            } else {
                if (uz > 0.0) {
                    uz = 0.0;
                }
                double beta = this.solveBeta(this.K, this.mu);
                this.zeta_B.setX(-this.mu * Math.cos(beta));
                this.zeta_B.setY(-this.mu * Math.sin(beta));
                this.zeta_B.setZ(1.0);
                double ux_bot = ux + this.Kx.dot((Tuple3DReadOnly)this.zeta_B) / this.Kz.dot((Tuple3DReadOnly)this.zeta_B) * (0.0 - uz);
                double uy_bot = uy + this.Ky.dot((Tuple3DReadOnly)this.zeta_B) / this.Kz.dot((Tuple3DReadOnly)this.zeta_B) * (0.0 - uz);
                double Wz_bot = Wz + (0.0 - uz * uz) / (2.0 * this.Kz.dot((Tuple3DReadOnly)this.zeta_B));
                u_fin.setZ(Math.sqrt(0.0 + 2.0 * this.Kz.dot((Tuple3DReadOnly)this.zeta_B) * (0.0 - Wz_bot)));
                u_fin.setX(ux_bot + this.Kx.dot((Tuple3DReadOnly)this.zeta_B) / this.Kz.dot((Tuple3DReadOnly)this.zeta_B) * (u_fin.getZ() - 0.0));
                u_fin.setY(uy_bot + this.Ky.dot((Tuple3DReadOnly)this.zeta_B) / this.Kz.dot((Tuple3DReadOnly)this.zeta_B) * (u_fin.getZ() - 0.0));
            }
        } else {
            if (Wz > 0.0) {
                Wz = 0.0;
            }
            this.integrateRestitution(ux, uy, uz, Wz * this.epsilon * this.epsilon, this.restitution_output);
            ux = this.restitution_output[0];
            uy = this.restitution_output[1];
            uz = this.restitution_output[2];
            Wz = this.restitution_output[3];
            if (this.amStuck) {
                if (Wz > 0.0) {
                    Wz = 0.0;
                }
                if (this.stableSticking) {
                    u_fin.setX(0.0);
                    u_fin.setY(0.0);
                    uz = Wz < 0.0 ? Math.sqrt(uz * uz + 2.0 * (0.0 - Wz) / this.K_inv.getElement(2, 2)) : 0.0;
                    u_fin.setZ(uz);
                } else {
                    double beta = this.solveBeta(this.K, this.mu);
                    this.zeta_B.setX(-this.mu * Math.cos(beta));
                    this.zeta_B.setY(-this.mu * Math.sin(beta));
                    this.zeta_B.setZ(1.0);
                    u_fin.setZ(Math.sqrt(uz * uz + 2.0 * this.Kz.dot((Tuple3DReadOnly)this.zeta_B) * (0.0 - Wz)));
                    u_fin.setX(ux + this.Kx.dot((Tuple3DReadOnly)this.zeta_B) / this.Kz.dot((Tuple3DReadOnly)this.zeta_B) * (u_fin.getZ() - 0.0));
                    u_fin.setY(uy + this.Ky.dot((Tuple3DReadOnly)this.zeta_B) / this.Kz.dot((Tuple3DReadOnly)this.zeta_B) * (u_fin.getZ() - 0.0));
                }
            } else {
                u_fin.setX(ux);
                u_fin.setY(uy);
                u_fin.setZ(uz);
            }
        }
        if (u_fin.getZ() < 0.0) {
            u_fin.setZ(0.0);
        }
    }

    private double solveBeta(Matrix3DReadOnly K, double mu) {
        double a = K.getM00();
        double b = K.getM11();
        double c = K.getM22();
        double d = K.getM12();
        double e = K.getM02();
        double f = K.getM01();
        this.coeffs[0] = -f * mu + d;
        this.coeffs[1] = 2.0 * mu * (a - b) - 2.0 * e;
        this.coeffs[2] = 6.0 * f * mu;
        this.coeffs[3] = -2.0 * mu * (a - b) - 2.0 * e;
        this.coeffs[4] = -f * mu - d;
        double num_real_solutions = this.rootFinder.SolveQuartic(this.coeffs, this.solutions);
        int i = 0;
        while ((double)i < num_real_solutions) {
            double t = this.solutions[i];
            if ((-a * mu - e) * t * t * t * t + (4.0 * f * mu + 2.0 * d) * t * t * t + (2.0 * a * mu - 4.0 * b * mu) * t * t + (-4.0 * f * mu + 2.0 * d) * t + (-a * mu + e) > 0.0) {
                return Math.atan2(2.0 * t, 1.0 - t * t);
            }
            ++i;
        }
        return 0.0;
    }

    private void integrateWRTpz(double ux, double uy, double uz, double Wz, double step_size, double[] output) {
        this.rk_input[0] = ux;
        this.rk_input[1] = uy;
        this.rk_input[2] = uz;
        this.rk_input[3] = Wz;
        this.rk_range[0] = 0.0;
        this.rk_range[1] = step_size;
        try {
            this.pzRungeKutta.integrate(this.rk_input, this.rk_range, this.pzDerivativeVector);
        }
        catch (CollisionRungeKutta.ODEException e) {
            System.out.println("Exception in integrateWRTpz: " + e);
        }
        catch (CollisionDerivativeException e) {
            System.out.println("Exception in integrateWRTpz: " + e);
        }
        output[0] = this.rk_input[0];
        output[1] = this.rk_input[1];
        output[2] = this.rk_input[2];
        output[3] = this.rk_input[3];
    }

    private void integrateCompression(double ux, double uy, double uz, double Wz, double[] output) throws CollisionDerivativeException {
        this.rk_input[0] = ux;
        this.rk_input[1] = uy;
        this.rk_input[2] = Wz;
        this.rk_range[0] = uz;
        this.rk_range[1] = 5.0E-4;
        try {
            this.collisionRungeKutta.integrate(this.rk_input, this.rk_range, this.compressionDerivativeVector);
        }
        catch (CollisionRungeKutta.ODEException e) {
            System.out.println("Exception in integrateCompression: " + e);
            System.exit(0);
        }
        output[0] = this.rk_input[0];
        output[1] = this.rk_input[1];
        output[2] = this.rk_range[1];
        output[3] = this.rk_input[2];
    }

    private void integrateRestitution(double ux, double uy, double uz, double Wz, double[] output) {
        this.rk_input[0] = ux;
        this.rk_input[1] = uy;
        this.rk_input[2] = uz;
        this.rk_range[0] = Wz;
        this.rk_range[1] = 0.0;
        try {
            this.collisionRungeKutta.integrate(this.rk_input, this.rk_range, this.restitutionDerivativeVector);
        }
        catch (CollisionRungeKutta.ODEException e) {
            System.out.println("Exception in integrateRestitution: " + e);
            System.out.println("Before integration:  (ux,uy,uz,Wz) = (" + ux + ", " + uy + ", " + uz + ", " + Wz + ")");
            System.out.println("At exception point:  (ux,uy,uz,Wz) = (" + this.rk_input[0] + ", " + this.rk_input[1] + ", " + this.rk_input[2] + ", ???)");
            System.out.println("K = " + this.K);
            System.out.println("u0 = " + this.u0);
            System.out.println("epsilon = " + this.epsilon);
            System.out.println("mu = " + this.mu);
        }
        catch (CollisionDerivativeException e) {
            System.out.println("Exception in integrateRestitution: " + e);
        }
        output[0] = this.rk_input[0];
        output[1] = this.rk_input[1];
        output[2] = this.rk_input[2];
        output[3] = this.rk_range[1];
    }

    private class PZDerivativeVector
    implements CollisionDerivativeVector {
        @Override
        public void derivs(double pz, double[] state, double[] deriv) {
            double ux = state[0];
            double uy = state[1];
            double uz = state[2];
            double Wz = state[3];
            double utot = Math.sqrt(ux * ux + uy * uy);
            CollisionIntegrator.this.zeta.set(-CollisionIntegrator.this.mu * ux / utot, -CollisionIntegrator.this.mu * uy / utot, 1.0);
            deriv[0] = CollisionIntegrator.this.Kx.dot((Tuple3DReadOnly)CollisionIntegrator.this.zeta);
            deriv[1] = CollisionIntegrator.this.Ky.dot((Tuple3DReadOnly)CollisionIntegrator.this.zeta);
            deriv[2] = CollisionIntegrator.this.Kz.dot((Tuple3DReadOnly)CollisionIntegrator.this.zeta);
            deriv[3] = uz;
        }

        @Override
        public boolean isStuck(double[] state) {
            double ux = state[0];
            double uy = state[1];
            double utot = Math.sqrt(ux * ux + uy * uy);
            if (utot < 1.0E-4) {
                CollisionIntegrator.this.amStuck = true;
                return true;
            }
            return false;
        }
    }

    private class CompressionDerivativeVector
    implements CollisionDerivativeVector {
        private static final long serialVersionUID = -4133081308328360568L;

        @Override
        public void derivs(double uz, double[] state, double[] deriv) throws CollisionDerivativeException {
            double ux = state[0];
            double uy = state[1];
            double Wz = state[2];
            double utot = Math.sqrt(ux * ux + uy * uy);
            CollisionIntegrator.this.zeta.set(-CollisionIntegrator.this.mu * ux / utot, -CollisionIntegrator.this.mu * uy / utot, 1.0);
            double Kz_zeta_inv = 1.0 / CollisionIntegrator.this.Kz.dot((Tuple3DReadOnly)CollisionIntegrator.this.zeta);
            if (Kz_zeta_inv < 0.0) {
                throw new CollisionDerivativeException("Bad Compression.  Kz_zeta_inv = " + Kz_zeta_inv);
            }
            deriv[0] = CollisionIntegrator.this.Kx.dot((Tuple3DReadOnly)CollisionIntegrator.this.zeta) * Kz_zeta_inv;
            deriv[1] = CollisionIntegrator.this.Ky.dot((Tuple3DReadOnly)CollisionIntegrator.this.zeta) * Kz_zeta_inv;
            deriv[2] = uz * Kz_zeta_inv;
        }

        @Override
        public boolean isStuck(double[] state) {
            double ux = state[0];
            double uy = state[1];
            double utot = Math.sqrt(ux * ux + uy * uy);
            if (utot < 1.0E-4) {
                CollisionIntegrator.this.amStuck = true;
                return true;
            }
            return false;
        }
    }

    private class RestitutionDerivativeVector
    implements CollisionDerivativeVector {
        private static final long serialVersionUID = 4537460728198035585L;

        @Override
        public void derivs(double Wz, double[] state, double[] deriv) {
            double ux = state[0];
            double uy = state[1];
            double uz = state[2];
            double utot = Math.sqrt(ux * ux + uy * uy);
            CollisionIntegrator.this.zeta.set(-CollisionIntegrator.this.mu * ux / utot, -CollisionIntegrator.this.mu * uy / utot, 1.0);
            deriv[0] = CollisionIntegrator.this.Kx.dot((Tuple3DReadOnly)CollisionIntegrator.this.zeta) / uz;
            deriv[1] = CollisionIntegrator.this.Ky.dot((Tuple3DReadOnly)CollisionIntegrator.this.zeta) / uz;
            deriv[2] = CollisionIntegrator.this.Kz.dot((Tuple3DReadOnly)CollisionIntegrator.this.zeta) / uz;
        }

        @Override
        public boolean isStuck(double[] state) {
            double ux = state[0];
            double uy = state[1];
            double utot = Math.sqrt(ux * ux + uy * uy);
            if (utot < 1.0E-4) {
                CollisionIntegrator.this.amStuck = true;
                return true;
            }
            return false;
        }
    }
}

