/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.ContactingExternalForcePoint;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.CollisionHandler;
import us.ihmc.simulationconstructionset.physics.CollisionShapeWithLink;
import us.ihmc.simulationconstructionset.physics.Contacts;
import us.ihmc.simulationconstructionset.physics.collision.CollisionDetectionResult;
import us.ihmc.simulationconstructionset.physics.collision.CollisionHandlerListener;

public class DefaultCollisionHandler
implements CollisionHandler {
    private double velocityForMicrocollision = 0.01;
    private int numberOfCyclesPerContactPair = 1;
    private static final boolean DEBUG = false;
    private final Random random;
    private final Vector3D normal = new Vector3D();
    private final Vector3D negative_normal = new Vector3D();
    private Point3D point1 = new Point3D();
    private Point3D point2 = new Point3D();
    private List<CollisionHandlerListener> listeners = new ArrayList<CollisionHandlerListener>();
    private final double epsilon;
    private final double mu;
    private final ArrayList<Contacts> shapesInContactList = new ArrayList();
    private final ArrayList<Integer> indices = new ArrayList();

    public DefaultCollisionHandler(double epsilon, double mu) {
        this(new Random(), epsilon, mu);
    }

    public DefaultCollisionHandler(Random random, double epsilon, double mu) {
        this.random = random;
        this.epsilon = epsilon;
        this.mu = mu;
    }

    @Override
    public void maintenanceBeforeCollisionDetection() {
        this.shapesInContactList.clear();
    }

    @Override
    public void maintenanceAfterCollisionDetection() {
        int numberOfCollisions = this.shapesInContactList.size();
        if (numberOfCollisions == 0) {
            return;
        }
        Collections.shuffle(this.shapesInContactList, this.random);
        for (int i = 0; i < numberOfCollisions; ++i) {
            Contacts shapesInContact = this.shapesInContactList.get(i);
            CollisionShapeWithLink shape1 = (CollisionShapeWithLink)shapesInContact.getShapeA();
            CollisionShapeWithLink shape2 = (CollisionShapeWithLink)shapesInContact.getShapeB();
            this.handleLocal(shape1, shape2, shapesInContact);
        }
    }

    @Override
    public void handle(Contacts contacts) {
        this.shapesInContactList.add(contacts);
    }

    private void handleLocal(CollisionShapeWithLink shape1, CollisionShapeWithLink shape2, Contacts contacts) {
        boolean shapeOneIsGround = shape1.isGround();
        boolean shapeTwoIsGround = shape2.isGround();
        if (shapeOneIsGround && shapeTwoIsGround) {
            return;
        }
        int numberOfContacts = contacts.getNumberOfContacts();
        this.indices.clear();
        for (int i = 0; i < numberOfContacts; ++i) {
            this.indices.add(i);
        }
        for (int cycle = 0; cycle < this.numberOfCyclesPerContactPair; ++cycle) {
            Collections.shuffle(this.indices, this.random);
            for (int j = 0; j < numberOfContacts; ++j) {
                boolean collisionOccurred;
                int i = this.indices.get(j);
                double distance = contacts.getDistance(i);
                if (distance > 0.0) continue;
                contacts.getWorldA(i, this.point1);
                contacts.getWorldB(i, this.point2);
                contacts.getWorldNormal(i, this.normal);
                if (!contacts.isNormalOnA()) {
                    this.normal.scale(-1.0);
                }
                if (Double.isNaN(this.normal.getX())) {
                    throw new RuntimeException("Normal is invalid. Contains NaN!");
                }
                this.negative_normal.set(this.normal);
                this.negative_normal.scale(-1.0);
                Link linkOne = null;
                ExternalForcePoint externalForcePointOne = null;
                Robot robot1 = null;
                Link linkTwo = null;
                ExternalForcePoint externalForcePointTwo = null;
                Robot robot2 = null;
                if (!shapeOneIsGround) {
                    linkOne = shape1.getLink();
                    externalForcePointOne = linkOne.getContactingExternalForcePoints().get(0);
                    externalForcePointOne.setOffsetWorld(this.point1.getX(), this.point1.getY(), this.point1.getZ());
                    robot1 = linkOne.getParentJoint().getRobot();
                }
                if (!shapeTwoIsGround) {
                    linkTwo = shape2.getLink();
                    externalForcePointTwo = linkTwo.getContactingExternalForcePoints().get(0);
                    externalForcePointTwo.setOffsetWorld(this.point2.getX(), this.point2.getY(), this.point2.getZ());
                    robot2 = linkTwo.getParentJoint().getRobot();
                }
                if (!shapeOneIsGround) {
                    robot1.updateVelocities();
                    robot1.update();
                }
                if (!shapeTwoIsGround && robot2 != robot1) {
                    robot2.updateVelocities();
                    robot2.update();
                }
                Vector3D p_world = new Vector3D();
                if (shapeTwoIsGround) {
                    velocityWorld = new Vector3D(0.0, 0.0, 0.0);
                    if (externalForcePointOne.getVelocityCopy().lengthSquared() > this.velocityForMicrocollision * this.velocityForMicrocollision) {
                        collisionOccurred = externalForcePointOne.resolveCollision((Vector3DReadOnly)velocityWorld, (Vector3DReadOnly)this.negative_normal, this.epsilon, this.mu, (Vector3DBasics)p_world);
                    } else {
                        double penetrationSquared = this.point1.distanceSquared((Point3DReadOnly)this.point2);
                        externalForcePointOne.resolveMicroCollision(penetrationSquared, (Vector3DReadOnly)velocityWorld, (Vector3DReadOnly)this.negative_normal, this.epsilon, this.mu, (Vector3DBasics)p_world);
                        collisionOccurred = true;
                    }
                } else if (shapeOneIsGround) {
                    velocityWorld = new Vector3D(0.0, 0.0, 0.0);
                    if (externalForcePointTwo.getVelocityCopy().lengthSquared() > this.velocityForMicrocollision * this.velocityForMicrocollision) {
                        collisionOccurred = externalForcePointTwo.resolveCollision((Vector3DReadOnly)velocityWorld, (Vector3DReadOnly)this.normal, this.epsilon, this.mu, (Vector3DBasics)p_world);
                    } else {
                        double penetrationSquared = this.point1.distanceSquared((Point3DReadOnly)this.point2);
                        externalForcePointTwo.resolveMicroCollision(penetrationSquared, (Vector3DReadOnly)velocityWorld, (Vector3DReadOnly)this.normal, this.epsilon, this.mu, (Vector3DBasics)p_world);
                        collisionOccurred = true;
                    }
                } else {
                    Vector3D velocityVectorOne = externalForcePointOne.getVelocityCopy();
                    Vector3D velocityVectorTwo = externalForcePointTwo.getVelocityCopy();
                    Vector3D velocityDifference = new Vector3D();
                    velocityDifference.sub((Tuple3DReadOnly)velocityVectorTwo, (Tuple3DReadOnly)velocityVectorOne);
                    if (velocityDifference.lengthSquared() > this.velocityForMicrocollision * this.velocityForMicrocollision) {
                        collisionOccurred = externalForcePointOne.resolveCollision(externalForcePointTwo, (Vector3DReadOnly)this.negative_normal, this.epsilon, this.mu, (Vector3DBasics)p_world);
                    } else {
                        double penetrationSquared = this.point1.distanceSquared((Point3DReadOnly)this.point2);
                        collisionOccurred = externalForcePointOne.resolveMicroCollision(penetrationSquared, externalForcePointTwo, (Vector3DReadOnly)this.negative_normal, this.epsilon, this.mu, (Vector3DBasics)p_world);
                    }
                }
                if (!collisionOccurred) continue;
                for (CollisionHandlerListener listener : this.listeners) {
                    listener.collision(shape1, shape2, externalForcePointOne, externalForcePointTwo, null, null);
                }
            }
        }
    }

    @Override
    public void addListener(CollisionHandlerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void handleCollisions(CollisionDetectionResult results) {
        this.maintenanceBeforeCollisionDetection();
        for (int i = 0; i < results.getNumberOfCollisions(); ++i) {
            Contacts collision = results.getCollision(i);
            this.handle(collision);
        }
        this.maintenanceAfterCollisionDetection();
    }

    @Override
    public void addContactingExternalForcePoints(Link link, List<ContactingExternalForcePoint> contactingExternalForcePoints) {
    }
}

