/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class SplashPanel
extends JPanel {
    private static final long serialVersionUID = -6476659432543699862L;
    private Image splashImage;
    private boolean splashImageLoaded = false;

    public SplashPanel() {
        this.setBackground(new Color(0, 255, 0, 0));
        URL imageURL = SplashPanel.class.getClassLoader().getResource("images/SplashScreen.png");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.splashImage = toolkit.getImage(imageURL);
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.splashImage, 1);
        this.waitABitForMediaToLoad(tracker);
        this.splashImageLoaded = tracker.checkAll();
    }

    private void waitABitForMediaToLoad(MediaTracker tracker) {
        for (int numberOfWaitCycles = 0; numberOfWaitCycles < 10 && !tracker.checkAll(true); ++numberOfWaitCycles) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public Dimension getImageSize() {
        return new Dimension(this.splashImage.getWidth(this), this.splashImage.getHeight(this));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.splashImage, 0, 0, this);
    }

    public boolean isSplashImageLoaded() {
        return this.splashImageLoaded;
    }

    public JWindow showSplashScreen() {
        for (int numberOfAttempts = 0; numberOfAttempts < 10 && !this.isSplashImageLoaded(); ++numberOfAttempts) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        JWindow splashWindow = new JWindow();
        splashWindow.setBackground(new Color(0, 255, 0, 0));
        Container splashContentPane = splashWindow.getContentPane();
        splashContentPane.add(this);
        Dimension imageSize = this.getImageSize();
        splashWindow.setSize(new Dimension(imageSize));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        splashWindow.setLocation((screenSize.width - imageSize.width) / 2, (screenSize.height - imageSize.height) / 2);
        splashWindow.validate();
        splashWindow.setVisible(true);
        return splashWindow;
    }
}

