/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;

public class RampTerrainObject
implements TerrainObject3D,
HeightMapWithNormals {
    private final double xMin;
    private final double xMax;
    private final double yMin;
    private final double yMax;
    private final double xStart;
    private final double xEnd;
    private final double zStart;
    private final double zEnd;
    private final BoundingBox3D boundingBox;
    private Graphics3DObject linkGraphics;
    private final ArrayList<Shape3DReadOnly> terrainCollisionShapes = new ArrayList();

    public RampTerrainObject(double xStart, double yStart, double xEnd, double yEnd, double height, AppearanceDefinition appearance) {
        this(xStart, yStart, xEnd, yEnd, 0.0, height, appearance);
    }

    public RampTerrainObject(double xStart, double yStart, double xEnd, double yEnd, double zStart, double zEnd, AppearanceDefinition appearance) {
        this.xStart = xStart;
        this.xEnd = xEnd;
        this.zStart = zStart;
        this.zEnd = zEnd;
        this.xMin = Math.min(xStart, xEnd);
        this.xMax = Math.max(xStart, xEnd);
        this.yMin = Math.min(yStart, yEnd);
        this.yMax = Math.max(yStart, yEnd);
        this.linkGraphics = new Graphics3DObject();
        this.linkGraphics.translate((xStart + xEnd) / 2.0, (yStart + yEnd) / 2.0, zStart);
        if (xStart > xEnd) {
            this.linkGraphics.rotate(Math.PI, Axis3D.Z);
        }
        this.linkGraphics.addWedge(Math.abs(xEnd - xStart), Math.abs(yEnd - yStart), zEnd - zStart, appearance);
        Point3D minPoint = new Point3D(this.xMin, this.yMin, Double.NEGATIVE_INFINITY);
        Point3D maxPoint = new Point3D(this.xMax, this.yMax, zEnd);
        this.boundingBox = new BoundingBox3D((Point3DReadOnly)minPoint, (Point3DReadOnly)maxPoint);
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.appendTranslation((xStart + xEnd) / 2.0, (yStart + yEnd) / 2.0, zStart);
        if (xStart > xEnd) {
            transform.appendYawRotation(Math.PI);
        }
        Ramp3D ramp3DShape = new Ramp3D((RigidBodyTransformReadOnly)transform, Math.abs(xEnd - xStart), Math.abs(yEnd - yStart), Math.abs(zEnd - zStart));
        this.terrainCollisionShapes.add((Shape3DReadOnly)ramp3DShape);
    }

    public RampTerrainObject(double xStart, double yStart, double xEnd, double yEnd, double height) {
        this(xStart, yStart, xEnd, yEnd, 0.0, height, YoAppearance.Black());
    }

    public RampTerrainObject(double xStart, double yStart, double xEnd, double yEnd, double zStart, double zEnd) {
        this(xStart, yStart, xEnd, yEnd, zStart, zEnd, YoAppearance.Black());
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.linkGraphics;
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double heightAt = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return heightAt;
    }

    public double heightAt(double x, double y, double z) {
        if (x > this.xMin && x < this.xMax && y > this.yMin && y < this.yMax) {
            return this.zStart + (x - this.xStart) / (this.xEnd - this.xStart) * (this.zEnd - this.zStart);
        }
        return 0.0;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        double threshhold = 0.015;
        normal.setX(0.0);
        normal.setY(0.0);
        normal.setZ(1.0);
        if (x < this.xMin || x > this.xMax || y < this.yMin || y > this.yMax || z > this.zEnd) {
            return;
        }
        if (z > this.heightAt(x, y, z) - threshhold) {
            normal.setX(this.zEnd - this.zStart);
            normal.setY(0.0);
            normal.setZ(this.xStart - this.xEnd);
            normal.normalize();
            if (normal.getZ() < 0.0) {
                normal.scale(-1.0);
            }
        } else if (Math.abs(x - this.xEnd) < threshhold) {
            if (this.xEnd > this.xStart) {
                normal.setX(1.0);
            } else {
                normal.setX(-1.0);
            }
            normal.setY(0.0);
            normal.setZ(0.0);
        } else if (Math.abs(y - this.yMin) < threshhold) {
            normal.setX(0.0);
            normal.setY(-1.0);
            normal.setZ(0.0);
        } else if (Math.abs(y - this.yMax) < threshhold) {
            normal.setX(0.0);
            normal.setY(1.0);
            normal.setZ(0.0);
        }
    }

    public void closestIntersectionTo(double x, double y, double z, Point3DBasics intersection) {
        intersection.setX(x);
        intersection.setY(y);
        intersection.setZ(this.heightAt(x, y, z));
    }

    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3DBasics intersection, Vector3DBasics normal) {
        intersection.setX(x);
        intersection.setY(y);
        intersection.setZ(this.heightAt(x, y, z));
        this.surfaceNormalAt(x, y, z, normal);
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        double heightAt = this.heightAt(x, y, z);
        if (z > heightAt) {
            return false;
        }
        intersectionToPack.set(x, y, heightAt);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return true;
    }

    public boolean isClose(double x, double y, double z) {
        return this.boundingBox.isXYInsideInclusive(x, y);
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMax() {
        return this.yMax;
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this;
    }

    @Override
    public List<? extends Shape3DReadOnly> getTerrainCollisionShapes() {
        return this.terrainCollisionShapes;
    }
}

