/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision.simple;

import java.util.Collection;
import java.util.LinkedHashMap;
import us.ihmc.simulationconstructionset.physics.CollisionArbiter;
import us.ihmc.simulationconstructionset.physics.CollisionShape;
import us.ihmc.simulationconstructionset.physics.Contacts;
import us.ihmc.simulationconstructionset.physics.collision.CollisionDetectionResult;
import us.ihmc.simulationconstructionset.physics.collision.simple.SimpleContactWrapper;

public class ExperimentalCollisionArbiter
implements CollisionArbiter {
    private final LinkedHashMap<CollisionShape, LinkedHashMap<CollisionShape, SimpleContactWrapper>> contactMap = new LinkedHashMap();

    @Override
    public void processNewCollisions(CollisionDetectionResult newCollisions) {
        int numberOfCollisions = newCollisions.getNumberOfCollisions();
        for (int i = 0; i < numberOfCollisions; ++i) {
            Contacts collision = newCollisions.getCollision(i);
            CollisionShape shapeA = collision.getShapeA();
            CollisionShape shapeB = collision.getShapeB();
            SimpleContactWrapper shapeABContacts = this.getOrCreateContacts(shapeA, shapeB);
            shapeABContacts.set(collision);
        }
    }

    private SimpleContactWrapper getOrCreateContacts(CollisionShape shapeA, CollisionShape shapeB) {
        SimpleContactWrapper contactsBetweenShapesAAndB;
        LinkedHashMap<CollisionShape, SimpleContactWrapper> shapeAContacts = this.contactMap.get(shapeA);
        LinkedHashMap<CollisionShape, SimpleContactWrapper> shapeBContacts = this.contactMap.get(shapeB);
        if (shapeAContacts == null && shapeBContacts == null) {
            shapeAContacts = new LinkedHashMap();
            SimpleContactWrapper contactsBetweenShapesAAndB2 = new SimpleContactWrapper(shapeA, shapeB);
            shapeAContacts.put(shapeB, contactsBetweenShapesAAndB2);
            this.contactMap.put(shapeA, shapeAContacts);
            return contactsBetweenShapesAAndB2;
        }
        if (shapeAContacts == null) {
            LinkedHashMap<CollisionShape, SimpleContactWrapper> temp = shapeAContacts;
            shapeAContacts = shapeBContacts;
            shapeBContacts = shapeAContacts;
            CollisionShape tempShape = shapeA;
            shapeB = shapeA = shapeB;
        }
        if ((contactsBetweenShapesAAndB = shapeAContacts.get(shapeB)) == null) {
            contactsBetweenShapesAAndB = new SimpleContactWrapper(shapeA, shapeB);
            shapeAContacts.put(shapeB, contactsBetweenShapesAAndB);
        }
        return contactsBetweenShapesAAndB;
    }

    @Override
    public CollisionDetectionResult getCollisions() {
        CollisionDetectionResult results = new CollisionDetectionResult();
        Collection<LinkedHashMap<CollisionShape, SimpleContactWrapper>> valuesOne = this.contactMap.values();
        for (LinkedHashMap<CollisionShape, SimpleContactWrapper> valueOne : valuesOne) {
            Collection<SimpleContactWrapper> valuesTwo = valueOne.values();
            for (SimpleContactWrapper contacts : valuesTwo) {
                results.addContact(contacts);
            }
        }
        return results;
    }
}

