/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import us.ihmc.simulationconstructionset.gui.ExportDataDialogListener;
import us.ihmc.simulationconstructionset.gui.config.VarGroupList;
import us.ihmc.simulationconstructionset.gui.dialogs.SCSExportDataFormat;

public class ExportDataDialog
extends JDialog
implements ActionListener {
    public static final int STATE = 0;
    public static final int DATA = 1;
    public static final int COMPRESS = 5;
    public static final int NO_COMPRESS = 6;
    private JButton exportButton;
    private JButton cancelButton;
    private ExportDataPanel exportPanel;
    private JFrame parentFrame;
    private ExportDataDialogListener listener;
    private VarGroupList varGroupList;

    public ExportDataDialog(JFrame frame, VarGroupList varGroupList, ExportDataDialogListener listener) {
        super(frame, "Export Data", false);
        this.parentFrame = frame;
        this.listener = listener;
        this.varGroupList = varGroupList;
        Container contentPane = this.getContentPane();
        this.exportPanel = new ExportDataPanel();
        contentPane.add(this.exportPanel);
        this.exportButton = new JButton("Export");
        this.exportButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.exportButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        Point point = frame.getLocation();
        Dimension frameSize = frame.getSize();
        point.translate(frameSize.width / 2, frameSize.height / 4);
        this.setLocation(point);
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
        this.parentFrame.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
        if (event.getSource() == this.exportButton) {
            this.setVisible(false);
            this.exportPanel.export();
        }
        this.parentFrame.repaint();
    }

    private class ExportDataPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 2066572350748134411L;
        private JLabel varGroupJLabel = new JLabel();
        private GridBagLayout gridBagLayout1 = new GridBagLayout();
        private JComboBox varGroupComboBox = new JComboBox();
        private ButtonGroup stateDataButtonGroup = new ButtonGroup();
        private JRadioButton stateRadioButton = new JRadioButton();
        private JRadioButton dataRadioButton = new JRadioButton();
        private JRadioButton asciiRadioButton = new JRadioButton();
        private JRadioButton matlabRadioButton = new JRadioButton();
        private JRadioButton spreadsheetRadioButton = new JRadioButton();
        private JRadioButton binaryRadioButton = new JRadioButton();
        private ButtonGroup dataFormatButtonGroup = new ButtonGroup();
        private JRadioButton compressRadioButton = new JRadioButton();
        private JRadioButton noCompressRadioButton = new JRadioButton();
        private ButtonGroup compressButtonGroup = new ButtonGroup();
        private Component horizontalStrut1 = Box.createHorizontalStrut(60);
        private Component verticalStrut1 = Box.createVerticalStrut(4);

        public ExportDataPanel() {
            this.varGroupJLabel.setToolTipText("");
            this.varGroupJLabel.setText("VarGroup:   ");
            this.setLayout(this.gridBagLayout1);
            this.stateRadioButton.setText("State");
            this.stateRadioButton.setSelected(false);
            this.stateRadioButton.addActionListener(this);
            this.dataRadioButton.setText("Data");
            this.dataRadioButton.setSelected(true);
            this.dataRadioButton.addActionListener(this);
            this.asciiRadioButton.setText("ASCII (Similar to Matlab/Octave Script)");
            this.asciiRadioButton.setSelected(false);
            this.asciiRadioButton.addActionListener(this);
            this.binaryRadioButton.setText("Binary");
            this.binaryRadioButton.setSelected(true);
            this.binaryRadioButton.addActionListener(this);
            this.matlabRadioButton.setText("Matlab/Octave (*.mat)");
            this.matlabRadioButton.setSelected(false);
            this.matlabRadioButton.addActionListener(this);
            this.spreadsheetRadioButton.setText("Comma-Separated-Values (CSV)");
            this.spreadsheetRadioButton.setSelected(false);
            this.spreadsheetRadioButton.addActionListener(this);
            this.compressRadioButton.setText("Compress");
            this.compressRadioButton.setSelected(true);
            this.compressRadioButton.addActionListener(this);
            this.noCompressRadioButton.setText("No Compression");
            this.noCompressRadioButton.setSelected(false);
            this.noCompressRadioButton.addActionListener(this);
            this.stateDataButtonGroup.add(this.stateRadioButton);
            this.stateDataButtonGroup.add(this.dataRadioButton);
            this.dataFormatButtonGroup.add(this.asciiRadioButton);
            this.dataFormatButtonGroup.add(this.binaryRadioButton);
            this.dataFormatButtonGroup.add(this.matlabRadioButton);
            this.dataFormatButtonGroup.add(this.spreadsheetRadioButton);
            this.compressButtonGroup.add(this.compressRadioButton);
            this.compressButtonGroup.add(this.noCompressRadioButton);
            this.varGroupComboBox.setMaximumSize(new Dimension(125, 21));
            this.varGroupComboBox.setMinimumSize(new Dimension(125, 21));
            this.varGroupComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            this.varGroupComboBox.addItem("all");
            String[] names = ExportDataDialog.this.varGroupList.getVarGroupNames();
            for (int i = 0; i < names.length; ++i) {
                this.varGroupComboBox.addItem(names[i]);
            }
            this.add((Component)this.varGroupComboBox, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 36, 0));
            this.add((Component)this.varGroupJLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.add(this.horizontalStrut1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.stateRadioButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.add((Component)this.dataRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.add(this.verticalStrut1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.binaryRadioButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.asciiRadioButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.matlabRadioButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.spreadsheetRadioButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.verticalStrut1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.compressRadioButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.noCompressRadioButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.verticalStrut1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            Border blackLine = BorderFactory.createLineBorder(Color.black);
            this.setBorder(blackLine);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.stateRadioButton) {
                this.asciiRadioButton.setSelected(true);
                this.binaryRadioButton.setEnabled(false);
                this.matlabRadioButton.setEnabled(false);
                this.spreadsheetRadioButton.setEnabled(false);
                this.noCompressRadioButton.setSelected(true);
            }
            if (event.getSource() == this.dataRadioButton) {
                this.binaryRadioButton.setEnabled(true);
                this.binaryRadioButton.setSelected(true);
                this.matlabRadioButton.setEnabled(true);
                this.spreadsheetRadioButton.setEnabled(true);
                this.compressRadioButton.setSelected(true);
            }
            if (event.getSource() == this.asciiRadioButton) {
                this.noCompressRadioButton.setSelected(true);
            }
            if (event.getSource() == this.binaryRadioButton) {
                this.compressRadioButton.setSelected(true);
            }
            if (event.getSource() == this.matlabRadioButton || event.getSource() == this.spreadsheetRadioButton) {
                this.compressRadioButton.setEnabled(false);
                this.noCompressRadioButton.setEnabled(false);
            } else {
                this.compressRadioButton.setEnabled(true);
                this.noCompressRadioButton.setEnabled(true);
            }
        }

        public void export() {
            SCSExportDataFormat dataFormat;
            int dataType;
            String varGroup = this.varGroupComboBox.getSelectedItem().toString();
            int n = dataType = this.stateRadioButton.isSelected() ? 0 : 1;
            if (this.asciiRadioButton.isSelected()) {
                dataFormat = SCSExportDataFormat.ASCII;
            } else if (this.binaryRadioButton.isSelected()) {
                dataFormat = SCSExportDataFormat.BINARY;
            } else if (this.matlabRadioButton.isSelected()) {
                dataFormat = SCSExportDataFormat.MATLAB;
            } else if (this.spreadsheetRadioButton.isSelected()) {
                dataFormat = SCSExportDataFormat.SPREADSHEET;
            } else {
                throw new RuntimeException("unknown data format");
            }
            int dataCompression = this.compressRadioButton.isSelected() ? 5 : 6;
            ExportDataDialog.this.listener.export(varGroup, dataType, dataFormat, dataCompression);
        }
    }
}

