/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class OneDegreeOfFreedomJoint
extends Joint {
    private static final long serialVersionUID = -462519687462777726L;
    private double kp = 0.0;
    private double kd = 0.0;
    private double qDesired = 0.0;
    private double qdDesired = 0.0;

    public OneDegreeOfFreedomJoint(String jname, Tuple3DReadOnly offset, Robot rob) {
        super(jname, offset, rob, 1);
    }

    public abstract YoDouble getQDDYoVariable();

    public abstract double getQDD();

    public abstract YoDouble getQDYoVariable();

    public abstract double getQD();

    public abstract YoDouble getQYoVariable();

    public abstract double getQ();

    public abstract void setQdd(double var1);

    public abstract void setQd(double var1);

    public abstract void setQ(double var1);

    public abstract void setTau(double var1);

    public abstract YoDouble getTauYoVariable();

    public abstract double getTau();

    public abstract double getDamping();

    public abstract void setDamping(double var1);

    public abstract double getTorqueLimit();

    public abstract double getVelocityLimit();

    public abstract double getJointUpperLimit();

    public abstract double getJointLowerLimit();

    public abstract double getJointStiction();

    public double getKp() {
        return this.kp;
    }

    public double getKd() {
        return this.kd;
    }

    public double getqDesired() {
        return this.qDesired;
    }

    public double getQdDesired() {
        return this.qdDesired;
    }

    public void setKp(double kp) {
        this.kp = kp;
    }

    public void setKd(double kd) {
        this.kd = kd;
    }

    public void setqDesired(double qDesired) {
        this.qDesired = qDesired;
    }

    public void setQdDesired(double qdDesired) {
        this.qdDesired = qdDesired;
    }

    public double doPDControl() {
        double qError = this.qDesired - this.getQYoVariable().getDoubleValue();
        double qdError = this.qdDesired - this.getQDYoVariable().getDoubleValue();
        return this.kp * qError + this.kd * qdError;
    }
}

