/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics;

import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.physics.ExternalForcePointPDConstraintToIntegrate;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ExternalForcePointPIDConstraintToIntegrate
extends ExternalForcePointPDConstraintToIntegrate {
    private final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoDouble integralStiffness;
    private final YoFrameVector3D yoConnectionPositionIntegratedError;
    private final FrameVector3D integralForce;
    private final Vector3D tempForce = new Vector3D();

    public ExternalForcePointPIDConstraintToIntegrate(String name, ExternalForcePoint connectionPointA, ExternalForcePoint connectionPointB, YoRegistry parentRegistry) {
        super(name, connectionPointA, connectionPointB, parentRegistry);
        this.integralStiffness = new YoDouble(name + "_IntegralStiffness", this.registry);
        this.yoConnectionPositionIntegratedError = new YoFrameVector3D(name + "_ConnectionPositionIntegratedError", this.worldFrame, this.registry);
        this.integralForce = new FrameVector3D(this.worldFrame);
    }

    public void setIntegralStiffness(double integralStiffness) {
        this.integralStiffness.set(integralStiffness);
    }

    @Override
    protected void updateClosedJoint() {
        super.updateClosedJoint();
        this.integralForce.setAndScale(this.integralStiffness.getDoubleValue(), (FrameTuple3DReadOnly)this.yoConnectionPositionIntegratedError);
        this.connectionPointA.getForce((Vector3DBasics)this.tempForce);
        this.tempForce.add((Tuple3DReadOnly)this.integralForce);
        this.connectionPointA.setForce((Vector3DReadOnly)this.tempForce);
        this.tempForce.scale(-1.0);
        this.connectionPointB.setForce((Vector3DReadOnly)this.tempForce);
    }

    @Override
    public double[] computeDerivativeVector() {
        this.updateClosedJoint();
        return new double[]{this.yoConnectionPositionError.getX(), this.yoConnectionPositionError.getY(), this.yoConnectionPositionError.getZ()};
    }

    @Override
    public int getVectorSize() {
        return 3;
    }

    @Override
    public YoDouble[] getOutputVariables() {
        return new YoDouble[]{this.yoConnectionPositionIntegratedError.getYoX(), this.yoConnectionPositionIntegratedError.getYoY(), this.yoConnectionPositionIntegratedError.getYoZ()};
    }
}

