/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import us.ihmc.yoVariables.buffer.YoBufferBounds;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryReader;

public class VarPropertiesPanel
extends JPanel
implements ActionListener {
    private static final NumberFormat numFormat = new DecimalFormat(" 0.00000;-0.00000");
    private JTextField minTextField;
    private JTextField maxTextField;
    private JRadioButton autoButton;
    private JRadioButton manualButton;
    private JCheckBox invertCheckBox;
    private final YoBufferVariableEntryReader entry;
    private double newMinVal;
    private double newMaxVal;

    public VarPropertiesPanel(YoBufferVariableEntryReader entry) {
        this.entry = entry;
        this.newMinVal = entry.getCustomLowerBound();
        this.newMaxVal = entry.getCustomUpperBound();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        Border blackLine = BorderFactory.createLineBorder(Color.black);
        TitledBorder title = BorderFactory.createTitledBorder(blackLine, entry.getVariableName());
        this.setBorder(title);
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel scalingLabel = new JLabel("Scaling:  ");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 13;
        gridbag.setConstraints(scalingLabel, constraints);
        this.add(scalingLabel);
        this.autoButton = new JRadioButton("Auto", !entry.isUsingCustomBounds());
        this.autoButton.addActionListener(this);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        gridbag.setConstraints(this.autoButton, constraints);
        this.add(this.autoButton);
        this.manualButton = new JRadioButton("Manual", entry.isUsingCustomBounds());
        this.manualButton.addActionListener(this);
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.anchor = 17;
        gridbag.setConstraints(this.manualButton, constraints);
        this.add(this.manualButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.autoButton);
        group.add(this.manualButton);
        JLabel settingsLabel = new JLabel("Manual Settings:  ");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        gridbag.setConstraints(settingsLabel, constraints);
        this.add(settingsLabel);
        JLabel minSettingsLabel = new JLabel("  Min:  ");
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        gridbag.setConstraints(minSettingsLabel, constraints);
        this.add(minSettingsLabel);
        String minValString = numFormat.format(this.newMinVal);
        this.minTextField = new JTextField(minValString);
        this.minTextField.addActionListener(this);
        if (entry.isUsingCustomBounds()) {
            this.minTextField.setEnabled(false);
        }
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        gridbag.setConstraints(this.minTextField, constraints);
        this.add(this.minTextField);
        JLabel maxSettingsLabel = new JLabel("  Max:  ");
        constraints.gridx = 4;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        gridbag.setConstraints(maxSettingsLabel, constraints);
        this.add(maxSettingsLabel);
        String maxValString = numFormat.format(this.newMaxVal);
        this.maxTextField = new JTextField(maxValString);
        this.maxTextField.addActionListener(this);
        if (entry.isUsingCustomBounds()) {
            this.maxTextField.setEnabled(false);
        }
        constraints.gridx = 5;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        gridbag.setConstraints(this.maxTextField, constraints);
        this.add(this.maxTextField);
        JLabel rangeLabel = new JLabel("Data Range:  ");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.anchor = 13;
        gridbag.setConstraints(rangeLabel, constraints);
        this.add(rangeLabel);
        JLabel minRangeLabel = new JLabel("  Min:  ");
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        gridbag.setConstraints(minRangeLabel, constraints);
        this.add(minRangeLabel);
        YoBufferBounds bounds = entry.getBounds();
        minValString = numFormat.format(bounds.getLowerBound());
        JLabel minTextLabel = new JLabel(minValString);
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        gridbag.setConstraints(minTextLabel, constraints);
        this.add(minTextLabel);
        JLabel maxRangeLabel = new JLabel("  Max:  ");
        constraints.gridx = 4;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        gridbag.setConstraints(maxRangeLabel, constraints);
        this.add(maxRangeLabel);
        maxValString = numFormat.format(bounds.getUpperBound());
        JLabel maxTextLabel = new JLabel(maxValString);
        constraints.gridx = 5;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        gridbag.setConstraints(maxTextLabel, constraints);
        this.add(maxTextLabel);
        this.invertCheckBox = new JCheckBox("Invert");
        this.invertCheckBox.setSelected(entry.getInverted());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.anchor = 13;
        gridbag.setConstraints(this.invertCheckBox, constraints);
        this.add(this.invertCheckBox);
    }

    public void commitChanges() {
        this.updateMinTextField();
        this.updateMaxTextField();
        this.entry.setCustomBounds(this.newMinVal, this.newMaxVal);
        this.entry.useCustomBounds(!this.autoButton.isSelected());
        this.entry.setInverted(this.invertCheckBox.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.maxTextField) {
            this.updateMaxTextField();
        }
        if (event.getSource() == this.minTextField) {
            this.updateMinTextField();
        }
        if (event.getSource() == this.autoButton) {
            this.maxTextField.setEnabled(false);
            this.minTextField.setEnabled(false);
        }
        if (event.getSource() == this.manualButton) {
            this.maxTextField.setEnabled(true);
            this.minTextField.setEnabled(true);
        }
    }

    public void updateMaxTextField() {
        String text = this.maxTextField.getText();
        try {
            double val;
            this.newMaxVal = val = Double.valueOf(text).doubleValue();
        }
        catch (NumberFormatException e) {
            this.maxTextField.setText(numFormat.format(this.newMaxVal));
        }
    }

    public void updateMinTextField() {
        String text = this.minTextField.getText();
        try {
            double val;
            this.newMinVal = val = Double.valueOf(text).doubleValue();
        }
        catch (NumberFormatException e) {
            this.minTextField.setText(numFormat.format(this.newMinVal));
        }
    }
}

