/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.simulationconstructionset.GraphConfiguration;
import us.ihmc.simulationconstructionset.gui.GraphArrayWindow;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.ViewportWindow;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.GUIEnablerAndDisabler;
import us.ihmc.simulationconstructionset.util.XMLReaderUtility;

public class GUIConfigurationSaveAndLoad {
    private JFileChooser dataFileChooser;
    private StandardSimulationGUI myGUI;
    private boolean loadGraphGroups = true;
    private boolean loadEntryBoxes = true;
    private boolean loadViewPorts = false;
    private boolean loadGraphWindows = true;
    private boolean loadJPanels = false;
    private boolean loadMultiViews = false;

    public GUIConfigurationSaveAndLoad(GUIEnablerAndDisabler guiEnablerAndDisabler, StandardSimulationGUI myGUI) {
        this.myGUI = myGUI;
    }

    public void setCurrentDirectory(File dir) {
        this.dataFileChooser.setCurrentDirectory(dir);
    }

    public void setCurrentDirectory(String dir) {
        this.dataFileChooser.setCurrentDirectory(new File(dir));
    }

    public void defaultSave(String fileName) {
        File guiConfig = new File(fileName);
        if (guiConfig.exists()) {
            guiConfig.delete();
        }
        BufferedWriter output = null;
        guiConfig = new File(fileName);
        try {
            output = new BufferedWriter(new FileWriter(guiConfig));
            output.write(this.writeGUIConfig());
            ((Writer)output).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String writeGUIConfig() {
        Object textToWrite = this.myGUI.getXMLStyleRepresentationOfGraphArrayPanel();
        textToWrite = (String)textToWrite + "\n" + this.myGUI.getXMLStyleRepresentationOfEntryBoxes();
        textToWrite = (String)textToWrite + "\n" + this.myGUI.getXMLStyleRepresentationOfViewPorts();
        textToWrite = (String)textToWrite + "\n" + this.myGUI.getXMLStyleRepresentationOfGraphWindows();
        textToWrite = (String)textToWrite + "\n" + this.myGUI.getXMLStyleRepresentationofJPanels();
        textToWrite = (String)textToWrite + "\n" + this.myGUI.getXMLStyleRepresentationofMultiViews();
        return textToWrite;
    }

    public void saveNormalGUIConfiguration() {
        String path = GUIConfigurationSaveAndLoad.getConfigurationDirectoryPath();
        File NormalConfig = new File(path + "/NormalConfiguration.guiConf");
        if (!NormalConfig.exists()) {
            BufferedWriter output = null;
            try {
                output = new BufferedWriter(new FileWriter(NormalConfig));
                output.write(this.writeGUIConfig());
                ((Writer)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void defaultGraphConfigurationLoad(String fileName) {
        String path = GUIConfigurationSaveAndLoad.getConfigurationDirectoryPath();
        try {
            File guiConfig = new File(path + "/" + fileName + ".graphConf");
            if (guiConfig.exists()) {
                String tempLine;
                BufferedReader reader = new BufferedReader(new FileReader(guiConfig));
                Object xmlRepresentation = "";
                String fileEnding = ".graphConf";
                String name = guiConfig.getName().substring(0, guiConfig.getName().length() - fileEnding.length());
                while ((tempLine = reader.readLine()) != null) {
                    xmlRepresentation = (String)xmlRepresentation + tempLine;
                }
                GUIConfigurationSaveAndLoad.setupGraphGroups(this.myGUI, (String)xmlRepresentation, name);
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadGUIConfiguration(String fileName) {
        if (fileName == null) {
            return;
        }
        try {
            File guiConfig = new File(fileName);
            if (guiConfig.exists()) {
                String tempLine;
                BufferedReader reader = new BufferedReader(new FileReader(guiConfig));
                Object xmlRepresentation = "";
                String fileEnding = ".dat";
                String name = guiConfig.getName().substring(0, guiConfig.getName().length() - fileEnding.length());
                while ((tempLine = reader.readLine()) != null) {
                    xmlRepresentation = (String)xmlRepresentation + tempLine;
                }
                if (this.loadGraphGroups) {
                    GUIConfigurationSaveAndLoad.setupGraphGroups(this.myGUI, (String)xmlRepresentation, name);
                }
                if (this.loadEntryBoxes) {
                    this.loadEntryBoxArrayTabbedPanel((String)xmlRepresentation);
                }
                if (this.loadViewPorts) {
                    this.setupMainViewport((String)xmlRepresentation);
                    this.setupViewportWindows((String)xmlRepresentation);
                }
                if (this.loadGraphWindows) {
                    this.setupGraphWindows((String)xmlRepresentation, "GraphWindows" + name);
                    this.setupConfiguration(name);
                }
                if (this.loadMultiViews) {
                    this.setupMultiViews((String)xmlRepresentation);
                }
                if (this.loadJPanels) {
                    this.setupJPanels((String)xmlRepresentation);
                }
                this.myGUI.makeCheckBoxesConsistentWithCamera();
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setupMultiViews(String xmlRepresentation) {
        this.myGUI.addViewportPanelToMainPanel();
        String currentView = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)"<Current View>", (String)"</Current View>");
        this.myGUI.selectViewport(currentView);
        this.myGUI.setupMultiViews(xmlRepresentation, currentView);
    }

    public void setupJPanels(String xmlRepresentation) {
        int i;
        String extraPanel = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)"<Extra Panels>", (String)"</Extra Panels>");
        int numberOfViewports = Integer.parseInt(XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)"<Number of ViewPorts>", (String)"</Number of ViewPorts>"));
        String mainViewportPanels = XMLReaderUtility.getMiddleString((int)0, (String)extraPanel, (String)"<Main Viewport>", (String)"</Main Viewport>");
        StringTokenizer tok = new StringTokenizer(mainViewportPanels, ",");
        String jPanelName = "";
        int size = tok.countTokens();
        for (i = 0; i < size; ++i) {
            jPanelName = tok.nextToken();
            this.myGUI.addPanelToTempHolderMainViewport(jPanelName);
            this.myGUI.makeCheckMarksConsistentForExtraPanels(jPanelName, true);
        }
        for (i = 1; i < numberOfViewports; ++i) {
            String viewportStartName = "<Viewport" + i + ">";
            String viewportEndName = "</Viewport" + i + ">";
            String viewport = XMLReaderUtility.getMiddleString((int)0, (String)extraPanel, (String)viewportStartName, (String)viewportEndName);
            StringTokenizer viewportToken = new StringTokenizer(viewport, ",");
            jPanelName = "";
            size = viewportToken.countTokens();
            for (int j = 0; j < size; ++j) {
                jPanelName = viewportToken.nextToken();
                this.myGUI.addPanelToTempHolderViewport(jPanelName, i);
                this.myGUI.makeCheckMarksConsistentForExtraPanels(jPanelName, true);
            }
        }
    }

    public void setupMainViewport(String xmlRepresentation) {
        boolean visible = this.myGUI.setViewportFromXMLDescription(xmlRepresentation);
        if (!visible) {
            this.myGUI.hideViewport();
        }
    }

    public void setupViewportWindows(String xmlRepresentation) {
        int i;
        int numberOfViewports = Integer.parseInt(XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)"<Number of ViewPorts>", (String)"</Number of ViewPorts>"));
        List<ViewportWindow> windows = this.myGUI.getViewportWindows();
        for (i = windows.size() - 1; i >= 0; --i) {
            windows.get(i).closeWindow();
            windows.remove(i);
        }
        for (i = 1; i < numberOfViewports; ++i) {
            String second;
            CameraConfiguration config = new CameraConfiguration("viewport" + i);
            boolean maximizeWindow = false;
            String first = "<Viewport" + i + ">";
            String textToLoad = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)first, (String)(second = "</Viewport" + i + ">"));
            String visible = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Visible>", (String)"</Visible>").trim();
            if (visible.equals("false")) {
                this.myGUI.createNewViewportWindow("viewport" + i, 1, maximizeWindow, config).hideViewport();
            } else {
                this.myGUI.createNewViewportWindow("viewport" + i, 1, maximizeWindow, config);
            }
            int canvasNumber = Integer.parseInt(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Canvas Number>", (String)"</Canvas Number>"));
            String currentView = "Normal View";
            if (canvasNumber == 2) {
                currentView = "Split Screen";
            }
            if (canvasNumber == 3) {
                currentView = "Three Views";
            }
            if (canvasNumber == 4) {
                currentView = "Four Views";
            }
            this.myGUI.selectViewport_ViewPorts(currentView);
            this.myGUI.setupMultiViewsMultipleViewports(textToLoad, canvasNumber);
        }
    }

    public static void setupGraphGroups(StandardSimulationGUI myGUI, String xmlRepresentation, String name) {
        try {
            String graphGroupString = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)"<GraphGroup>", (String)"</GraphGroup>");
            int numColumns = Integer.parseInt(XMLReaderUtility.getMiddleString((int)0, (String)graphGroupString, (String)"<Cols>", (String)"</Cols>"));
            String graphString = "";
            int currentgraphIndex = 0;
            String[] strArray = graphGroupString.split("<Graph>");
            int numberOfGraphs = strArray.length - 1;
            GraphConfiguration[] graphConfigurations = new GraphConfiguration[numberOfGraphs];
            String[][][] var = new String[numberOfGraphs][][];
            for (int graphIndex = 0; graphIndex < numberOfGraphs; ++graphIndex) {
                GraphConfiguration tmpGraphConfiguration;
                graphString = XMLReaderUtility.getMiddleString((int)currentgraphIndex, (String)graphGroupString, (String)"<Graph>", (String)"</Graph>");
                currentgraphIndex = XMLReaderUtility.getEndIndexOfSubString((int)currentgraphIndex, (String)graphGroupString, (String)"</Graph>");
                String variables = XMLReaderUtility.getMiddleString((int)0, (String)graphString, (String)"<Variables>", (String)"</Variables>");
                StringTokenizer tokenizer = new StringTokenizer(variables, ",");
                int numberOfTokens = tokenizer.countTokens();
                graphConfigurations[graphIndex] = tmpGraphConfiguration = GraphConfiguration.createClassBasedOnXMLRepresentation(0, graphString);
                String[] graphConfigurationStringArray = new String[]{tmpGraphConfiguration.getName()};
                var[graphIndex] = new String[2][numberOfTokens];
                for (int i = 0; i < numberOfTokens; ++i) {
                    var[graphIndex][0][i] = tokenizer.nextToken().trim();
                }
                var[graphIndex][1] = graphConfigurationStringArray;
            }
            myGUI.setupGraphConfigurations(graphConfigurations);
            myGUI.setupGraphGroup(name, var, numColumns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setupGraphWindows(String xmlRepresentation, String name) {
        this.removeOldWindows();
        GUIConfigurationSaveAndLoad.setupGraphWindows(this.myGUI, xmlRepresentation, name);
    }

    public static void setupGraphWindows(StandardSimulationGUI myGUI, String xmlRepresentation, String name) {
        int graphArrayWindowSize = Integer.parseInt(XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)"<Graph Array Window Size>", (String)"</Graph Array Window Size>"));
        for (int windowNumber = 1; windowNumber <= graphArrayWindowSize; ++windowNumber) {
            Object first = "<Graph Array Window" + windowNumber + ">";
            Object second = "</Graph Array Window" + windowNumber + ">";
            String graphWindowString = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)first, (String)second);
            first = "<ScreenID>";
            second = "</ScreenID>";
            String screenIDString = XMLReaderUtility.getMiddleString((int)0, (String)graphWindowString, (String)first, (String)second);
            int screenID = 1;
            if (screenIDString != null) {
                screenID = Integer.parseInt(screenIDString);
            }
            first = "<WindowLocation>";
            second = "</WindowLocation>";
            String windowLocationString = XMLReaderUtility.getMiddleString((int)0, (String)graphWindowString, (String)first, (String)second);
            Point windowLocation = null;
            if (windowLocationString != null) {
                StringTokenizer tokenizer = new StringTokenizer(windowLocationString, ",");
                double xPosition = Double.parseDouble(tokenizer.nextToken());
                double yPosition = Double.parseDouble(tokenizer.nextToken());
                windowLocation = new Point((int)xPosition, (int)yPosition);
            }
            first = "<WindowSize>";
            second = "</WindowSize>";
            String windowSizeString = XMLReaderUtility.getMiddleString((int)0, (String)graphWindowString, (String)first, (String)second);
            Dimension windowSize = null;
            if (windowSizeString != null) {
                StringTokenizer tokenizer = new StringTokenizer(windowSizeString, ",");
                double width = Double.parseDouble(tokenizer.nextToken());
                double height = Double.parseDouble(tokenizer.nextToken());
                windowSize = new Dimension((int)width, (int)height);
            }
            GUIConfigurationSaveAndLoad.setupGraphGroups(myGUI, graphWindowString, name + windowNumber);
            myGUI.createNewGraphWindow(name + windowNumber, screenID, windowLocation, windowSize, false);
        }
    }

    private void removeOldWindows() {
        List<GraphArrayWindow> windows = this.myGUI.getGraphArrayWindows();
        for (int i = windows.size() - 1; i >= 0; --i) {
            windows.get(i).closeWindow();
            windows.remove(i);
        }
    }

    public void setupConfiguration(String configurationName) {
        this.myGUI.setupConfiguration(configurationName, configurationName, configurationName);
        this.myGUI.selectGraphConfiguration(configurationName);
    }

    public void loadEntryBoxArrayTabbedPanel(String XMLStyleRepresentation) {
        String XMLData = XMLReaderUtility.getMiddleString((int)0, (String)XMLStyleRepresentation, (String)"<Entry Boxes Tab Pane>", (String)"</Entry Boxes Tab Pane>");
        if (XMLData == null) {
            return;
        }
        int index = 0;
        while (XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)"</EntryBoxTab>") <= XMLData.length() && XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)"</EntryBoxTab>") > 0) {
            int endIndex = XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)"</EntryBoxTab>");
            String currentXMLEntryTab = XMLData.substring(index, endIndex - 1);
            String name = XMLReaderUtility.getMiddleString((int)0, (String)currentXMLEntryTab, (String)"<Title>", (String)"</Title>");
            String currentXMLEntry = XMLReaderUtility.getMiddleString((int)0, (String)currentXMLEntryTab, (String)"<Entry Boxes>", (String)"</Entry Boxes>");
            this.loadEntryBoxArrayPanel(name, currentXMLEntry);
            index = endIndex;
        }
    }

    public void loadEntryBoxArrayPanel(String tabName, String XMLData) {
        int index = 0;
        int currentNumberOfVariables = 0;
        while (XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",") <= XMLData.length() && XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",") > 0) {
            ++currentNumberOfVariables;
            ++index;
        }
        if (index < XMLData.length()) {
            ++currentNumberOfVariables;
        }
        String[] name = new String[currentNumberOfVariables];
        currentNumberOfVariables = 0;
        index = 0;
        while (XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",") <= XMLData.length() && XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",") > 0) {
            int endIndex = XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",");
            name[currentNumberOfVariables] = XMLData.substring(index, endIndex - 1);
            name[currentNumberOfVariables] = name[currentNumberOfVariables].trim();
            ++currentNumberOfVariables;
            index = endIndex;
        }
        if (index < XMLData.length()) {
            name[currentNumberOfVariables] = XMLData.substring(index, XMLData.length());
            name[currentNumberOfVariables] = name[currentNumberOfVariables].trim();
        }
        this.myGUI.setupEntryBoxGroup(tabName, name);
        this.myGUI.updateGUI();
        this.myGUI.createNewEntryBoxTabFromEntryBoxGroup(tabName);
    }

    public void loadGraphConfigurationsInConfigurationMenu() {
        String[] potentialConfigurationFilenames;
        for (String child : potentialConfigurationFilenames = GUIConfigurationSaveAndLoad.getPotentialConfigurationFilenames()) {
            if (!child.endsWith(".graphConf")) continue;
            int index = child.indexOf(".");
            String name = child.substring(0, index);
            this.defaultGraphConfigurationLoad(name);
        }
    }

    public static String getConfigurationDirectoryPath() {
        File configurationDirectory = GUIConfigurationSaveAndLoad.makeOrFindConfigurationDirectory();
        if (configurationDirectory.isDirectory()) {
            return configurationDirectory.getPath();
        }
        return null;
    }

    public static String[] getPotentialConfigurationFilenames() {
        File configurationDirectory = GUIConfigurationSaveAndLoad.makeOrFindConfigurationDirectory();
        if (configurationDirectory.isDirectory()) {
            return configurationDirectory.list();
        }
        return new String[0];
    }

    public static File makeOrFindConfigurationDirectory() {
        File configurationDirectory = new File("Configurations");
        if (!configurationDirectory.exists()) {
            configurationDirectory.mkdir();
        }
        return configurationDirectory;
    }
}

