/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.io.Serializable;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.KinematicPointUpdater;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class KinematicPoint
implements Serializable {
    private static final long serialVersionUID = 3047881738704107434L;
    private final String name;
    private final YoFramePoint3D positionInWorld;
    private final YoFrameVector3D velocityInWorld;
    private final YoFrameVector3D angularVelocityInWorld;
    private final YoFrameVector3D offsetYoFrameVector;
    protected Joint parentJoint;
    private KinematicPointUpdater kinematicPointUpdater;
    private final YoRegistry registry;
    protected final Vector3D tempVectorForOffsetFromCOM = new Vector3D();
    protected final Vector3D tempVectorForWXr = new Vector3D();
    protected final Vector3D tempVectorForVelocity = new Vector3D();
    private RigidBodyTransform tempTransformFromWorldToJoint = new RigidBodyTransform();
    private Vector4D offsetPlus = new Vector4D();
    private final Point3D tempPoint = new Point3D();

    public KinematicPoint(String name, Robot robot) {
        this(name, null, robot.getRobotsYoRegistry());
    }

    public KinematicPoint(String name, YoRegistry registry) {
        this(name, null, registry);
    }

    public KinematicPoint(String name, Tuple3DReadOnly offset, Robot robot) {
        this(name, offset, robot.getRobotsYoRegistry());
    }

    public KinematicPoint(String name, Tuple3DReadOnly offset, YoRegistry registry) {
        this.name = name;
        this.registry = registry;
        this.positionInWorld = new YoFramePoint3D(name + "_", "", ReferenceFrame.getWorldFrame(), registry);
        this.velocityInWorld = new YoFrameVector3D(name + "_d", "", ReferenceFrame.getWorldFrame(), registry);
        this.angularVelocityInWorld = new YoFrameVector3D(name + "_w", "", ReferenceFrame.getWorldFrame(), registry);
        this.offsetYoFrameVector = new YoFrameVector3D(name + "off", "", ReferenceFrame.getWorldFrame(), registry);
        if (offset != null) {
            this.offsetYoFrameVector.set(offset);
        }
    }

    public void reset() {
        this.parentJoint = null;
        this.offsetYoFrameVector.set(0.0, 0.0, 0.0);
        this.tempVectorForOffsetFromCOM.set(0.0, 0.0, 0.0);
        this.tempVectorForWXr.set(0.0, 0.0, 0.0);
        this.tempVectorForVelocity.set(0.0, 0.0, 0.0);
        this.tempTransformFromWorldToJoint.setIdentity();
        this.offsetPlus.set(0.0, 0.0, 0.0, 0.0);
        this.positionInWorld.set(0.0, 0.0, 0.0);
        this.velocityInWorld.set(0.0, 0.0, 0.0);
        this.angularVelocityInWorld.set(0.0, 0.0, 0.0);
    }

    public KinematicPointUpdater getKinematicPointUpdater() {
        return this.kinematicPointUpdater;
    }

    public void setKinematicPointUpdater(KinematicPointUpdater updater) {
        this.kinematicPointUpdater = updater;
    }

    public void setParentJoint(Joint parent) {
        this.parentJoint = parent;
    }

    public Joint getParentJoint() {
        return this.parentJoint;
    }

    public String toString() {
        return "name: " + this.name + " x: " + this.positionInWorld.getX() + ", y: " + this.positionInWorld.getY() + ", z: " + this.positionInWorld.getZ();
    }

    public void setOffsetJoint(double x, double y, double z) {
        this.offsetYoFrameVector.set(x, y, z);
    }

    public void setOffsetJoint(Tuple3DReadOnly newOffset) {
        this.offsetYoFrameVector.set(newOffset);
    }

    public void setOffsetWorld(Tuple3DReadOnly offsetInWorld) {
        this.setOffsetWorld(offsetInWorld.getX(), offsetInWorld.getY(), offsetInWorld.getZ());
    }

    public void setOffsetWorld(double x, double y, double z) {
        this.tempTransformFromWorldToJoint.set(this.parentJoint.transformToNext);
        this.tempTransformFromWorldToJoint.invert();
        this.offsetPlus.set(x, y, z, 1.0);
        this.tempTransformFromWorldToJoint.transform((Vector4DBasics)this.offsetPlus);
        this.setOffsetJoint(this.offsetPlus.getX(), this.offsetPlus.getY(), this.offsetPlus.getZ());
        this.positionInWorld.set(x, y, z);
    }

    public void updatePointVelocity(RotationMatrixReadOnly R0_i, Vector3DReadOnly comOffset, Vector3DReadOnly v_i, Vector3DReadOnly w_i) {
        this.getOffset((Tuple3DBasics)this.tempVectorForOffsetFromCOM);
        this.tempVectorForOffsetFromCOM.sub((Tuple3DReadOnly)comOffset);
        this.tempVectorForWXr.cross((Tuple3DReadOnly)w_i, (Tuple3DReadOnly)this.tempVectorForOffsetFromCOM);
        this.tempVectorForVelocity.add((Tuple3DReadOnly)v_i, (Tuple3DReadOnly)this.tempVectorForWXr);
        R0_i.transform((Tuple3DBasics)this.tempVectorForVelocity);
        this.velocityInWorld.set((Tuple3DReadOnly)this.tempVectorForVelocity);
        this.tempVectorForVelocity.set((Tuple3DReadOnly)w_i);
        R0_i.transform((Tuple3DBasics)this.tempVectorForVelocity);
        this.angularVelocityInWorld.set((Tuple3DReadOnly)this.tempVectorForVelocity);
    }

    protected void updatePointPosition(RigidBodyTransformReadOnly t1) {
        if (this.kinematicPointUpdater != null) {
            this.kinematicPointUpdater.updateKinematicPoint(this);
        }
        this.getOffset((Tuple3DBasics)this.tempPoint);
        t1.transform((Point3DBasics)this.tempPoint);
        this.positionInWorld.set((Tuple3DReadOnly)this.tempPoint);
    }

    public String getName() {
        return this.name;
    }

    public Vector3DReadOnly getOffset() {
        return this.offsetYoFrameVector;
    }

    public void getOffset(Tuple3DBasics offsetToPack) {
        offsetToPack.set((Tuple3DReadOnly)this.offsetYoFrameVector);
    }

    public Vector3D getOffsetCopy() {
        return new Vector3D((Tuple3DReadOnly)this.getOffset());
    }

    public double getX() {
        return this.positionInWorld.getX();
    }

    public double getY() {
        return this.positionInWorld.getY();
    }

    public double getZ() {
        return this.positionInWorld.getZ();
    }

    public double getXVelocity() {
        return this.velocityInWorld.getX();
    }

    public double getYVelocity() {
        return this.velocityInWorld.getY();
    }

    public double getZVelocity() {
        return this.velocityInWorld.getZ();
    }

    public void getPosition(Tuple3DBasics positionToPack) {
        positionToPack.set((Tuple3DReadOnly)this.positionInWorld);
    }

    public Point3D getPositionPoint() {
        return this.getPositionCopy();
    }

    public Point3D getPositionCopy() {
        return new Point3D((Tuple3DReadOnly)this.positionInWorld);
    }

    public void getVelocity(Vector3DBasics velocityToPack) {
        velocityToPack.set((Tuple3DReadOnly)this.velocityInWorld);
    }

    public Vector3D getVelocityVector() {
        return this.getVelocityCopy();
    }

    public Vector3D getVelocityCopy() {
        return new Vector3D((Tuple3DReadOnly)this.velocityInWorld);
    }

    public void setVelocity(Vector3DReadOnly velocity) {
        this.velocityInWorld.set((Tuple3DReadOnly)velocity);
    }

    public void getAngularVelocity(Vector3DBasics angularVelocityInWorldToPack) {
        angularVelocityInWorldToPack.set((Tuple3DReadOnly)this.angularVelocityInWorld);
    }

    public void setAngularVelocity(Vector3DReadOnly angularVelocityInWorld) {
        this.angularVelocityInWorld.set((Tuple3DReadOnly)angularVelocityInWorld);
    }

    public void setPosition(Point3DReadOnly position) {
        this.positionInWorld.set((Tuple3DReadOnly)position);
    }

    public YoFramePoint3D getYoPosition() {
        return this.positionInWorld;
    }

    public YoFrameVector3D getYoVelocity() {
        return this.velocityInWorld;
    }

    public YoFrameVector3D getYoAngularVelocity() {
        return this.angularVelocityInWorld;
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }
}

