/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class IMUMount {
    private final String name;
    private RigidBodyTransform transformFromMountToJoint;
    private Joint parentJoint;
    private Robot robot;
    private final YoFrameVector3D angularVelocityInBody;
    private final YoFrameVector3D angularAccelerationInBody;
    private final YoFrameVector3D linearVelocityInBody;
    private final YoFrameVector3D linearVelocityInWorld;
    private final YoFrameVector3D linearAccelerationInBody;
    private final YoFrameVector3D linearAccelerationInWorld;
    private final YoFrameQuaternion orientation;
    private double accelerationGaussianNoiseMean = 0.0;
    private double accelerationGaussianNoiseStdDev = 0.0;
    private double accelerationGaussianBiasMean = 0.0;
    private double accelerationGaussianBiasStdDev = 0.0;
    private double angularVelocityGaussianNoiseMean = 0.0;
    private double angularVelocityGaussianNoiseStdDev = 0.0;
    private double angularVelocityGaussianBiasMean = 0.0;
    private double angularVelocityGaussianBiasStdDev = 0.0;
    private final Vector3D tempLinearVelocity = new Vector3D();
    private final Vector3D tempAngularVelocityInBody = new Vector3D();
    private final RotationMatrix tempRotationToWorld = new RotationMatrix();
    private final Vector3D tempIMUOffset = new Vector3D();
    private final RotationMatrix tempIMURotation = new RotationMatrix();
    private final Vector3D tempGravity = new Vector3D();
    private final Vector3D tempLinearAcceleration = new Vector3D();
    private final Vector3D tempAngularAccelerationInBody = new Vector3D();

    public IMUMount(String name, RigidBodyTransform offset, Robot robot) {
        this.name = name;
        this.robot = robot;
        this.transformFromMountToJoint = new RigidBodyTransform((RigidBodyTransformReadOnly)offset);
        YoRegistry registry = robot.getRobotsYoRegistry();
        this.orientation = new YoFrameQuaternion(name + "Orientation", null, registry);
        this.linearVelocityInBody = new YoFrameVector3D(name + "LinearVelocity", null, registry);
        this.linearVelocityInWorld = new YoFrameVector3D(name + "LinearVelocityWorld", null, registry);
        this.angularVelocityInBody = new YoFrameVector3D(name + "AngularVelocity", null, registry);
        this.angularAccelerationInBody = new YoFrameVector3D(name + "AngularAcceleration", null, registry);
        this.linearAccelerationInBody = new YoFrameVector3D(name + "LinearAcceleration", null, registry);
        this.linearAccelerationInWorld = new YoFrameVector3D(name + "LinearAccelerationWorld", null, registry);
    }

    public String getName() {
        return this.name;
    }

    protected void setParentJoint(Joint parent) {
        this.parentJoint = parent;
    }

    public Joint getParentJoint() {
        return this.parentJoint;
    }

    protected void updateIMUMountPositionAndVelocity() {
        this.tempIMUOffset.set((Tuple3DReadOnly)this.transformFromMountToJoint.getTranslation());
        this.tempIMURotation.set((RotationMatrixReadOnly)this.transformFromMountToJoint.getRotation());
        this.parentJoint.getRotationToWorld((Orientation3DBasics)this.tempRotationToWorld);
        this.tempRotationToWorld.multiply((RotationMatrixReadOnly)this.tempIMURotation);
        this.orientation.set((Orientation3DReadOnly)this.tempRotationToWorld);
        this.tempIMURotation.transpose();
        this.parentJoint.physics.getLinearVelocityInBody((Vector3DBasics)this.tempLinearVelocity, (Vector3DBasics)this.tempIMUOffset);
        this.tempIMURotation.transform((Tuple3DBasics)this.tempLinearVelocity);
        this.linearVelocityInBody.set((Tuple3DReadOnly)this.tempLinearVelocity);
        this.parentJoint.physics.getLinearVelocityInWorld((Vector3DBasics)this.tempLinearVelocity, (Vector3DBasics)this.tempIMUOffset);
        this.linearVelocityInWorld.set((Tuple3DReadOnly)this.tempLinearVelocity);
        this.parentJoint.physics.getAngularVelocityInBody((Vector3DBasics)this.tempAngularVelocityInBody);
        this.tempIMURotation.transform((Tuple3DBasics)this.tempAngularVelocityInBody);
        this.angularVelocityInBody.set((Tuple3DReadOnly)this.tempAngularVelocityInBody);
    }

    protected void updateIMUMountAcceleration() {
        this.tempIMUOffset.set((Tuple3DReadOnly)this.transformFromMountToJoint.getTranslation());
        this.tempIMURotation.set((RotationMatrixReadOnly)this.transformFromMountToJoint.getRotation());
        this.parentJoint.getRotationToWorld((Orientation3DBasics)this.tempRotationToWorld);
        this.tempRotationToWorld.multiply((RotationMatrixReadOnly)this.tempIMURotation);
        this.tempIMURotation.transpose();
        this.parentJoint.physics.getLinearAccelerationInBody((Vector3DBasics)this.tempLinearAcceleration, (Vector3DBasics)this.tempIMUOffset);
        this.tempIMURotation.transform((Tuple3DBasics)this.tempLinearAcceleration);
        this.robot.getGravity(this.tempGravity);
        this.tempGravity.scale(-1.0);
        this.tempRotationToWorld.transpose();
        this.tempRotationToWorld.transform((Tuple3DBasics)this.tempGravity);
        this.tempLinearAcceleration.add((Tuple3DReadOnly)this.tempGravity);
        this.linearAccelerationInBody.set((Tuple3DReadOnly)this.tempLinearAcceleration);
        this.parentJoint.physics.getLinearAccelerationInWorld((Vector3DBasics)this.tempLinearAcceleration, (Vector3DBasics)this.tempIMUOffset);
        this.robot.getGravity(this.tempGravity);
        this.tempGravity.scale(-1.0);
        this.tempLinearAcceleration.add((Tuple3DReadOnly)this.tempGravity);
        this.linearAccelerationInWorld.set((Tuple3DReadOnly)this.tempLinearAcceleration);
        this.parentJoint.physics.getAngularAccelerationsInBodyFrame((Vector3DBasics)this.tempAngularAccelerationInBody);
        this.tempIMURotation.transform((Tuple3DBasics)this.tempAngularAccelerationInBody);
        this.angularAccelerationInBody.set((Tuple3DReadOnly)this.tempAngularAccelerationInBody);
    }

    public void setOrientation(Quaternion orientation) {
        this.orientation.set((QuaternionReadOnly)orientation);
    }

    public void getOrientation(Quaternion orientationToPack) {
        orientationToPack.set((QuaternionReadOnly)this.orientation);
    }

    public void getOrientation(RotationMatrix rotationMatrixToPack) {
        rotationMatrixToPack.set((Orientation3DReadOnly)this.orientation);
    }

    public void setAngularVelocityInBody(Vector3D angularVelocityInBody) {
        this.angularVelocityInBody.set((Tuple3DReadOnly)angularVelocityInBody);
    }

    public void getAngularVelocityInBody(Vector3D angularVelocityInBodyToPack) {
        angularVelocityInBodyToPack.set((Tuple3DReadOnly)this.angularVelocityInBody);
    }

    public void setAngularAccelerationInBody(Vector3D angularAccelerationInBody) {
        this.angularAccelerationInBody.set((Tuple3DReadOnly)angularAccelerationInBody);
    }

    public void getAngularAccelerationInBody(Vector3D angularAccelerationInBodyToPack) {
        angularAccelerationInBodyToPack.set((Tuple3DReadOnly)this.angularAccelerationInBody);
    }

    public void setLinearAccelerationInBody(Vector3D linearAccelerationInBody) {
        this.linearAccelerationInBody.set((Tuple3DReadOnly)linearAccelerationInBody);
    }

    public void getLinearAccelerationInBody(Vector3D linearAccelerationInBodyToPack) {
        linearAccelerationInBodyToPack.set((Tuple3DReadOnly)this.linearAccelerationInBody);
    }

    public void getTransformFromMountToJoint(RigidBodyTransform transformToPack) {
        transformToPack.set(this.transformFromMountToJoint);
    }

    public void setOffset(RigidBodyTransform newTransformFromMountToJoint) {
        this.transformFromMountToJoint.set(newTransformFromMountToJoint);
    }

    public void setAngularVelocityNoiseParameters(double angularVelocityGaussianNoiseMean, double angularVelocityGaussianNoiseStdDev) {
        this.angularVelocityGaussianNoiseMean = angularVelocityGaussianNoiseMean;
        this.angularVelocityGaussianNoiseStdDev = angularVelocityGaussianNoiseStdDev;
    }

    public void setAngularVelocityBiasParameters(double angularVelocityGaussianBiasMean, double angularVelocityGaussianBiasStdDev) {
        this.angularVelocityGaussianBiasMean = angularVelocityGaussianBiasMean;
        this.angularVelocityGaussianBiasStdDev = angularVelocityGaussianBiasStdDev;
    }

    public void setAccelerationNoiseParameters(double accelerationGaussianNoiseMean, double accelerationGaussianNoiseStdDev) {
        this.accelerationGaussianNoiseMean = accelerationGaussianNoiseMean;
        this.accelerationGaussianNoiseStdDev = accelerationGaussianNoiseStdDev;
    }

    public void setAccelerationBiasParameters(double accelerationGaussianBiasMean, double accelerationGaussianBiasStdDev) {
        this.accelerationGaussianBiasMean = accelerationGaussianBiasMean;
        this.accelerationGaussianBiasStdDev = accelerationGaussianBiasStdDev;
    }

    public double getAccelerationGaussianNoiseMean() {
        return this.accelerationGaussianNoiseMean;
    }

    public double getAccelerationGaussianNoiseStdDev() {
        return this.accelerationGaussianNoiseStdDev;
    }

    public double getAccelerationGaussianBiasMean() {
        return this.accelerationGaussianBiasMean;
    }

    public double getAccelerationGaussianBiasStdDev() {
        return this.accelerationGaussianBiasStdDev;
    }

    public double getAngularVelocityGaussianNoiseMean() {
        return this.angularVelocityGaussianNoiseMean;
    }

    public double getAngularVelocityGaussianNoiseStdDev() {
        return this.angularVelocityGaussianNoiseStdDev;
    }

    public double getAngularVelocityGaussianBiasMean() {
        return this.angularVelocityGaussianBiasMean;
    }

    public double getAngularVelocityGaussianBiasStdDev() {
        return this.angularVelocityGaussianBiasStdDev;
    }
}

