/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoInteger;

public class IndexOrderChecker {
    private final YoInteger previousIndex;
    private final YoInteger missedIndices;
    private final YoBoolean hasBeenUpdated;
    private int increment;

    public IndexOrderChecker(String name, YoRegistry registry, int increment) {
        this.previousIndex = new YoInteger(name + "PrevIndex", registry);
        this.missedIndices = new YoInteger(name + "MissedIndices", registry);
        this.hasBeenUpdated = new YoBoolean(name + "HasBeenUpdated", registry);
        this.increment = increment;
    }

    public void update(int newIndex) {
        if (this.hasBeenUpdated.getBooleanValue()) {
            int correctedNew = newIndex;
            int correctedPrevious = this.previousIndex.getIntegerValue();
            if (correctedPrevious > correctedNew) {
                correctedNew -= Integer.MIN_VALUE;
                correctedPrevious -= Integer.MIN_VALUE;
            }
            this.missedIndices.add(Math.abs(correctedNew - correctedPrevious - this.increment));
        } else {
            this.hasBeenUpdated.set(true);
        }
        this.previousIndex.set(newIndex);
    }

    public int getMissedIndices() {
        return this.missedIndices.getIntegerValue();
    }
}

