/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.simulationRunner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.simulationconstructionset.DataFileReader;
import us.ihmc.simulationconstructionset.util.simulationRunner.VariableDifference;
import us.ihmc.simulationconstructionset.util.simulationRunner.VariablesThatShouldMatchList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoDouble;

public class StateFileComparer {
    public static ArrayList<VariableDifference> absoluteCompareStateFiles(String filenameOne, String filenameTwo, double maxAbsoluteDiff, ArrayList<String> exceptions) {
        File fileOne = new File(filenameOne);
        File fileTwo = new File(filenameTwo);
        return StateFileComparer.absoluteCompareStateFiles(fileOne, fileTwo, maxAbsoluteDiff, exceptions);
    }

    public static ArrayList<VariableDifference> absoluteCompareStateFiles(File fileOne, File fileTwo, double maxAbsoluteDiff, ArrayList<String> exceptions) {
        return StateFileComparer.compareStateFiles(fileOne, fileTwo, maxAbsoluteDiff, false, exceptions);
    }

    public static ArrayList<VariableDifference> percentualCompareStateFiles(String filenameOne, String filenameTwo, double maxPercentDiff, ArrayList<String> exceptions) {
        File fileOne = new File(filenameOne);
        File fileTwo = new File(filenameTwo);
        return StateFileComparer.percentualCompareStateFiles(fileOne, fileTwo, maxPercentDiff, exceptions);
    }

    public static ArrayList<VariableDifference> percentualCompareStateFiles(File fileOne, File fileTwo, double maxPercentDiff, List<String> exceptions) {
        return StateFileComparer.compareStateFiles(fileOne, fileTwo, maxPercentDiff, true, exceptions);
    }

    private static ArrayList<VariableDifference> compareStateFiles(File fileOne, File fileTwo, double maxDifference, boolean checkForPercentDifference, List<String> exceptions) {
        DataFileReader dataFileReaderOne = new DataFileReader(fileOne);
        DataFileReader dataFileReaderTwo = new DataFileReader(fileTwo);
        YoVariableList varListOne = new YoVariableList("VarListOne");
        YoVariableList varListTwo = new YoVariableList("VarListTwo");
        YoRegistry registryOne = new YoRegistry("root");
        YoRegistry registryTwo = new YoRegistry("root");
        try {
            dataFileReaderOne.readState(varListOne, true, false, registryOne);
            dataFileReaderTwo.readState(varListTwo, true, false, registryTwo);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.flush();
            System.err.flush();
        }
        return StateFileComparer.compareVarLists(varListOne, varListTwo, maxDifference, checkForPercentDifference, exceptions);
    }

    public static ArrayList<VariableDifference> compareVarLists(YoVariableList varListOne, YoVariableList varListTwo, double maxDifferenceAllowed, boolean checkForPercentDifference, List<String> exceptions) {
        VariablesThatShouldMatchList list = new VariablesThatShouldMatchList(varListOne, varListTwo, exceptions);
        ArrayList<VariableDifference> variableDifferences = new ArrayList<VariableDifference>();
        YoDouble timeYoVariable = (YoDouble)varListOne.findVariable("t");
        double time = Double.NaN;
        if (timeYoVariable != null) {
            time = timeYoVariable.getDoubleValue();
        }
        list.doVariableValuesMatch(variableDifferences, time, maxDifferenceAllowed, checkForPercentDifference);
        return variableDifferences;
    }

    public static void main(String[] args) {
        String filenameOne = "Tests/test_2.270000.state";
        String filenameTwo = "Tests/test_2.270000_Rewind.state";
        double maxPercentDiff = 0.05;
        ArrayList<VariableDifference> variableDifferences = StateFileComparer.percentualCompareStateFiles(filenameOne, filenameTwo, maxPercentDiff, null);
        for (VariableDifference variableDifference : variableDifferences) {
            System.out.println(variableDifference);
        }
    }
}

