/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.FunctionToIntegrate;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ExternalForcePointPDConstraintToIntegrate
implements FunctionToIntegrate {
    private final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    protected final YoRegistry registry;
    private final YoDouble stiffness;
    private final YoDouble damping;
    protected final ExternalForcePoint connectionPointA;
    protected final ExternalForcePoint connectionPointB;
    private final YoFramePoint3D yoConnectionAPosition;
    private final YoFramePoint3D yoConnectionBPosition;
    protected final YoFrameVector3D yoConnectionPositionError;
    private final YoDouble yoConnectionPositionErrorMagnitude;
    private final YoFrameVector3D yoConnectionAVelocity;
    private final YoFrameVector3D yoConnectionBVelocity;
    private final YoFrameVector3D yoConnectionVelocityError;
    private final YoDouble yoConnectionVelocityErrorMagnitude;
    private final FramePoint3D connectionAPosition = new FramePoint3D(this.worldFrame);
    private final FramePoint3D connectionBPosition = new FramePoint3D(this.worldFrame);
    private final FrameVector3D connectionPositionError;
    private final FrameVector3D connectionAVelocity = new FrameVector3D(this.worldFrame);
    private final FrameVector3D connectionBVelocity = new FrameVector3D(this.worldFrame);
    private final FrameVector3D connectionVelocityError;
    private final FrameVector3D springForce;
    private final FrameVector3D damperForce;
    private final FrameVector3D totalForce = new FrameVector3D(this.worldFrame);

    public ExternalForcePointPDConstraintToIntegrate(String name, ExternalForcePoint connectionPointA, ExternalForcePoint connectionPointB, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(name);
        this.stiffness = new YoDouble(name + "_Stiffness", this.registry);
        this.damping = new YoDouble(name + "_Damping", this.registry);
        this.connectionPointA = connectionPointA;
        this.connectionPointB = connectionPointB;
        this.yoConnectionAPosition = connectionPointA.getYoPosition();
        this.yoConnectionBPosition = connectionPointB.getYoPosition();
        this.yoConnectionPositionError = new YoFrameVector3D(name + "_ConnectionPositionError", this.worldFrame, this.registry);
        this.yoConnectionPositionErrorMagnitude = new YoDouble(name + "_ConnectionPositionErrorMagnitude", this.registry);
        this.yoConnectionAVelocity = connectionPointA.getYoVelocity();
        this.yoConnectionBVelocity = connectionPointB.getYoVelocity();
        this.yoConnectionVelocityError = new YoFrameVector3D(name + "_ConnectionVelocityError", this.worldFrame, this.registry);
        this.yoConnectionVelocityErrorMagnitude = new YoDouble(name + "_ConnectionVelocityErrorMagnitude", this.registry);
        parentRegistry.addChild(this.registry);
        this.connectionPositionError = new FrameVector3D(this.worldFrame);
        this.connectionVelocityError = new FrameVector3D(this.worldFrame);
        this.springForce = new FrameVector3D(this.worldFrame);
        this.damperForce = new FrameVector3D(this.worldFrame);
    }

    public void setStiffness(double stiffness) {
        this.stiffness.set(stiffness);
    }

    public void setDamping(double damping) {
        this.damping.set(damping);
    }

    protected void updateClosedJoint() {
        this.updateFrameAndKinematics();
        this.computeErrors();
        this.totalForce.setToZero(this.worldFrame);
        this.springForce.setAndScale(this.stiffness.getDoubleValue(), (FrameTuple3DReadOnly)this.connectionPositionError);
        this.damperForce.setAndScale(this.damping.getDoubleValue(), (FrameTuple3DReadOnly)this.connectionVelocityError);
        this.totalForce.add((FrameTuple3DReadOnly)this.springForce);
        this.totalForce.add((FrameTuple3DReadOnly)this.damperForce);
        this.connectionPointA.setForce((Vector3DReadOnly)this.totalForce);
        this.totalForce.scale(-1.0);
        this.connectionPointB.setForce((Vector3DReadOnly)this.totalForce);
    }

    private void updateFrameAndKinematics() {
        this.connectionAPosition.setIncludingFrame((FrameTuple3DReadOnly)this.yoConnectionAPosition);
        this.connectionBPosition.setIncludingFrame((FrameTuple3DReadOnly)this.yoConnectionBPosition);
        this.connectionAVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.yoConnectionAVelocity);
        this.connectionBVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.yoConnectionBVelocity);
    }

    private void computeErrors() {
        this.connectionPositionError.sub((FrameTuple3DReadOnly)this.connectionBPosition, (FrameTuple3DReadOnly)this.connectionAPosition);
        this.yoConnectionPositionError.set((FrameTuple3DReadOnly)this.connectionPositionError);
        this.yoConnectionPositionErrorMagnitude.set(this.connectionPositionError.length());
        this.connectionVelocityError.sub((FrameTuple3DReadOnly)this.connectionBVelocity, (FrameTuple3DReadOnly)this.connectionAVelocity);
        this.yoConnectionVelocityError.set((FrameTuple3DReadOnly)this.connectionVelocityError);
        this.yoConnectionVelocityErrorMagnitude.set(this.connectionVelocityError.length());
    }

    @Override
    public double[] computeDerivativeVector() {
        this.updateClosedJoint();
        return null;
    }

    @Override
    public int getVectorSize() {
        return 0;
    }

    @Override
    public YoDouble[] getOutputVariables() {
        return null;
    }
}

