/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.simulationRunner;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.util.ControllerFailureException;
import us.ihmc.simulationconstructionset.util.simulationRunner.StateFileComparer;
import us.ihmc.simulationconstructionset.util.simulationRunner.VariableDifference;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class BlockingSimulationRunner {
    private static final long CLOSING_SLEEP_TIME = 1000L;
    private final SimulationConstructionSet scs;
    private final double maximumClockRunTimeInSeconds;
    private final boolean destroySimulationIfOverrunMaxTime;
    private final AtomicBoolean hasControllerFailed = new AtomicBoolean(false);
    private final AtomicBoolean hasICPBeenInvalid = new AtomicBoolean(false);
    private boolean checkICPPosition = false;

    public BlockingSimulationRunner(SimulationConstructionSet scs, double maximumClockRunTimeInSeconds) {
        this(scs, maximumClockRunTimeInSeconds, true);
    }

    public BlockingSimulationRunner(SimulationConstructionSet scs, double maximumClockRunTimeInSeconds, boolean destroySimulationaIfOverrunMaxTime) {
        this.scs = scs;
        this.maximumClockRunTimeInSeconds = maximumClockRunTimeInSeconds;
        this.destroySimulationIfOverrunMaxTime = destroySimulationaIfOverrunMaxTime;
    }

    public void setCheckDesiredICPPosition(boolean checkICPPosition) {
        this.checkICPPosition = checkICPPosition;
    }

    public void simulateNTicksAndBlock(int numberOfTicks) throws SimulationExceededMaximumTimeException, ControllerFailureException {
        this.scs.simulate(numberOfTicks);
        BlockingSimulationRunner.waitForSimulationToFinish(this.scs, this.maximumClockRunTimeInSeconds, this.destroySimulationIfOverrunMaxTime);
        this.checkIfControllerHasFailed();
        if (this.checkICPPosition) {
            this.checkIfICPHasBeenInvalid();
        }
    }

    public boolean simulateNTicksAndBlockAndCatchExceptions(int numberOfTicks) throws SimulationExceededMaximumTimeException {
        try {
            this.simulateNTicksAndBlock(numberOfTicks);
            return true;
        }
        catch (Exception e) {
            LogTools.error((String)e.getMessage());
            return false;
        }
    }

    public void simulateAndBlock(double simulateTime) throws SimulationExceededMaximumTimeException, ControllerFailureException {
        double endTime;
        double elapsedTime;
        double startTime = this.scs.getTime();
        this.scs.simulate(simulateTime);
        BlockingSimulationRunner.waitForSimulationToFinish(this.scs, this.maximumClockRunTimeInSeconds, this.destroySimulationIfOverrunMaxTime);
        this.checkIfControllerHasFailed();
        if (this.checkICPPosition) {
            this.checkIfICPHasBeenInvalid();
        }
        if (Math.abs((elapsedTime = (endTime = this.scs.getTime()) - startTime) - simulateTime) > 0.01) {
            throw new SimulationExceededMaximumTimeException("Elapsed time didn't equal requested. Sim probably crashed");
        }
    }

    public boolean simulateAndBlockAndCatchExceptions(double simulationTime) throws SimulationExceededMaximumTimeException {
        try {
            this.simulateAndBlock(simulationTime);
            return true;
        }
        catch (Exception e) {
            LogTools.error((String)e.getMessage());
            return false;
        }
    }

    public boolean doOneShotRewindTest(double t0, double t1, double t2) throws SimulationExceededMaximumTimeException, ControllerFailureException {
        boolean passed = true;
        BlockingSimulationRunner.sleep(1000L);
        this.simulateAndBlock(t0);
        BlockingSimulationRunner.sleep(1000L);
        this.scs.setInPoint();
        BlockingSimulationRunner.sleep(1000L);
        this.simulateAndBlock(t1 - t0);
        BlockingSimulationRunner.sleep(1000L);
        String filenameOne = "Tests/test_" + BlockingSimulationRunner.getTimeString(this.scs.getTime()) + ".state";
        this.scs.writeState(filenameOne);
        BlockingSimulationRunner.sleep(1000L);
        this.simulateAndBlock(t2 - t1);
        BlockingSimulationRunner.sleep(1000L);
        this.scs.gotoInPointNow();
        BlockingSimulationRunner.sleep(1000L);
        this.simulateAndBlock(t1 - t0);
        BlockingSimulationRunner.sleep(1000L);
        String filenameTwo = "Tests/test_" + BlockingSimulationRunner.getTimeString(this.scs.getTime()) + "_Rewind.state";
        this.scs.writeState(filenameTwo);
        BlockingSimulationRunner.sleep(1000L);
        double maxPercentDiff = 0.001;
        ArrayList<VariableDifference> changedVariables = StateFileComparer.percentualCompareStateFiles(filenameOne, filenameTwo, maxPercentDiff, null);
        if (changedVariables.size() > 0) {
            System.err.println("Difference between " + filenameOne + " and " + filenameTwo);
            passed = false;
        }
        return passed;
    }

    private static void sleep(long sleepTimeMillis) {
        try {
            Thread.sleep(sleepTimeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String getTimeString(double time) {
        String ret = Double.toString(time);
        ret = ret.substring(0, Math.min(8, ret.length() - 1));
        return ret;
    }

    public void destroySimulation() {
        BlockingSimulationRunner.destroySimulation(this.scs);
    }

    private static void destroySimulation(SimulationConstructionSet scs) {
        ThreadTools.sleep((long)1000L);
        scs.closeAndDispose();
        scs = null;
    }

    public static void waitForSimulationToFinish(SimulationConstructionSet scs, double maximumClockRunTimeInSeconds, boolean destroySimulationaIfOverrunMaxTime) throws SimulationExceededMaximumTimeException {
        long startTime = System.currentTimeMillis();
        while (scs.isSimulating()) {
            BlockingSimulationRunner.sleep(100L);
            long currentTime = System.currentTimeMillis();
            double elapsedTime = (double)(currentTime - startTime) * 0.001;
            if (!(elapsedTime > maximumClockRunTimeInSeconds)) continue;
            scs.stop();
            if (destroySimulationaIfOverrunMaxTime) {
                BlockingSimulationRunner.destroySimulation(scs);
            }
            throw new SimulationExceededMaximumTimeException("Simulation Exceeded maximumClockRunTimeInSeconds");
        }
    }

    private void checkIfControllerHasFailed() throws ControllerFailureException {
        if (this.hasControllerFailed.get()) {
            throw new ControllerFailureException("Controller failure has been detected.");
        }
    }

    private void checkIfICPHasBeenInvalid() throws ControllerFailureException {
        if (this.hasICPBeenInvalid.get()) {
            throw new ControllerFailureException("The desired ICP position has been invalid.");
        }
    }

    public void notifyControllerHasFailed() {
        this.hasControllerFailed.set(true);
        this.scs.stop();
    }

    public void createValidDesiredICPListener() {
        YoDouble desiredICPX = (YoDouble)this.scs.findVariable("desiredICPX");
        YoDouble desiredICPY = (YoDouble)this.scs.findVariable("desiredICPY");
        desiredICPX.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (!Double.isFinite(v.getValueAsDouble())) {
                    BlockingSimulationRunner.this.hasICPBeenInvalid.set(true);
                }
            }
        });
        desiredICPY.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                if (!Double.isFinite(v.getValueAsDouble())) {
                    BlockingSimulationRunner.this.hasICPBeenInvalid.set(true);
                }
            }
        });
    }

    public static class SimulationExceededMaximumTimeException
    extends Exception {
        private static final long serialVersionUID = 9041559998947724357L;

        public SimulationExceededMaximumTimeException(String description) {
            super(description);
        }
    }
}

