/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.dataBuffer;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class MirroredYoVariableRegistry
extends YoRegistry {
    private final ConcurrentLinkedQueue<Runnable> mirrorPendingActions = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> originalPendingActions = new ConcurrentLinkedQueue();

    public MirroredYoVariableRegistry(YoRegistry original) {
        super(original.getName());
        this.copyRegistry(original, this);
    }

    private void copyRegistry(YoRegistry original, YoRegistry mirror) {
        List originalVariables = original.getVariables();
        for (YoVariable originalVariable : originalVariables) {
            YoVariable mirrorVariable = originalVariable.duplicate(mirror);
            MirroredYoVariableRegistry.bindVariables(originalVariable, mirrorVariable, this.originalPendingActions, this.mirrorPendingActions);
        }
        for (YoRegistry childMirror : original.getChildren()) {
            YoRegistry newRegistry = new YoRegistry(childMirror.getName());
            mirror.addChild(newRegistry);
            this.copyRegistry(childMirror, newRegistry);
        }
    }

    public void updateMirror() {
        this.updateChangedValues();
        this.updateValuesFromOriginal();
    }

    public void updateChangedValues() {
        while (!this.mirrorPendingActions.isEmpty()) {
            this.mirrorPendingActions.poll().run();
        }
    }

    public void updateValuesFromOriginal() {
        while (!this.originalPendingActions.isEmpty()) {
            this.originalPendingActions.poll().run();
        }
    }

    private static void bindVariables(YoVariable variableA, YoVariable variableB, ConcurrentLinkedQueue<Runnable> actionQueueA, ConcurrentLinkedQueue<Runnable> actionQueueB) {
        MutableBoolean updating = new MutableBoolean(false);
        Runnable actionA = () -> {
            if (updating.isTrue()) {
                return;
            }
            updating.setTrue();
            try {
                variableB.setValue(variableA, true);
            }
            finally {
                updating.setFalse();
            }
        };
        Runnable actionB = () -> {
            if (updating.isTrue()) {
                return;
            }
            updating.setTrue();
            try {
                variableA.setValue(variableB, true);
            }
            finally {
                updating.setFalse();
            }
        };
        variableA.addListener(v -> actionQueueA.add(actionA));
        variableB.addListener(v -> actionQueueB.add(actionB));
    }
}

