/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.scripts;

import java.util.ArrayList;
import us.ihmc.simulationconstructionset.scripts.TimeScriptCommand;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class TimeScriptEntry
implements Comparable<Object> {
    private double time;
    private ArrayList<VariableValuePair> varValuePairs;
    private ArrayList<TimeScriptCommand> timeScriptCommands;

    public TimeScriptEntry(double time) {
        this.time = time;
        this.varValuePairs = new ArrayList();
        this.timeScriptCommands = new ArrayList();
    }

    public void addVarValue(YoDouble variable, double value) {
        if (variable == null) {
            return;
        }
        DoubleVariableValuePair variableValuePair = new DoubleVariableValuePair(variable, value);
        this.varValuePairs.add(variableValuePair);
    }

    public void addVarValue(YoBoolean variable, boolean value) {
        if (variable == null) {
            return;
        }
        BooleanVariableValuePair variableValuePair = new BooleanVariableValuePair(variable, value);
        this.varValuePairs.add(variableValuePair);
    }

    public void addVarValue(YoInteger variable, int value) {
        if (variable == null) {
            return;
        }
        IntegerVariableValuePair variableValuePair = new IntegerVariableValuePair(variable, value);
        this.varValuePairs.add(variableValuePair);
    }

    public void addVarValue(YoEnum variable, Enum value) {
        if (variable == null) {
            return;
        }
        EnumVariableValuePair variableValuePair = new EnumVariableValuePair(variable, value);
        this.varValuePairs.add(variableValuePair);
    }

    @Override
    public int compareTo(Object timeScriptEntry) {
        if (timeScriptEntry == this) {
            return 0;
        }
        if (((TimeScriptEntry)timeScriptEntry).time < this.time) {
            return 1;
        }
        return -1;
    }

    public void setVarsToValues() {
        for (int i = 0; i < this.varValuePairs.size(); ++i) {
            VariableValuePair variableValuePair = this.varValuePairs.get(i);
            variableValuePair.setVariableToValue();
        }
    }

    public void doCommands() {
        for (int i = 0; i < this.timeScriptCommands.size(); ++i) {
            TimeScriptCommand timeScriptCommand = this.timeScriptCommands.get(i);
            timeScriptCommand.doCommand();
        }
    }

    public void addTimeScriptCommand(TimeScriptCommand timeScriptCommand) {
        this.timeScriptCommands.add(timeScriptCommand);
    }

    public double getTime() {
        return this.time;
    }

    private class DoubleVariableValuePair
    implements VariableValuePair {
        protected YoDouble variable;
        protected double value;

        public DoubleVariableValuePair(YoDouble variable, double value) {
            this.variable = variable;
            this.value = value;
        }

        @Override
        public void setVariableToValue() {
            this.variable.set(this.value);
        }
    }

    private class BooleanVariableValuePair
    implements VariableValuePair {
        protected YoBoolean variable;
        protected boolean value;

        public BooleanVariableValuePair(YoBoolean variable, boolean value) {
            this.variable = variable;
            this.value = value;
        }

        @Override
        public void setVariableToValue() {
            this.variable.set(this.value);
        }
    }

    private class IntegerVariableValuePair
    implements VariableValuePair {
        protected YoInteger variable;
        protected int value;

        public IntegerVariableValuePair(YoInteger variable, int value) {
            this.variable = variable;
            this.value = value;
        }

        @Override
        public void setVariableToValue() {
            this.variable.set(this.value);
        }
    }

    private class EnumVariableValuePair
    implements VariableValuePair {
        protected YoEnum variable;
        protected Enum value;

        public EnumVariableValuePair(YoEnum variable, Enum value) {
            this.variable = variable;
            this.value = value;
        }

        @Override
        public void setVariableToValue() {
            this.variable.set(this.value);
        }
    }

    private static interface VariableValuePair {
        public void setVariableToValue();
    }
}

