/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;

public class ConeTerrainObject
implements TerrainObject3D,
HeightMapWithNormals {
    private final double xMin;
    private final double xMax;
    private final double yMin;
    private final double yMax;
    private final double xMiddle;
    private final double yMiddle;
    private final double bottomRadius;
    private final double topRadius;
    private final double height;
    private final BoundingBox3D boundingBox;
    private Graphics3DObject linkGraphics;

    public ConeTerrainObject(double xMiddle, double yMiddle, double bottomRadius, double topRadius, double height, AppearanceDefinition appearance) {
        this.xMiddle = xMiddle;
        this.yMiddle = yMiddle;
        this.bottomRadius = bottomRadius;
        this.topRadius = topRadius;
        this.height = height;
        this.xMin = xMiddle - bottomRadius;
        this.xMax = xMiddle + bottomRadius;
        this.yMin = yMiddle - bottomRadius;
        this.yMax = yMiddle + bottomRadius;
        this.linkGraphics = new Graphics3DObject();
        this.linkGraphics.translate(xMiddle, yMiddle, 0.0);
        this.linkGraphics.addGenTruncatedCone(height, bottomRadius, bottomRadius, topRadius, topRadius, appearance);
        Point3D minPoint = new Point3D(this.xMin, this.yMin, Double.NEGATIVE_INFINITY);
        Point3D maxPoint = new Point3D(this.xMax, this.yMax, height);
        this.boundingBox = new BoundingBox3D((Point3DReadOnly)minPoint, (Point3DReadOnly)maxPoint);
    }

    public ConeTerrainObject(double xMiddle, double yMiddle, double bottomRadius, double topRadius, double height) {
        this(xMiddle, yMiddle, bottomRadius, topRadius, height, YoAppearance.Red());
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.linkGraphics;
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double heightAt = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return heightAt;
    }

    public double heightAt(double x, double y, double z) {
        double r_from_center = Math.sqrt((x - this.xMiddle) * (x - this.xMiddle) + (y - this.yMiddle) * (y - this.yMiddle));
        if (r_from_center > this.bottomRadius) {
            return 0.0;
        }
        if (r_from_center < this.topRadius) {
            return this.height;
        }
        return 1.0 - (r_from_center - this.topRadius) / (this.bottomRadius - this.topRadius) * this.height;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        normal.setX(0.0);
        normal.setY(0.0);
        normal.setZ(1.0);
    }

    public void closestIntersectionTo(double x, double y, double z, Point3D intersection) {
        intersection.setX(x);
        intersection.setY(y);
        intersection.setZ(this.heightAt(x, y, z));
    }

    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3DBasics intersection, Vector3DBasics normal) {
        intersection.setX(x);
        intersection.setY(y);
        intersection.setZ(this.heightAt(x, y, z));
        this.surfaceNormalAt(x, y, z, normal);
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        intersectionToPack.setX(x);
        intersectionToPack.setY(y);
        intersectionToPack.setZ(this.heightAt(x, y, z));
        this.surfaceNormalAt(x, y, z, normalToPack);
        return z < intersectionToPack.getZ();
    }

    public boolean isClose(double x, double y, double z) {
        if (x < this.xMin || x > this.xMax || y < this.yMin || y > this.yMax) {
            return false;
        }
        return !(z > this.height);
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMax() {
        return this.yMax;
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this;
    }
}

