/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;

public class RepeatingHeightMap
implements HeightMapWithNormals {
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private double xDistance;
    private double yDistance;
    private final HeightMapWithNormals heightMap;
    private final BoundingBox3D boundingBox;

    public RepeatingHeightMap(HeightMapWithNormals heightMap, double xMin, double xMax, double yMin, double yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.xDistance = this.xMax - this.xMin;
        this.yDistance = this.yMax - this.yMin;
        this.heightMap = heightMap;
        double zMin = heightMap.getBoundingBox().getMinZ();
        double zMax = heightMap.getBoundingBox().getMaxZ();
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    private double xLocal(double xGlobal) {
        return Math.abs(xGlobal - this.xMin) % this.xDistance + this.xMin;
    }

    private double yLocal(double yGlobal) {
        return Math.abs(yGlobal - this.yMin) % this.yDistance + this.yMin;
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double localX = this.xLocal(x);
        double localY = this.yLocal(y);
        return this.heightMap.heightAndNormalAt(localX, localY, z, normalToPack);
    }

    public double heightAt(double x, double y, double z) {
        return this.heightMap.heightAt(this.xLocal(x), this.yLocal(y), z);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

