/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;

public class SimpleTableTerrainObject
implements TerrainObject3D,
HeightMapWithNormals {
    public static final double DEFAULT_TABLE_LENGTH = 2.0;
    private double TABLE_LENGTH;
    private double TABLE_THICKNESS;
    private double TABLE_WIDTH;
    private final BoundingBox3D boundingBox;
    private Graphics3DObject linkGraphics;

    public SimpleTableTerrainObject(double xStart, double yStart, double xEnd, double yEnd, double zStart, double zEnd) {
        this.TABLE_LENGTH = Math.abs(xStart - xEnd);
        this.TABLE_WIDTH = Math.abs(yStart - yEnd);
        this.TABLE_THICKNESS = Math.abs(zStart - zEnd);
        double xMin = Math.min(xStart, xEnd);
        double xMax = Math.max(xStart, xEnd);
        double yMin = Math.min(yStart, yEnd);
        double yMax = Math.max(yStart, yEnd);
        double zMin = Math.min(zStart, zEnd);
        double zMax = Math.max(zStart, zEnd);
        Point3D minPoint = new Point3D(xMin, yMin, zMin);
        Point3D maxPoint = new Point3D(xMax, yMax, zMax);
        this.boundingBox = new BoundingBox3D((Point3DReadOnly)minPoint, (Point3DReadOnly)maxPoint);
        this.linkGraphics = new Graphics3DObject();
        this.linkGraphics.translate((xStart + xEnd) / 2.0, (yStart + yEnd) / 2.0, zMin + this.TABLE_THICKNESS / 2.0);
        this.linkGraphics.scale((Vector3DReadOnly)new Vector3D(this.TABLE_LENGTH, this.TABLE_WIDTH, this.TABLE_THICKNESS));
        this.linkGraphics.addModelFile("models/plasticTableTop.obj");
        if (this.TABLE_LENGTH < this.TABLE_WIDTH) {
            this.linkGraphics.rotate(1.5707963267948966, Axis3D.Z);
        }
        this.linkGraphics.scale((Vector3DReadOnly)new Vector3D(1.0, 1.0, this.boundingBox.getMaxZ() / this.TABLE_THICKNESS));
        this.linkGraphics.addModelFile("models/FoldingTableLegs.obj");
    }

    public double getWidth() {
        return this.TABLE_WIDTH;
    }

    public double getThickness() {
        return this.TABLE_THICKNESS;
    }

    public double getLength() {
        return this.TABLE_LENGTH;
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double heightAt = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, heightAt, normalToPack);
        return heightAt;
    }

    public double heightAt(double x, double y, double z) {
        if (x > this.boundingBox.getMinX() && x < this.boundingBox.getMaxX() && y > this.boundingBox.getMinY() && y < this.boundingBox.getMaxY()) {
            return this.boundingBox.getMaxZ();
        }
        return 0.0;
    }

    public boolean isClose(double x, double y, double z) {
        if (z > this.boundingBox.getMaxZ() - this.TABLE_THICKNESS && z < this.boundingBox.getMaxZ()) {
            return this.boundingBox.isInsideInclusive(x, y, z);
        }
        return false;
    }

    public void closestIntersectionTo(double x, double y, double z, Point3D intersection) {
        intersection.setX(x);
        intersection.setY(y);
        intersection.setZ(this.heightAt(x, y, z));
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        double threshhold = 0.015;
        normal.setX(0.0);
        normal.setY(0.0);
        normal.setZ(1.0);
        if (!this.boundingBox.isXYInsideInclusive(x, y) || z > this.boundingBox.getMaxZ() - threshhold) {
            return;
        }
        if (Math.abs(x - this.boundingBox.getMinX()) < threshhold) {
            normal.setX(-1.0);
            normal.setY(0.0);
            normal.setZ(0.0);
        } else if (Math.abs(x - this.boundingBox.getMaxX()) < threshhold) {
            normal.setX(1.0);
            normal.setY(0.0);
            normal.setZ(0.0);
        } else if (Math.abs(y - this.boundingBox.getMinY()) < threshhold) {
            normal.setX(0.0);
            normal.setY(-1.0);
            normal.setZ(0.0);
        } else if (Math.abs(y - this.boundingBox.getMaxY()) < threshhold) {
            normal.setX(0.0);
            normal.setY(1.0);
            normal.setZ(0.0);
        }
    }

    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3DBasics intersection, Vector3DBasics normal) {
        intersection.setX(x);
        intersection.setY(y);
        intersection.setZ(this.heightAt(x, y, z));
        this.surfaceNormalAt(x, y, z, normal);
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        intersectionToPack.setX(x);
        intersectionToPack.setY(y);
        intersectionToPack.setZ(this.heightAt(x, y, z));
        this.surfaceNormalAt(x, y, z, normalToPack);
        return z < intersectionToPack.getZ();
    }

    public double getXMin() {
        return this.boundingBox.getMinX();
    }

    public double getXMax() {
        return this.boundingBox.getMaxX();
    }

    public double getYMin() {
        return this.boundingBox.getMinY();
    }

    public double getYMax() {
        return this.boundingBox.getMaxY();
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.linkGraphics;
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this;
    }
}

