/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.videos;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import us.ihmc.codecs.builder.H264Settings;
import us.ihmc.codecs.builder.MP4H264MovieBuilder;
import us.ihmc.codecs.generated.EProfileIdc;
import us.ihmc.codecs.generated.EUsageType;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.CaptureDevice;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;
import us.ihmc.log.LogTools;
import us.ihmc.simulationconstructionset.GotoInPointCommandExecutor;
import us.ihmc.simulationconstructionset.GotoOutPointCommandExecutor;
import us.ihmc.simulationconstructionset.TimeHolder;
import us.ihmc.simulationconstructionset.commands.ExportVideoCommandExecutor;
import us.ihmc.simulationconstructionset.commands.RunCommandsExecutor;
import us.ihmc.simulationconstructionset.gui.ActiveCanvas3DHolder;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.GUIEnablerAndDisabler;
import us.ihmc.simulationconstructionset.synchronization.SimulationSynchronizer;
import us.ihmc.simulationconstructionset.util.XMLReaderUtility;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferReader;

public class ExportVideo
implements ExportVideoCommandExecutor {
    private static final boolean DEBUG = false;
    private final TimeHolder timeHolder;
    private final StandardSimulationGUI standardSimulationGUI;
    private final SimulationSynchronizer simulationSynchronizer;
    private final YoBufferReader dataBufferCommandsExecutor;
    private final GUIEnablerAndDisabler guiEnablerAndDisabler;
    private final RunCommandsExecutor runCommandsExecutor;
    private final GotoInPointCommandExecutor gotoInPointCommandExecutor;
    private final GotoOutPointCommandExecutor gotoOutPointCommandExecutor;

    public ExportVideo(TimeHolder timeHolder, StandardSimulationGUI standardSimulationGUI, YoBufferReader dataBufferCommandsExecutor, GotoInPointCommandExecutor gotoInPointCommandExecutor, GotoOutPointCommandExecutor gotoOutPointCommandExecutor, RunCommandsExecutor runCommandsExecutor, GUIEnablerAndDisabler guiEnablerAndDisabler, ActiveCanvas3DHolder activeCanvas3DHolder, SimulationSynchronizer simulationSynchronizer) {
        this.timeHolder = timeHolder;
        this.gotoInPointCommandExecutor = gotoInPointCommandExecutor;
        this.gotoOutPointCommandExecutor = gotoOutPointCommandExecutor;
        this.simulationSynchronizer = simulationSynchronizer;
        this.standardSimulationGUI = standardSimulationGUI;
        this.dataBufferCommandsExecutor = dataBufferCommandsExecutor;
        this.runCommandsExecutor = runCommandsExecutor;
        this.guiEnablerAndDisabler = guiEnablerAndDisabler;
    }

    @Override
    public void createVideo(File selectedFile) {
        Dimension dimension = new Dimension(1280, 720);
        Boolean isSequanceSelected = false;
        double playBackRate = 1.0;
        double frameRate = 30.0;
        CameraController cameraController = this.standardSimulationGUI.getActiveView().getCameraController();
        this.createVideo(cameraController, selectedFile, dimension, isSequanceSelected, playBackRate, frameRate);
    }

    @Override
    public void createVideo(CameraController cameraController, File selectedFile, Dimension dimension, Boolean isSequanceSelected, double playBackRate, double frameRate) {
        Graphics3DAdapter graphics3dAdapter = this.standardSimulationGUI.getGraphics3dAdapter();
        ViewportAdapter adapter = graphics3dAdapter.createNewViewport(null, false, true);
        adapter.setupOffscreenView((int)dimension.getWidth(), (int)dimension.getHeight());
        adapter.setCameraController(cameraController);
        CaptureDevice captureDevice = adapter.getCaptureDevice();
        this.createVideo(captureDevice, selectedFile, false, playBackRate, frameRate);
        graphics3dAdapter.closeViewport(adapter);
    }

    @Override
    public void createVideo(CaptureDevice captureDevice, File selected, Boolean isSequenceSelected, double playBackRate, double frameRate) {
        this.printIfDebug("Creating Video. File = " + selected);
        int currentTick = 1;
        File selectedFile = selected;
        double realTimePlaybackRate = this.runCommandsExecutor.getPlaybackRealTimeRate();
        this.guiEnablerAndDisabler.disableGUIComponents();
        this.runCommandsExecutor.setPlaybackRealTimeRate(1.0);
        String fileName = selectedFile.getName();
        if (!fileName.contains(".")) {
            fileName = fileName.concat(".mov");
            if (!selectedFile.getName().equals(fileName)) {
                File newChosenFile;
                selectedFile = newChosenFile = new File(selectedFile.getParent(), fileName);
            }
        }
        this.runCommandsExecutor.stop();
        this.gotoOutPointCommandExecutor.gotoOutPoint();
        this.gotoInPointCommandExecutor.gotoInPoint();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        currentTick = this.dataBufferCommandsExecutor.getInPoint();
        String fileNameNoExtension = fileName.substring(0, XMLReaderUtility.getEndIndexOfSubString((int)0, (String)fileName, (String)".") - 1);
        this.dataBufferCommandsExecutor.setCurrentIndex(currentTick);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Graphics3DAdapter graphics3dAdapter = this.standardSimulationGUI.getGraphics3dAdapter();
        graphics3dAdapter.play();
        if (isSequenceSelected.booleanValue()) {
            this.saveSimulationAsSequenceOfImages(selectedFile.getParent(), fileNameNoExtension, captureDevice);
            this.guiEnablerAndDisabler.enableGUIComponents();
            System.out.println("Finished making saving sequence of Images.");
            return;
        }
        this.videoPlaybackAsBufferedImage(selectedFile.getAbsolutePath(), captureDevice, playBackRate, frameRate);
        graphics3dAdapter.pause();
        this.runCommandsExecutor.setPlaybackRealTimeRate(realTimePlaybackRate);
        this.guiEnablerAndDisabler.enableGUIComponents();
    }

    private void printIfDebug(String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void videoPlaybackAsBufferedImage(String file, CaptureDevice captureDevice, double playBackRate, double frameRate) {
        this.standardSimulationGUI.updateGraphs();
        try {
            Thread.sleep(125L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.gotoInPointCommandExecutor.gotoInPoint();
        double recordDT = this.timeHolder.getTime();
        this.dataBufferCommandsExecutor.tickAndReadFromBuffer(1);
        recordDT = this.timeHolder.getTime() - recordDT;
        this.gotoInPointCommandExecutor.gotoInPoint();
        double lastFrameTime = this.timeHolder.getTime();
        double videoDT = playBackRate / frameRate;
        BufferedImage bufferedImage = captureDevice.exportSnapshotAsBufferedImage();
        MP4H264MovieBuilder movieBuilder = null;
        try {
            H264Settings settings = new H264Settings();
            settings.setBitrate(bufferedImage.getWidth() * bufferedImage.getHeight() / 100);
            settings.setUsageType(EUsageType.CAMERA_VIDEO_REAL_TIME);
            settings.setProfileIdc(EProfileIdc.PRO_HIGH);
            movieBuilder = new MP4H264MovieBuilder(new File(file), bufferedImage.getWidth(), bufferedImage.getHeight(), (int)frameRate, settings);
            boolean reachedEndPoint = false;
            while (!reachedEndPoint) {
                this.printIfDebug("ExportVideo: Capturing Frame");
                movieBuilder.encodeFrame(captureDevice.exportSnapshotAsBufferedImage());
                this.printIfDebug("Waiting For simulationSynchronizer 1");
                SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
                synchronized (simulationSynchronizer) {
                    this.printIfDebug("Done Waiting For simulationSynchronizer 1");
                    double nextFrameTime = lastFrameTime + videoDT;
                    int stepSize = (int)Math.round((nextFrameTime - this.timeHolder.getTime()) / recordDT);
                    reachedEndPoint = this.dataBufferCommandsExecutor.tickAndReadFromBuffer(stepSize);
                    if (reachedEndPoint) {
                        break;
                    }
                    this.standardSimulationGUI.updateRobots();
                    this.standardSimulationGUI.updateGraphs();
                    this.standardSimulationGUI.allowTickUpdatesNow();
                    lastFrameTime = nextFrameTime;
                }
                this.standardSimulationGUI.updateGraphs();
            }
        }
        catch (IOException e) {
            LogTools.error((String)("Could not crate movie.  " + e.getMessage()));
        }
        finally {
            if (movieBuilder != null) {
                try {
                    movieBuilder.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> saveSimulationAsSequenceOfImages(String path, String NameNoExtension, CaptureDevice captureDevice) {
        this.standardSimulationGUI.updateGraphs();
        try {
            Thread.sleep(125L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Vector<File> output = new Vector<File>();
        int last = 0;
        if (this.standardSimulationGUI == null) {
            return null;
        }
        this.gotoInPointCommandExecutor.gotoInPoint();
        while (last < this.dataBufferCommandsExecutor.getOutPoint()) {
            last = this.dataBufferCommandsExecutor.getCurrentIndex();
            File file = new File(path, NameNoExtension + "_" + last + ".jpeg");
            captureDevice.exportSnapshot(file);
            output.add(file);
            this.printIfDebug("Waiting For simulationSynchronizer 2");
            SimulationSynchronizer simulationSynchronizer = this.simulationSynchronizer;
            synchronized (simulationSynchronizer) {
                this.printIfDebug("Done Waiting For simulationSynchronizer 2");
                this.dataBufferCommandsExecutor.tickAndReadFromBuffer(1);
                this.standardSimulationGUI.updateRobots();
                this.standardSimulationGUI.allowTickUpdatesNow();
            }
            this.standardSimulationGUI.updateGraphs();
        }
        return output;
    }
}

