/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.simulatedSensors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.simulatedSensors.WrenchCalculatorInterface;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class GroundContactPointBasedWrenchCalculator
implements WrenchCalculatorInterface {
    private static final int WRENCH_SIZE = 6;
    private final String forceSensorName;
    private final List<GroundContactPoint> contactPoints;
    private final Joint forceTorqueSensorJoint;
    private final RigidBodyTransform transformToParentJoint;
    private boolean doWrenchCorruption = false;
    private final DMatrixRMaj wrenchMatrix = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj corruptionMatrix = new DMatrixRMaj(6, 1);
    private final Map<String, YoFrameVector3D> yoContactForceInSensorFrame = new HashMap<String, YoFrameVector3D>();
    private final ReferenceFrame sensorFrame;
    private final RigidBodyTransform transformToOriginFrame = new RigidBodyTransform();
    private final Vector3D force = new Vector3D();
    private final Vector3D contactPointMoment = new Vector3D();
    private final Point3D contactPointOriginFrame = new Point3D();
    private final Vector3D contactVectorOriginFrame = new Vector3D();
    private final Vector3D tau = new Vector3D();
    private final Point3D tempContactPoint = new Point3D();

    public GroundContactPointBasedWrenchCalculator(String forceSensorName, List<GroundContactPoint> contactPoints, Joint forceTorqueSensorJoint, RigidBodyTransform transformToParentJoint, YoRegistry registry) {
        this.forceSensorName = forceSensorName;
        this.contactPoints = contactPoints;
        this.forceTorqueSensorJoint = forceTorqueSensorJoint;
        this.transformToParentJoint = new RigidBodyTransform((RigidBodyTransformReadOnly)transformToParentJoint);
        this.sensorFrame = new ReferenceFrame(forceSensorName + "Frame", ReferenceFrame.getWorldFrame()){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.set(GroundContactPointBasedWrenchCalculator.this.transformToOriginFrame);
            }
        };
        for (int i = 0; i < this.contactPoints.size(); ++i) {
            String contactPointName;
            String namePrefix;
            if (registry == null || registry.findVariable((namePrefix = (contactPointName = contactPoints.get(i).getName()) + "_ForceInSensorFrame") + "X") != null) continue;
            this.yoContactForceInSensorFrame.put(contactPointName, new YoFrameVector3D(namePrefix, this.sensorFrame, registry));
        }
    }

    @Override
    public String getName() {
        return this.forceSensorName;
    }

    @Override
    public void calculate() {
        int i;
        this.wrenchMatrix.zero();
        this.forceTorqueSensorJoint.getTransformToWorld((RigidBodyTransformBasics)this.transformToOriginFrame);
        this.transformToOriginFrame.multiply((RigidBodyTransformReadOnly)this.transformToParentJoint);
        this.sensorFrame.update();
        this.transformToOriginFrame.invert();
        for (i = 0; i < this.contactPoints.size(); ++i) {
            GroundContactPoint contactPoint = this.contactPoints.get(i);
            contactPoint.getForce((Vector3DBasics)this.force);
            contactPoint.getMoment((Vector3DBasics)this.contactPointMoment);
            this.transformToOriginFrame.transform((Vector3DBasics)this.force);
            this.transformToOriginFrame.transform((Vector3DBasics)this.contactPointMoment);
            this.contactPointOriginFrame.set(0.0, 0.0, 0.0);
            contactPoint.getPosition((Tuple3DBasics)this.tempContactPoint);
            this.transformToOriginFrame.transform((Point3DReadOnly)this.tempContactPoint, (Point3DBasics)this.contactPointOriginFrame);
            this.contactVectorOriginFrame.set((Tuple3DReadOnly)this.contactPointOriginFrame);
            this.tau.cross((Tuple3DReadOnly)this.contactVectorOriginFrame, (Tuple3DReadOnly)this.force);
            this.tau.add((Tuple3DReadOnly)this.contactPointMoment);
            this.wrenchMatrix.set(0, 0, this.wrenchMatrix.get(0, 0) + this.tau.getX());
            this.wrenchMatrix.set(1, 0, this.wrenchMatrix.get(1, 0) + this.tau.getY());
            this.wrenchMatrix.set(2, 0, this.wrenchMatrix.get(2, 0) + this.tau.getZ());
            this.wrenchMatrix.set(3, 0, this.wrenchMatrix.get(3, 0) + this.force.getX());
            this.wrenchMatrix.set(4, 0, this.wrenchMatrix.get(4, 0) + this.force.getY());
            this.wrenchMatrix.set(5, 0, this.wrenchMatrix.get(5, 0) + this.force.getZ());
            if (!this.yoContactForceInSensorFrame.containsKey(contactPoint.getName())) continue;
            this.yoContactForceInSensorFrame.get(contactPoint.getName()).set((Tuple3DReadOnly)this.force);
        }
        if (this.doWrenchCorruption) {
            for (i = 0; i < 6; ++i) {
                this.wrenchMatrix.add(i, 0, this.corruptionMatrix.get(i, 0));
            }
        }
    }

    @Override
    public Joint getJoint() {
        return this.forceTorqueSensorJoint;
    }

    @Override
    public DMatrixRMaj getWrench() {
        return this.wrenchMatrix;
    }

    @Override
    public void setDoWrenchCorruption(boolean value) {
        this.doWrenchCorruption = value;
    }

    @Override
    public void corruptWrenchElement(int row, double value) {
        this.corruptionMatrix.add(row, 0, value);
    }

    @Override
    public void getTransformToParentJoint(RigidBodyTransform transformToPack) {
        transformToPack.set(this.transformToParentJoint);
    }

    public String toString() {
        return this.forceSensorName + " " + this.contactPoints;
    }
}

