/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.robotdefinition;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddModelFileInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DPrimitiveInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DIdentityInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DTranslateInstruction;
import us.ihmc.simulationconstructionset.DummyOneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.FloatingPlanarJoint;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SliderJoint;
import us.ihmc.simulationconstructionset.robotdefinition.ExternalForcePointDefinitionFixedFrame;
import us.ihmc.simulationconstructionset.robotdefinition.GroundContactDefinitionFixedFrame;
import us.ihmc.simulationconstructionset.robotdefinition.JointDefinitionFixedFrame;
import us.ihmc.simulationconstructionset.robotdefinition.LinkDefinitionFixedFrame;
import us.ihmc.simulationconstructionset.util.XMLReaderUtility;

public class RobotDefinitionFixedFrame {
    private final ArrayList<JointDefinitionFixedFrame> rootJointDefinitions = new ArrayList();
    private String robotName = "defaultName";

    public void createRobotDefinitionFromRobot(Robot r) {
        List<Joint> rootJoints = r.getRootJoints();
        for (Joint rootJoint : rootJoints) {
            this.rootJointDefinitions.add(this.createJointDefinition(rootJoint, null));
        }
    }

    public String getRobotName() {
        return this.robotName;
    }

    public void createRobotDefinitionFromRobotConfigurationFile(File file) {
        try {
            String tempLine;
            BufferedReader reader = file.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))))) : new BufferedReader(new FileReader(file));
            String xmlRepresentation = "";
            while ((tempLine = reader.readLine()) != null) {
                System.out.println(tempLine);
                xmlRepresentation = xmlRepresentation + tempLine;
                if (tempLine.contains("$MODEL")) {
                    this.robotName = tempLine.substring(6).trim();
                    System.out.println(this.robotName);
                    continue;
                }
                if (!tempLine.contains("$END_HEADER") && !tempLine.contains("</RobotDefinition>")) continue;
            }
            if (xmlRepresentation.startsWith("$<")) {
                xmlRepresentation = this.replaceAll(xmlRepresentation, "\n$", "\n");
            }
            this.createRobotDefinitionFromRobotConfigurationString(xmlRepresentation);
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private String replaceAll(String orig, String regex, String rep) {
        int index = 0;
        while (index + regex.length() < orig.length()) {
            if (orig.substring(index, index + regex.length()).equals(regex)) {
                orig = this.replace(orig, index, index + regex.length(), rep);
                index += rep.length() - 1;
            }
            ++index;
        }
        return orig;
    }

    private String replace(String fullString, int beginIndex, int endIndex, String replacement) {
        if (beginIndex >= 0 && beginIndex < fullString.length() && endIndex >= 0 && endIndex < fullString.length()) {
            String prefix = fullString.substring(0, beginIndex);
            String suffix = fullString.substring(endIndex);
            return prefix + replacement + suffix;
        }
        return null;
    }

    public void createRobotDefinitionFromRobotConfigurationString(String xmlString) {
        ArrayList<JointDefinitionFixedFrame> allJoints = new ArrayList<JointDefinitionFixedFrame>();
        String jointString = "";
        int currentJointIndex = 0;
        while ((jointString = XMLReaderUtility.getMiddleString((int)currentJointIndex, (String)xmlString, (String)"<Joint>", (String)"</Joint>")) != null) {
            currentJointIndex = XMLReaderUtility.getEndIndexOfSubString((int)currentJointIndex, (String)xmlString, (String)"</Joint>");
            String type = XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<Type>", (String)"</Type>");
            String name = XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<Name>", (String)"</Name>");
            String parent = XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<Parent>", (String)"</Parent>");
            String rootJoint = XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<RootJoint>", (String)"</RootJoint>");
            Vector3D offset = XMLReaderUtility.parseVector3d((String)XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<Offset>", (String)"</Offset>"));
            Vector3D axis = XMLReaderUtility.parseVector3d((String)XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<Axis>", (String)"</Axis>"));
            JointDefinitionFixedFrame joint = new JointDefinitionFixedFrame();
            if (type.equals("FLOATING_JOINT")) {
                joint.setType(JointDefinitionFixedFrame.JointType.FLOATING_JOINT);
            } else if (type.equals("PIN_JOINT")) {
                joint.setType(JointDefinitionFixedFrame.JointType.PIN_JOINT);
            } else if (type.equals("SLIDER_JOINT")) {
                joint.setType(JointDefinitionFixedFrame.JointType.SLIDER_JOINT);
            } else if (type.equals("FLOATING_PLANAR_JOINT")) {
                joint.setType(JointDefinitionFixedFrame.JointType.FLOATING_PLANAR_JOINT);
            } else {
                XMLReaderUtility.displayErrorMessage((String)("Unknown type: " + type));
            }
            joint.setJointName(name);
            joint.setRootJoint(rootJoint.equals("true"));
            if (!joint.isRootJoint()) {
                joint.setParentName(parent);
            }
            joint.setOffset(offset);
            joint.setJointAxis(axis);
            String GcString = XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<GroundContactPoints>", (String)"</GroundContactPoints>");
            this.createGroundContactPointDefinitionsFromString(GcString, joint);
            String efpString = XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<ExternalForcePoints>", (String)"</ExternalForcePoints>");
            this.createExternalForcePointDefinitionsFromString(efpString, joint);
            String link = XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<Link>", (String)"</Link>");
            LinkDefinitionFixedFrame linkDefinition = this.createLinkDefinitionFromFile(link);
            joint.setLinkDefinition(linkDefinition);
            if (joint.isRootJoint()) {
                this.rootJointDefinitions.add(joint);
            }
            allJoints.add(joint);
        }
        this.setParentsAndChildren(allJoints);
    }

    private void createGroundContactPointDefinitionsFromString(String xmlString, JointDefinitionFixedFrame jointToAddTo) {
        String jointString = "";
        int currentGroundContactPointIndex = 0;
        if (xmlString != null) {
            while ((jointString = XMLReaderUtility.getMiddleString((int)currentGroundContactPointIndex, (String)xmlString, (String)"<GroundContactPoint>", (String)"</GroundContactPoint>")) != null) {
                currentGroundContactPointIndex = XMLReaderUtility.getEndIndexOfSubString((int)currentGroundContactPointIndex, (String)xmlString, (String)"</GroundContactPoint>");
                String name = XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<Name>", (String)"</Name>");
                Vector3D offset = XMLReaderUtility.parseVector3d((String)XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<Offset>", (String)"</Offset>"));
                GroundContactDefinitionFixedFrame gc = new GroundContactDefinitionFixedFrame();
                gc.setName(name);
                gc.setOffset(offset);
                jointToAddTo.addGroundContactDefinitionFixedFrame(gc);
            }
        }
    }

    private void createExternalForcePointDefinitionsFromString(String xmlString, JointDefinitionFixedFrame jointToAddTo) {
        String jointString = "";
        int currentExternalForcePointIndex = 0;
        if (xmlString != null) {
            while ((jointString = XMLReaderUtility.getMiddleString((int)currentExternalForcePointIndex, (String)xmlString, (String)"<ExternalForcePoint>", (String)"</ExternalForcePoint>")) != null) {
                currentExternalForcePointIndex = XMLReaderUtility.getEndIndexOfSubString((int)currentExternalForcePointIndex, (String)xmlString, (String)"</ExternalForcePoint>");
                String name = XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<Name>", (String)"</Name>");
                Vector3D offset = XMLReaderUtility.parseVector3d((String)XMLReaderUtility.getMiddleString((int)0, (String)jointString, (String)"<Offset>", (String)"</Offset>"));
                ExternalForcePointDefinitionFixedFrame efp = new ExternalForcePointDefinitionFixedFrame();
                efp.setName(name);
                efp.setOffset(offset);
                jointToAddTo.addExternalForcePointDefinition(efp);
            }
        }
    }

    private void setParentsAndChildren(ArrayList<JointDefinitionFixedFrame> allJoints) {
        for (JointDefinitionFixedFrame currentJoint : allJoints) {
            if (currentJoint.isRootJoint()) continue;
            JointDefinitionFixedFrame parent = this.getJointFromListByName(currentJoint.getParentName(), allJoints);
            parent.addChildJoint(currentJoint);
            currentJoint.setParentJoint(parent);
        }
    }

    private JointDefinitionFixedFrame getJointFromListByName(String name, ArrayList<JointDefinitionFixedFrame> allJoints) {
        for (JointDefinitionFixedFrame joint : allJoints) {
            if (!joint.getJointName().equals(name)) continue;
            return joint;
        }
        return null;
    }

    public LinkDefinitionFixedFrame createLinkDefinitionFromFile(String linkString) {
        LinkDefinitionFixedFrame l = new LinkDefinitionFixedFrame();
        double mass = XMLReaderUtility.parseDoubleBetweenTwoStrings((int)0, (String)linkString, (String)"<Mass>", (String)"</Mass>");
        Vector3D comOffset = XMLReaderUtility.parseVector3d((String)XMLReaderUtility.getMiddleString((int)0, (String)linkString, (String)"<ComOffset>", (String)"</ComOffset>"));
        Matrix3D inertia = XMLReaderUtility.parseMatrix3d((String)XMLReaderUtility.getMiddleString((int)0, (String)linkString, (String)"<MomentOfInertia>", (String)"</MomentOfInertia>"));
        l.setMass(mass);
        l.setComOffset(comOffset);
        l.setInertia(inertia);
        l.setLinkGraphics(this.createLinkGraphicsDefinitionFromFile(XMLReaderUtility.getMiddleString((int)0, (String)linkString, (String)"<Graphics>", (String)"</Graphics>")));
        return l;
    }

    public Graphics3DObject createLinkGraphicsDefinitionFromFile(String graphicsString) {
        Graphics3DObject def = new Graphics3DObject();
        String type = "";
        int currentTypeIndex = 0;
        while ((type = XMLReaderUtility.getMiddleString((int)currentTypeIndex, (String)graphicsString, (String)"<", (String)">")) != null) {
            Graphics3DAddModelFileInstruction t;
            String data = null;
            if (type.equals("Add3DSFile")) {
                data = XMLReaderUtility.getMiddleString((int)currentTypeIndex, (String)graphicsString, (String)"<Add3DSFile>", (String)"</Add3DSFile>");
                String name = XMLReaderUtility.getMiddleString((int)0, (String)data, (String)"<Name>", (String)"</Name>");
                t = new Graphics3DAddModelFileInstruction(name);
                def.addInstruction((Graphics3DPrimitiveInstruction)t);
                currentTypeIndex = XMLReaderUtility.getEndIndexOfSubString((int)currentTypeIndex, (String)graphicsString, (String)"</Add3DSFile>");
                continue;
            }
            if (type.equals("Identity")) {
                def.addInstruction((Graphics3DPrimitiveInstruction)new Graphics3DIdentityInstruction());
                currentTypeIndex = XMLReaderUtility.getEndIndexOfSubString((int)currentTypeIndex, (String)graphicsString, (String)"<Identity>");
                continue;
            }
            if (type.equals("Translate")) {
                data = XMLReaderUtility.getMiddleString((int)currentTypeIndex, (String)graphicsString, (String)"<Translate>", (String)"</Translate>");
                Vector3D translation = XMLReaderUtility.parseVector3d((String)data);
                t = new Graphics3DTranslateInstruction((Tuple3DReadOnly)translation);
                def.addInstruction((Graphics3DPrimitiveInstruction)t);
                currentTypeIndex = XMLReaderUtility.getEndIndexOfSubString((int)currentTypeIndex, (String)graphicsString, (String)"</Translate>");
                continue;
            }
            System.err.println("Type: " + type + " not supported");
            currentTypeIndex = XMLReaderUtility.getEndIndexOfSubString((int)currentTypeIndex, (String)graphicsString, (String)">");
        }
        return def;
    }

    public void addRootJoint(JointDefinitionFixedFrame jointDef) {
        this.rootJointDefinitions.add(jointDef);
    }

    public int getNumberOfJoints() {
        int numberOfJoints = this.rootJointDefinitions.size();
        for (JointDefinitionFixedFrame joint : this.rootJointDefinitions) {
            numberOfJoints += joint.getNumberOfChildJoints();
        }
        return numberOfJoints;
    }

    private JointDefinitionFixedFrame createJointDefinition(Joint joint, JointDefinitionFixedFrame parentJoint) {
        JointDefinitionFixedFrame jointDef = new JointDefinitionFixedFrame();
        if (parentJoint == null) {
            jointDef.setRootJoint(true);
        }
        jointDef.setJointName(joint.getName());
        jointDef.setParentJoint(parentJoint);
        if (joint.getGroundContactPointGroup() != null) {
            for (GroundContactPoint groundContactPoint : joint.getGroundContactPointGroup().getGroundContactPoints()) {
                GroundContactDefinitionFixedFrame groundContactDefinitionFixedFrame = new GroundContactDefinitionFixedFrame();
                groundContactDefinitionFixedFrame.setName(groundContactPoint.getName());
                groundContactDefinitionFixedFrame.setOffset(groundContactPoint.getOffsetCopy());
                jointDef.addGroundContactDefinitionFixedFrame(groundContactDefinitionFixedFrame);
            }
        }
        if (joint.getExternalForcePoints() != null) {
            for (ExternalForcePoint externalForcePoint : joint.getExternalForcePoints()) {
                ExternalForcePointDefinitionFixedFrame externalForcePointDefinitionFixedFrame = new ExternalForcePointDefinitionFixedFrame();
                externalForcePointDefinitionFixedFrame.setName(externalForcePoint.getName());
                externalForcePointDefinitionFixedFrame.setOffset(externalForcePoint.getOffsetCopy());
                jointDef.addExternalForcePointDefinition(externalForcePointDefinitionFixedFrame);
            }
        }
        Vector3D offset = new Vector3D();
        joint.getOffset((Vector3DBasics)offset);
        jointDef.setOffset(offset);
        Vector3D jointAxis = new Vector3D();
        joint.getJointAxis((Vector3DBasics)jointAxis);
        jointDef.setJointAxis(jointAxis);
        if (joint instanceof PinJoint) {
            jointDef.setType(JointDefinitionFixedFrame.JointType.PIN_JOINT);
        } else if (joint instanceof SliderJoint) {
            jointDef.setType(JointDefinitionFixedFrame.JointType.SLIDER_JOINT);
        } else if (joint instanceof FloatingJoint) {
            jointDef.setType(JointDefinitionFixedFrame.JointType.FLOATING_JOINT);
        } else if (joint instanceof FloatingPlanarJoint) {
            jointDef.setType(JointDefinitionFixedFrame.JointType.FLOATING_PLANAR_JOINT);
            jointDef.setPlanarType(((FloatingPlanarJoint)joint).getType());
        } else if (joint instanceof DummyOneDegreeOfFreedomJoint) {
            jointDef.setType(JointDefinitionFixedFrame.JointType.PIN_JOINT);
        } else {
            throw new RuntimeException("Only Pin, Slider, Floating, and Floating Planar joints implemented right now. joint = " + joint + ", joint class = " + joint.getClass());
        }
        Link link = joint.getLink();
        LinkDefinitionFixedFrame linkDef = this.createLinkDefinition(link);
        jointDef.setLinkDefinition(linkDef);
        List<Joint> childrenJoints = joint.getChildrenJoints();
        for (Joint childJoint : childrenJoints) {
            jointDef.addChildJoint(this.createJointDefinition(childJoint, jointDef));
        }
        return jointDef;
    }

    private LinkDefinitionFixedFrame createLinkDefinition(Link link) {
        LinkDefinitionFixedFrame linkDef = new LinkDefinitionFixedFrame();
        linkDef.setName(link.getName());
        linkDef.setMass(link.getMass());
        Vector3D comOffset = new Vector3D();
        link.getComOffset((Vector3DBasics)comOffset);
        linkDef.setComOffset(comOffset);
        Matrix3D momentOfInertia = new Matrix3D();
        link.getMomentOfInertia((Matrix3DBasics)momentOfInertia);
        linkDef.setInertia(momentOfInertia);
        linkDef.setLinkGraphics(link.getLinkGraphics());
        return linkDef;
    }

    public ArrayList<JointDefinitionFixedFrame> getRootJointDefinitions() {
        return this.rootJointDefinitions;
    }

    public String returnAllJointStrings(JointDefinitionFixedFrame currentJoint, JointDefinitionFixedFrame parent) {
        String returnString = "";
        ArrayList<JointDefinitionFixedFrame> childrenJoints = currentJoint.getChildrenJoints();
        returnString = returnString + currentJoint.toString();
        for (JointDefinitionFixedFrame childJoint : childrenJoints) {
            returnString = returnString + this.returnAllJointStrings(childJoint, currentJoint);
        }
        return returnString;
    }

    public String toString() {
        String returnString = "<RobotDefinition>\n";
        for (JointDefinitionFixedFrame rootJoint : this.rootJointDefinitions) {
            returnString = returnString + this.returnAllJointStrings(rootJoint, null);
        }
        returnString = returnString + "</RobotDefinition>\n";
        return returnString;
    }
}

