/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraMountInterface;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraMountList;
import us.ihmc.simulationconstructionset.DynamicIntegrationMethod;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.FloatingPlanarJoint;
import us.ihmc.simulationconstructionset.FunctionIntegrator;
import us.ihmc.simulationconstructionset.FunctionIntegrators;
import us.ihmc.simulationconstructionset.FunctionToIntegrate;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.GroundContactPointsHolder;
import us.ihmc.simulationconstructionset.IMUMount;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.KinematicPoint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.LoopClosureSoftConstraint;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.RobotControllerAndParameters;
import us.ihmc.simulationconstructionset.SimulatedSensor;
import us.ihmc.simulationconstructionset.SliderJoint;
import us.ihmc.simulationconstructionset.SpatialVector;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.robotdefinition.ExternalForcePointDefinitionFixedFrame;
import us.ihmc.simulationconstructionset.robotdefinition.GroundContactDefinitionFixedFrame;
import us.ihmc.simulationconstructionset.robotdefinition.JointDefinitionFixedFrame;
import us.ihmc.simulationconstructionset.robotdefinition.RobotDefinitionFixedFrame;
import us.ihmc.simulationconstructionset.simulatedSensors.LidarMount;
import us.ihmc.simulationconstructionset.simulatedSensors.WrenchCalculatorInterface;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class Robot
implements YoVariableHolder,
GroundContactPointsHolder {
    protected YoRegistry yoRegistry;
    protected final List<YoGraphicsListRegistry> yoGraphicsListRegistries = new ArrayList<YoGraphicsListRegistry>();
    private List<Joint> rootJoints;
    private FunctionIntegrators functionIntegrators = null;
    private final String name;
    protected YoDouble t;
    public YoDouble gravityX;
    public YoDouble gravityY;
    public YoDouble gravityZ;
    private List<RobotControllerAndParameters> controllers = new ArrayList<RobotControllerAndParameters>();
    private GroundContactModel groundContactModel;
    private ExternalForcePoint kp_body;
    private DynamicIntegrationMethod dynamicIntegrationMethod = DynamicIntegrationMethod.RUNGE_KUTTA_FOURTH_ORDER;
    private final List<Graphics3DObject> staticLinkGraphics = new ArrayList<Graphics3DObject>();
    private Vector3D w_null = new Vector3D();
    private Vector3D v_null = new Vector3D();
    private SpatialVector a_hat_h_null = new SpatialVector();
    private RotationMatrix R_0_i = new RotationMatrix();
    private Point3D tempCOMPoint = new Point3D();
    private Vector3D tempLinearMomentum = new Vector3D();
    private Vector3D tempAngularMomentum = new Vector3D();
    private Vector3D tempCOMVector = new Vector3D();
    private final Vector3D tempRVector = new Vector3D();
    private final Vector3D tempRCrossF = new Vector3D();
    private final Vector3D tempForce = new Vector3D();

    public Robot(RobotDefinitionFixedFrame definition, String name) {
        this(name);
        this.constructRobotFromDefinition(definition);
    }

    private void constructRobotFromDefinition(RobotDefinitionFixedFrame definition) {
        for (JointDefinitionFixedFrame currentRootJoint : definition.getRootJointDefinitions()) {
            this.traverseJointDefinitions(currentRootJoint, null);
        }
    }

    private void traverseJointDefinitions(JointDefinitionFixedFrame jointDefinition, Joint parent) {
        Joint currentJoint = null;
        if (jointDefinition.getType() == JointDefinitionFixedFrame.JointType.FLOATING_JOINT) {
            currentJoint = new FloatingJoint(jointDefinition.getJointName(), (Tuple3DReadOnly)jointDefinition.getOffset(), this);
        } else if (jointDefinition.getType() == JointDefinitionFixedFrame.JointType.FLOATING_PLANAR_JOINT) {
            currentJoint = new FloatingPlanarJoint(jointDefinition.getJointName(), this, jointDefinition.getPlanarType());
        } else if (jointDefinition.getType() == JointDefinitionFixedFrame.JointType.PIN_JOINT) {
            currentJoint = new PinJoint(jointDefinition.getJointName(), (Tuple3DReadOnly)jointDefinition.getOffset(), this, (Vector3DReadOnly)jointDefinition.getJointAxis());
        } else if (jointDefinition.getType() == JointDefinitionFixedFrame.JointType.SLIDER_JOINT) {
            currentJoint = new SliderJoint(jointDefinition.getJointName(), (Tuple3DReadOnly)jointDefinition.getOffset(), this, (Vector3DReadOnly)jointDefinition.getJointAxis());
        }
        for (GroundContactDefinitionFixedFrame groundContactDefinitionFixedFrame : jointDefinition.getGroundContactDefinitionsFixedFrame()) {
            GroundContactPoint groundContactPoint = new GroundContactPoint(groundContactDefinitionFixedFrame.getName(), (Tuple3DReadOnly)groundContactDefinitionFixedFrame.getOffset(), this.getRobotsYoRegistry());
            currentJoint.addGroundContactPoint(groundContactPoint);
        }
        for (ExternalForcePointDefinitionFixedFrame externalForcePointDefinitionFixedFrame : jointDefinition.getExternalForcePointDefinitionsFixedFrame()) {
            ExternalForcePoint externalForcePoint = new ExternalForcePoint(externalForcePointDefinitionFixedFrame.getName(), (Tuple3DReadOnly)externalForcePointDefinitionFixedFrame.getOffset(), this.getRobotsYoRegistry());
            currentJoint.addExternalForcePoint(externalForcePoint);
        }
        currentJoint.setLink(new Link(jointDefinition.getLinkDefinition()));
        if (parent == null) {
            this.addRootJoint(currentJoint);
        } else {
            parent.addJoint(currentJoint);
        }
        for (JointDefinitionFixedFrame childJoint : jointDefinition.getChildrenJoints()) {
            this.traverseJointDefinitions(childJoint, currentJoint);
        }
    }

    public Robot(String name) {
        this.name = name;
        this.yoRegistry = new YoRegistry(name);
        this.rootJoints = new ArrayList<Joint>();
        this.t = new YoDouble("t", this.yoRegistry);
        this.gravityX = new YoDouble("gravityX", this.yoRegistry);
        this.gravityY = new YoDouble("gravityY", this.yoRegistry);
        this.gravityZ = new YoDouble("gravityZ", this.yoRegistry);
        this.setDefaultGravityToEarthWithMetricUnits();
    }

    public void setDynamicIntegrationMethod(DynamicIntegrationMethod dynamicIntegrationMethod) {
        this.dynamicIntegrationMethod = dynamicIntegrationMethod;
    }

    private void setDefaultGravityToEarthWithMetricUnits() {
        this.gravityZ.set(-9.81);
    }

    public double getTime() {
        return this.t.getDoubleValue();
    }

    public void setTime(double time) {
        this.t.set(time);
    }

    public void setDynamic(boolean isDynamic) {
        for (Joint joint : this.rootJoints) {
            joint.setDynamic(isDynamic);
        }
    }

    public YoDouble getYoTime() {
        return this.t;
    }

    public double getGravityX() {
        return this.gravityX.getDoubleValue();
    }

    public double getGravityY() {
        return this.gravityY.getDoubleValue();
    }

    public double getGravityZ() {
        return this.gravityZ.getDoubleValue();
    }

    public void getGravity(Vector3D gravityVectorToPack) {
        gravityVectorToPack.set(this.gravityX.getDoubleValue(), this.gravityY.getDoubleValue(), this.gravityZ.getDoubleValue());
    }

    public void addYoRegistry(YoRegistry registry) {
        if (registry == null) {
            throw new RuntimeException("Cannot add a null registry to " + this.name + "!!!!");
        }
        this.getRobotsYoRegistry().addChild(registry);
    }

    public void addYoGraphicsListRegistry(YoGraphicsListRegistry yoGraphicsListRegistry) {
        if (yoGraphicsListRegistry == null) {
            throw new RuntimeException("Cannot add a null yoGraphicsListRegistry to " + this.name + "!!!!");
        }
        this.yoGraphicsListRegistries.add(yoGraphicsListRegistry);
    }

    public void addRootJoint(Joint root) {
        this.rootJoints.add(root);
    }

    public GroundContactModel getGroundContactModel() {
        return this.groundContactModel;
    }

    public void decideGroundContactPointsInContact() {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.physics.recursiveDecideGroundContactPointsInContact();
        }
    }

    public void doLoopClosure() {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.physics.doLoopClosureRecursive();
        }
    }

    public List<Joint> getRootJoints() {
        return this.rootJoints;
    }

    public void getRootJoints(List<Joint> jointsToPack) {
        jointsToPack.addAll(this.rootJoints);
    }

    public void setGravity(double gravityX, double gravityY, double gravityZ) {
        this.gravityX.set(gravityX);
        this.gravityY.set(gravityY);
        this.gravityZ.set(gravityZ);
    }

    public void setGravity(Vector3DReadOnly gravity) {
        this.gravityX.set(gravity.getX());
        this.gravityY.set(gravity.getY());
        this.gravityZ.set(gravity.getZ());
    }

    public void setGravity(double gZ) {
        this.setGravity(0.0, 0.0, gZ);
    }

    public void addFunctionToIntegrate(FunctionToIntegrate functionToIntegrate) {
        if (functionToIntegrate == null) {
            return;
        }
        if (this.functionIntegrators == null) {
            this.functionIntegrators = new FunctionIntegrators();
        }
        this.functionIntegrators.addFunctionIntegrator(new FunctionIntegrator(functionToIntegrate));
    }

    public void setController(RobotController controller) {
        this.setController(controller, 1);
    }

    public void setController(RobotController controller, int simulationTicksPerControlTick) {
        this.setController(new RobotControllerAndParameters(controller, simulationTicksPerControlTick));
    }

    public void setController(List<RobotController> controllers, int simulationTicksPerControlTick) {
        for (int i = 0; i < controllers.size(); ++i) {
            RobotController controller = controllers.get(i);
            this.setController(controller, simulationTicksPerControlTick);
        }
    }

    public void setControllersAndCallInitialization(List<RobotControllerAndParameters> robotControllersAndParameters) {
        for (RobotControllerAndParameters robotControllerAndParameters : robotControllersAndParameters) {
            this.setController(robotControllerAndParameters);
            robotControllerAndParameters.getController().initialize();
        }
    }

    public void setController(RobotControllerAndParameters controllerAndParameters) {
        YoRegistry registry = controllerAndParameters.getController().getYoRegistry();
        this.controllers.add(controllerAndParameters);
        this.addYoRegistry(registry);
    }

    public final void doControllers() {
        if (this.controllers == null) {
            return;
        }
        for (int i = 0; i < this.controllers.size(); ++i) {
            RobotControllerAndParameters controller = this.controllers.get(i);
            controller.ticks_till_control.set(controller.ticks_till_control.getIntegerValue() - 1);
            if (controller.ticks_till_control.getIntegerValue() > 0) continue;
            controller.ticks_till_control.set(controller.simulationTicksPerControlTick);
            controller.controller.doControl();
        }
    }

    public void setGroundContactModel(GroundContactModel gcModel) {
        this.groundContactModel = gcModel;
    }

    public String getName() {
        return this.name;
    }

    public void update() {
        boolean updatePoints = true;
        boolean updateCameraMounts = true;
        boolean updateIMUMounts = true;
        this.update(updatePoints, updateCameraMounts, updateIMUMounts);
    }

    public void updateForPlayback() {
        boolean updatePoints = false;
        boolean updateCameraMounts = true;
        boolean updateIMUMounts = false;
        this.update(updatePoints, updateCameraMounts, updateIMUMounts);
    }

    protected synchronized void update(boolean updatePoints, boolean updateCameraMounts, boolean updateIMUMounts) {
        for (int i = 0; i < this.rootJoints.size(); ++i) {
            Joint rootJoint = this.rootJoints.get(i);
            rootJoint.recursiveUpdateJoints(null, updatePoints, updateCameraMounts, updateIMUMounts, this.t.getDoubleValue());
        }
    }

    public void updateIMUMountAccelerations() {
        for (int i = 0; i < this.rootJoints.size(); ++i) {
            Joint rootJoint = this.rootJoints.get(i);
            rootJoint.recursiveUpdateJointsIMUMountAccelerations();
        }
    }

    public void updateAllGroundContactPointVelocities() {
        for (int i = 0; i < this.rootJoints.size(); ++i) {
            Joint rootJoint = this.rootJoints.get(i);
            rootJoint.physics.recursiveUpdateAllGroundContactPointVelocities();
        }
    }

    public void getCameraMountList(CameraMountList cameraMountList) {
        ArrayList<CameraMountInterface> mountArrayList = new ArrayList<CameraMountInterface>();
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.recursiveGetCameraMounts(mountArrayList);
            cameraMountList.addCameraMounts(mountArrayList);
        }
    }

    public List<SimulatedSensor> getSensors() {
        ArrayList<SimulatedSensor> ret = new ArrayList<SimulatedSensor>();
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.recursiveGetSensors(ret);
        }
        return ret;
    }

    public <T extends SimulatedSensor> List<T> getSensors(Class<T> sensorType) {
        List<SimulatedSensor> allSensors = this.getSensors();
        ArrayList<SimulatedSensor> specificSensors = new ArrayList<SimulatedSensor>();
        for (SimulatedSensor sensor : allSensors) {
            if (!sensorType.isAssignableFrom(sensor.getClass())) continue;
            specificSensors.add(sensor);
        }
        return specificSensors;
    }

    public void getAllOneDegreeOfFreedomJoints(List<OneDegreeOfFreedomJoint> oneDegreeOfFreedomJoints) {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.recursiveGetOneDegreeOfFreedomJoints(oneDegreeOfFreedomJoints);
        }
    }

    public void getAllLoopClosureSoftConstraints(List<LoopClosureSoftConstraint> constraintsToPack) {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.recursiveGetChildrenConstraints(constraintsToPack);
        }
    }

    public void getLidarMounts(List<LidarMount> lidarMountsToPack) {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.recursiveGetLidarMounts(lidarMountsToPack);
        }
    }

    public void getIMUMounts(List<IMUMount> imuMountsToPack) {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.recursiveGetIMUMounts(imuMountsToPack);
        }
    }

    public void getForceSensors(List<WrenchCalculatorInterface> forceSensors) {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.recursiveGetForceSensors(forceSensors);
        }
    }

    @Override
    public List<GroundContactPoint> getGroundContactPoints(int groundContactGroupIdentifier) {
        ArrayList<GroundContactPoint> ret = new ArrayList<GroundContactPoint>();
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.physics.recursiveGetGroundContactPoints(groundContactGroupIdentifier, ret);
        }
        return ret;
    }

    public List<List<GroundContactPoint>> getAllGroundContactPointsGroupedByJoint() {
        ArrayList<List<GroundContactPoint>> ret = new ArrayList<List<GroundContactPoint>>();
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.physics.recursiveGetAllGroundContactPointsGroupedByJoint(ret);
        }
        return ret;
    }

    public List<GroundContactPoint> getAllGroundContactPoints() {
        ArrayList<GroundContactPoint> ret = new ArrayList<GroundContactPoint>();
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.physics.recursiveGetAllGroundContactPoints(ret);
        }
        return ret;
    }

    public List<ExternalForcePoint> getAllExternalForcePoints() {
        ArrayList<ExternalForcePoint> ret = new ArrayList<ExternalForcePoint>();
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.physics.recursiveGetAllExternalForcePoints(ret);
        }
        return ret;
    }

    public List<KinematicPoint> getAllKinematicPoints() {
        ArrayList<KinematicPoint> ret = new ArrayList<KinematicPoint>();
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.physics.recursiveGetAllKinematicPoints(ret);
        }
        return ret;
    }

    public ExternalForcePoint getExternalForcePoint(String name) {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            ExternalForcePoint externalForcePoint = rootJoint.recursiveGetExternalForcePoint(name);
            if (externalForcePoint == null) continue;
            return externalForcePoint;
        }
        return null;
    }

    public void addStaticLink(Link staticLink) {
        this.addStaticLinkGraphics(staticLink.getLinkGraphics());
    }

    public void addStaticLinkGraphics(Graphics3DObject linkGraphics) {
        this.staticLinkGraphics.add(linkGraphics);
    }

    public void addStaticLinkGraphics(List<Graphics3DObject> linkGraphicsArray) {
        for (Graphics3DObject linkGraphics : linkGraphicsArray) {
            this.addStaticLinkGraphics(linkGraphics);
        }
    }

    public void updateVelocities() {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            this.R_0_i.setIdentity();
            this.w_null.set(0.0, 0.0, 0.0);
            this.v_null.set(0.0, 0.0, 0.0);
            this.a_hat_h_null.top.set(0.0, 0.0, 0.0);
            this.a_hat_h_null.bottom.set(0.0, 0.0, 0.0);
            rootJoint.physics.featherstonePassOne((Vector3DReadOnly)this.w_null, (Vector3DReadOnly)this.v_null, (RotationMatrixReadOnly)this.R_0_i);
        }
        this.update();
    }

    private void doDynamics(int passNumber) throws UnreasonableAccelerationException {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            if (rootJoint.isDynamic()) {
                this.R_0_i.setIdentity();
                this.w_null.set(0.0, 0.0, 0.0);
                this.v_null.set(0.0, 0.0, 0.0);
                this.a_hat_h_null.top.set(0.0, 0.0, 0.0);
                this.a_hat_h_null.bottom.set(0.0, 0.0, 0.0);
                rootJoint.physics.featherstonePassOne((Vector3DReadOnly)this.w_null, (Vector3DReadOnly)this.v_null, (RotationMatrixReadOnly)this.R_0_i);
                rootJoint.physics.featherstonePassTwo((Vector3DReadOnly)this.w_null);
                rootJoint.physics.featherstonePassThree();
                rootJoint.physics.featherstonePassFour(this.a_hat_h_null, passNumber);
                continue;
            }
            this.R_0_i.setIdentity();
            this.w_null.set(0.0, 0.0, 0.0);
            this.v_null.set(0.0, 0.0, 0.0);
            this.a_hat_h_null.top.set(0.0, 0.0, 0.0);
            this.a_hat_h_null.bottom.set(0.0, 0.0, 0.0);
            rootJoint.physics.featherstonePassOne((Vector3DReadOnly)this.w_null, (Vector3DReadOnly)this.v_null, (RotationMatrixReadOnly)this.R_0_i);
            rootJoint.physics.recordK(passNumber);
        }
    }

    public YoRegistry getRobotsYoRegistry() {
        return this.yoRegistry;
    }

    public void setRobotsYoRegistry(YoRegistry registry) {
        this.yoRegistry = registry;
    }

    private void rootJointsRecursiveSaveTempState() {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.physics.recursiveSaveTempState();
        }
    }

    public void rootJointsRecursiveEulerIntegrate(double dt) {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.physics.recursiveEulerIntegrate(dt);
        }
    }

    private void rootJointsRecursiveRestoreTempState() {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.physics.recursiveRestoreTempState();
        }
    }

    private void rootJointsRecursiveRungeKuttaSum(double dt) {
        List<Joint> children = this.getRootJoints();
        for (int i = 0; i < children.size(); ++i) {
            Joint rootJoint = children.get(i);
            rootJoint.physics.recursiveRungeKuttaSum(dt);
        }
    }

    public void doAfterControlBeforeDynamics() {
    }

    public void doDynamicsButDoNotIntegrate() throws UnreasonableAccelerationException {
        this.doAfterControlBeforeDynamics();
        this.doDynamics(0);
    }

    public void doDynamicsAndIntegrate(double DT) throws UnreasonableAccelerationException {
        this.doAfterControlBeforeDynamics();
        if (this.functionIntegrators != null) {
            this.doDynamicsAndIntegrateWithFunction(DT);
            return;
        }
        double temp_time = this.t.getDoubleValue();
        switch (this.dynamicIntegrationMethod) {
            case RUNGE_KUTTA_FOURTH_ORDER: {
                this.rootJointsRecursiveSaveTempState();
                this.doDynamics(0);
                this.rootJointsRecursiveEulerIntegrate(DT / 2.0);
                this.doDynamics(1);
                this.rootJointsRecursiveRestoreTempState();
                this.rootJointsRecursiveEulerIntegrate(DT / 2.0);
                this.doDynamics(2);
                this.rootJointsRecursiveRestoreTempState();
                this.rootJointsRecursiveEulerIntegrate(DT);
                this.doDynamics(3);
                this.rootJointsRecursiveRungeKuttaSum(DT);
                this.t.set(temp_time + DT);
                break;
            }
            case EULER_DOUBLE_STEPS: {
                this.rootJointsRecursiveSaveTempState();
                this.doDynamics(0);
                this.rootJointsRecursiveEulerIntegrate(DT / 2.0);
                this.t.set(temp_time + DT / 2.0);
                this.rootJointsRecursiveSaveTempState();
                this.doDynamics(1);
                this.rootJointsRecursiveEulerIntegrate(DT / 2.0);
                this.t.set(temp_time + DT);
                break;
            }
            default: {
                throw new RuntimeException("Should not get here");
            }
        }
    }

    private void doDynamicsAndIntegrateWithFunction(double DT) throws UnreasonableAccelerationException {
        double temp_time = this.t.getDoubleValue();
        this.functionIntegrators.saveTempState();
        this.rootJointsRecursiveSaveTempState();
        this.update();
        this.functionIntegrators.doDynamics(0);
        this.doDynamics(0);
        this.functionIntegrators.eulerIntegrate(DT / 2.0);
        this.rootJointsRecursiveEulerIntegrate(DT / 2.0);
        this.update();
        this.t.set(temp_time + DT / 2.0);
        this.functionIntegrators.doDynamics(1);
        this.doDynamics(1);
        this.functionIntegrators.restoreTempState();
        this.rootJointsRecursiveRestoreTempState();
        this.functionIntegrators.eulerIntegrate(DT / 2.0);
        this.rootJointsRecursiveEulerIntegrate(DT / 2.0);
        this.update();
        this.functionIntegrators.doDynamics(2);
        this.doDynamics(2);
        this.functionIntegrators.restoreTempState();
        this.rootJointsRecursiveRestoreTempState();
        this.functionIntegrators.eulerIntegrate(DT);
        this.rootJointsRecursiveEulerIntegrate(DT);
        this.update();
        this.t.set(temp_time + DT);
        this.functionIntegrators.doDynamics(3);
        this.doDynamics(3);
        this.functionIntegrators.rungeKuttaSum(DT);
        this.rootJointsRecursiveRungeKuttaSum(DT);
        this.t.set(temp_time + DT);
    }

    public double computeTranslationalKineticEnergy() {
        double translationalKineticEnergy = 0.0;
        for (int i = 0; i < this.rootJoints.size(); ++i) {
            Joint rootJoint = this.rootJoints.get(i);
            translationalKineticEnergy += this.computeTranslationalKineticEnergy(rootJoint);
        }
        return translationalKineticEnergy;
    }

    public double computeTranslationalKineticEnergy(Joint rootJoint) {
        return rootJoint.physics.recursiveComputeTranslationalKineticEnergy();
    }

    public double computeRotationalKineticEnergy() {
        double rotationalKineticEnergy = 0.0;
        for (int i = 0; i < this.rootJoints.size(); ++i) {
            Joint rootJoint = this.rootJoints.get(i);
            rotationalKineticEnergy += this.computeRotationalKineticEnergy(rootJoint);
        }
        return rotationalKineticEnergy;
    }

    public double computeRotationalKineticEnergy(Joint rootJoint) {
        return rootJoint.physics.recursiveComputeRotationalKineticEnergy();
    }

    public double computeGravitationalPotentialEnergy() {
        double gravitationalPotentialEnergy = 0.0;
        for (int i = 0; i < this.rootJoints.size(); ++i) {
            Joint rootJoint = this.rootJoints.get(i);
            gravitationalPotentialEnergy += this.computeGravitationalPotentialEnergy(rootJoint);
        }
        return gravitationalPotentialEnergy;
    }

    public double computeGravitationalPotentialEnergy(Joint rootJoint) {
        return rootJoint.physics.recursiveComputeGravitationalPotentialEnergy();
    }

    public double computeCenterOfMass(Point3DBasics comPoint) {
        double totalMass = 0.0;
        comPoint.set(0.0, 0.0, 0.0);
        for (int i = 0; i < this.rootJoints.size(); ++i) {
            Joint rootJoint = this.rootJoints.get(i);
            double mass = rootJoint.physics.recursiveComputeCenterOfMass((Point3DBasics)this.tempCOMPoint);
            totalMass += mass;
            this.tempCOMPoint.scale(mass);
            comPoint.add((Tuple3DReadOnly)this.tempCOMPoint);
        }
        if (totalMass > 0.0) {
            comPoint.scale(1.0 / totalMass);
        } else {
            comPoint.set(0.0, 0.0, 0.0);
        }
        return totalMass;
    }

    public double computeCenterOfMass(Joint rootJoint, Point3DBasics comPoint) {
        double totalMass = 0.0;
        comPoint.set(0.0, 0.0, 0.0);
        double mass = rootJoint.physics.recursiveComputeCenterOfMass((Point3DBasics)this.tempCOMPoint);
        totalMass += mass;
        this.tempCOMPoint.scale(mass);
        comPoint.add((Tuple3DReadOnly)this.tempCOMPoint);
        if (totalMass > 0.0) {
            comPoint.scale(1.0 / totalMass);
        } else {
            comPoint.set(0.0, 0.0, 0.0);
        }
        return totalMass;
    }

    public double computeLinearMomentum(Vector3DBasics linearMomentum) {
        double totalMass = 0.0;
        linearMomentum.set(0.0, 0.0, 0.0);
        for (int i = 0; i < this.rootJoints.size(); ++i) {
            Joint rootJoint = this.rootJoints.get(i);
            double mass = rootJoint.physics.recursiveComputeLinearMomentum((Vector3DBasics)this.tempLinearMomentum);
            totalMass += mass;
            linearMomentum.add((Tuple3DReadOnly)this.tempLinearMomentum);
        }
        return totalMass;
    }

    public double computeLinearMomentum(Joint rootJoint, Vector3DBasics linearMomentum) {
        double totalMass = 0.0;
        linearMomentum.set(0.0, 0.0, 0.0);
        double mass = rootJoint.physics.recursiveComputeLinearMomentum((Vector3DBasics)this.tempLinearMomentum);
        linearMomentum.add((Tuple3DReadOnly)this.tempLinearMomentum);
        return totalMass += mass;
    }

    public void computeAngularMomentum(Vector3DBasics angularMomentum) {
        angularMomentum.set(0.0, 0.0, 0.0);
        for (int i = 0; i < this.rootJoints.size(); ++i) {
            Joint rootJoint = this.rootJoints.get(i);
            rootJoint.physics.recursiveComputeAngularMomentum((Vector3DBasics)this.tempAngularMomentum);
            angularMomentum.add((Tuple3DReadOnly)this.tempAngularMomentum);
        }
    }

    public void computeAngularMomentum(Joint rootJoint, Vector3DBasics angularMomentum) {
        angularMomentum.set(0.0, 0.0, 0.0);
        rootJoint.physics.recursiveComputeAngularMomentum((Vector3DBasics)this.tempAngularMomentum);
        angularMomentum.add((Tuple3DReadOnly)this.tempAngularMomentum);
    }

    public double computeCOMMomentum(Point3DBasics comPoint, Vector3DBasics linearMomentum, Vector3DBasics angularMomentum) {
        double mass = this.computeCenterOfMass(comPoint);
        this.computeLinearMomentum(linearMomentum);
        this.computeAngularMomentum(angularMomentum);
        this.tempCOMVector.set((Tuple3DReadOnly)comPoint);
        this.tempAngularMomentum.cross((Tuple3DReadOnly)this.tempCOMVector, (Tuple3DReadOnly)linearMomentum);
        angularMomentum.sub((Tuple3DReadOnly)this.tempAngularMomentum);
        return mass;
    }

    public double computeCOMMomentum(Joint rootJoint, Point3DBasics comPoint, Vector3DBasics linearMomentum, Vector3DBasics angularMomentum) {
        double mass = this.computeCenterOfMass(rootJoint, comPoint);
        this.computeLinearMomentum(rootJoint, linearMomentum);
        this.computeAngularMomentum(rootJoint, angularMomentum);
        this.tempCOMVector.set((Tuple3DReadOnly)comPoint);
        this.tempAngularMomentum.cross((Tuple3DReadOnly)this.tempCOMVector, (Tuple3DReadOnly)linearMomentum);
        angularMomentum.sub((Tuple3DReadOnly)this.tempAngularMomentum);
        return mass;
    }

    public void computeCenterOfPressure(Point3DBasics copPoint, Vector3DBasics copForce, Vector3DBasics copMoment) {
        GroundContactPoint gc;
        int i;
        copPoint.set(0.0, 0.0, 0.0);
        copForce.set(0.0, 0.0, 0.0);
        copMoment.set(0.0, 0.0, 0.0);
        List<GroundContactPoint> gcPoints = this.getAllGroundContactPoints();
        for (i = 0; i < gcPoints.size(); ++i) {
            gc = gcPoints.get(i);
            gc.getForce((Vector3DBasics)this.tempForce);
            copForce.add((Tuple3DReadOnly)this.tempForce);
            double fz = this.tempForce.getZ();
            copPoint.setX(copPoint.getX() + gc.getX() * fz);
            copPoint.setY(copPoint.getY() + gc.getY() * fz);
            copPoint.setZ(copPoint.getZ() + gc.getZ() * fz);
        }
        if (copForce.getZ() < 1.0E-14) {
            copPoint.set(Double.NaN, Double.NaN, Double.NaN);
            copMoment.set(0.0, 0.0, 0.0);
            return;
        }
        copPoint.scale(1.0 / copForce.getZ());
        for (i = 0; i < gcPoints.size(); ++i) {
            gc = gcPoints.get(i);
            this.tempRVector.setX(copPoint.getX() - gc.getX());
            this.tempRVector.setY(copPoint.getY() - gc.getY());
            this.tempRVector.setZ(copPoint.getZ() - gc.getZ());
            gc.getForce((Vector3DBasics)this.tempForce);
            this.tempRCrossF.cross((Tuple3DReadOnly)this.tempRVector, (Tuple3DReadOnly)this.tempForce);
            copMoment.add((Tuple3DReadOnly)this.tempRCrossF);
        }
    }

    public String toString() {
        StringBuffer retBuffer = new StringBuffer();
        LinkedList<Joint> queue = new LinkedList<Joint>();
        retBuffer.append("Robot: " + this.name + "\n\n");
        List<Joint> children = this.getRootJoints();
        queue.addAll(children);
        while (!queue.isEmpty()) {
            Joint joint = (Joint)queue.poll();
            retBuffer.append("\n" + joint.toString());
            List<Joint> childrenJoints = joint.getChildrenJoints();
            queue.addAll(childrenJoints);
        }
        return retBuffer.toString();
    }

    public void printRobotJointsAndMasses(StringBuffer stringBuffer) {
        LinkedList<Joint> queue = new LinkedList<Joint>();
        List<Joint> children = this.getRootJoints();
        queue.addAll(children);
        while (!queue.isEmpty()) {
            Joint joint = (Joint)queue.poll();
            stringBuffer.append("\n" + joint.getName() + ": mass = " + joint.getLink().getMass());
            List<Joint> childrenJoints = joint.getChildrenJoints();
            queue.addAll(childrenJoints);
        }
    }

    private URL getPath() {
        String end;
        Class<?> c = this.getClass();
        URL url = c.getResource(c.getSimpleName() + ".class");
        if (url == null) {
            return null;
        }
        String temp = url.toExternalForm();
        if (temp.endsWith(end = "/" + c.getSimpleName() + ".class")) {
            temp = temp.substring(0, temp.length() - end.length());
        } else {
            end = "/" + c.getName().replace("\\.", "/") + ".class";
            if (temp.endsWith(end)) {
                temp = temp.substring(0, temp.length() - end.length());
            } else if (temp.endsWith(end = end.replace("/", "\\"))) {
                temp = temp.substring(0, temp.length() - end.length());
            } else {
                return null;
            }
        }
        String temp2 = c.getSimpleName();
        temp = temp + "/" + (temp2.endsWith("Robot") ? temp2.substring(0, temp2.length() - "Robot".length()) : temp2) + "ControllerBase.java";
        try {
            URL path = new URL(temp);
            return path;
        }
        catch (MalformedURLException broken) {
            System.err.println("Path to " + c.getName() + " could not be calculated and the following error was observed:\n\t" + broken.getMessage() + "\n\tPath: " + temp);
            return null;
        }
    }

    private void println(PrintStream stream, int indent, String line) {
        for (int i = 0; i < indent; ++i) {
            stream.print(" ");
        }
        stream.println(line);
    }

    private void printVarBase(PrintStream stream, YoVariableList list) {
        if (list.size() == 0) {
            return;
        }
        stream.print("   YoVariable ");
        for (int varNum = 0; varNum < list.size(); ++varNum) {
            YoVariable var = list.get(varNum);
            if (varNum != 0) {
                if (varNum % 10 == 0) {
                    stream.println(";");
                    stream.print("   YoVariable ");
                } else {
                    stream.print(", ");
                }
            }
            stream.print(var.getName());
        }
        stream.println(";");
    }

    public List<RobotControllerAndParameters> getControllers() {
        return this.controllers;
    }

    public void setBodyExternalForcePoint(double fx, double fy, double fz) {
        this.kp_body.setForce(fx, fy, fz);
    }

    public YoVariable findVariable(String variableName) {
        return this.getRobotsYoRegistry().findVariable(variableName);
    }

    public boolean hasUniqueVariable(String variableName) {
        return this.getRobotsYoRegistry().hasUniqueVariable(variableName);
    }

    public List<YoVariable> getVariables() {
        return this.getRobotsYoRegistry().collectSubtreeVariables();
    }

    public YoVariable findVariable(String namespaceEnding, String name) {
        return this.getRobotsYoRegistry().findVariable(namespaceEnding, name);
    }

    public boolean hasUniqueVariable(String namespaceEnding, String name) {
        return this.getRobotsYoRegistry().hasUniqueVariable(namespaceEnding, name);
    }

    public List<YoVariable> findVariables(String namespaceEnding, String name) {
        return this.getRobotsYoRegistry().findVariables(namespaceEnding, name);
    }

    public List<YoVariable> findVariables(String name) {
        return this.getRobotsYoRegistry().findVariables(name);
    }

    public List<YoVariable> findVariables(YoNamespace namespace) {
        return this.getRobotsYoRegistry().findVariables(namespace);
    }

    public List<Graphics3DObject> getStaticLinkGraphics() {
        return this.staticLinkGraphics;
    }

    public Link getLink(String linkName) {
        for (Joint rootJoint : this.rootJoints) {
            Link link = rootJoint.getLink(linkName);
            if (link == null) continue;
            return link;
        }
        return null;
    }

    public void freezeJointAtZero(Joint jointToFreeze) {
        Vector3D jointToFreezeOffset = new Vector3D();
        jointToFreeze.getOffset((Vector3DBasics)jointToFreezeOffset);
        System.out.println("jointToFreezeOffset = " + jointToFreezeOffset);
        Joint parentJoint = jointToFreeze.getParentJoint();
        parentJoint.removeChildJoint(jointToFreeze);
        Link parentLink = parentJoint.getLink();
        parentLink = Link.combineLinks(parentLink.getName(), parentLink, jointToFreeze.getLink(), (Vector3DReadOnly)jointToFreezeOffset);
        parentJoint.setLink(parentLink);
        ArrayList<Joint> jointsToMove = new ArrayList<Joint>();
        List<Joint> childrenJoints = jointToFreeze.getChildrenJoints();
        for (Joint childJoint : childrenJoints) {
            jointsToMove.add(childJoint);
            Vector3D childOffset = new Vector3D();
            childJoint.getOffset((Vector3DBasics)childOffset);
            childOffset.add((Tuple3DReadOnly)jointToFreezeOffset);
            childJoint.setOffset((Tuple3DReadOnly)childOffset);
        }
        for (Joint jointToMove : jointsToMove) {
            jointToFreeze.removeChildJoint(jointToMove);
            parentJoint.addJoint(jointToMove);
        }
    }

    public boolean verifySetupProperly(double epsilon) {
        for (Joint rootJoint : this.rootJoints) {
            boolean rootJointSetupProperly = rootJoint.physics.verifySetupProperly(epsilon);
            if (rootJointSetupProperly) continue;
            return false;
        }
        return true;
    }

    public Joint getJoint(String name) {
        for (int i = 0; i < this.rootJoints.size(); ++i) {
            Joint rootJoint = this.rootJoints.get(i);
            Joint joint = rootJoint.recursivelyGetJoint(name);
            if (joint == null) continue;
            return joint;
        }
        return null;
    }
}

