/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.CameraMount;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.IMUMount;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.KinematicPoint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;

public class UniversalJoint
extends PinJoint {
    private static final long serialVersionUID = 3428274232426974681L;
    private PinJoint joint2;

    public UniversalJoint(String jname1, String jname2, Tuple3DReadOnly offset, Robot rob, Vector3DReadOnly firstAxis, Vector3DReadOnly secondAxis) {
        super(jname1, offset, rob, firstAxis);
        this.joint2 = new PinJoint(jname2, (Tuple3DReadOnly)new Vector3D(), rob, secondAxis);
        this.joint2.parentJoint = this;
        this.childrenJoints.add(this.joint2);
        this.joint2.physics.r_in.setX(0.0);
        this.joint2.physics.r_in.setY(0.0);
        this.joint2.physics.r_in.setZ(0.0);
    }

    public PinJoint getFirstJoint() {
        return this;
    }

    public PinJoint getSecondJoint() {
        return this.joint2;
    }

    @Override
    public void addJoint(Joint nextJoint) {
        this.joint2.addJoint(nextJoint);
    }

    @Override
    public void setLink(Link l) {
        Link nullLink = new Link("null");
        nullLink.setMass(0.0);
        nullLink.setMomentOfInertia(0.0, 0.0, 0.0);
        nullLink.setComOffset(0.0, 0.0, 0.0);
        super.setLink(nullLink);
        this.joint2.setLink(l);
    }

    @Override
    public void addCameraMount(CameraMount mount) {
        this.joint2.addCameraMount(mount);
    }

    @Override
    public void addIMUMount(IMUMount mount) {
        this.joint2.addIMUMount(mount);
    }

    @Override
    public void addKinematicPoint(KinematicPoint point) {
        this.joint2.addKinematicPoint(point);
    }

    @Override
    public void addGroundContactPoint(GroundContactPoint point) {
        this.joint2.addGroundContactPoint(point);
    }

    @Override
    public void addExternalForcePoint(ExternalForcePoint point) {
        this.joint2.addExternalForcePoint(point);
    }

    public void setLimitStops(int axis, double q_min, double q_max, double k_limit, double b_limit) {
        if (axis == 1) {
            super.setLimitStops(q_min, q_max, k_limit, b_limit);
        } else if (axis == 2) {
            this.joint2.setLimitStops(q_min, q_max, k_limit, b_limit);
        }
    }

    public void setDamping(int axis, double b_damp) {
        if (axis == 1) {
            super.setDamping(b_damp);
        } else if (axis == 2) {
            this.joint2.setDamping(b_damp);
        }
    }

    @Override
    public void setDamping(double b_damp) {
        super.setDamping(b_damp);
        this.joint2.setDamping(b_damp);
    }

    public void setInitialState(double q1_init, double qd1_init, double q2_init, double qd2_init) {
        super.setInitialState(q1_init, qd1_init);
        this.joint2.setInitialState(q2_init, qd2_init);
    }

    @Override
    public void getState(double[] state) {
        state[0] = this.q.getDoubleValue();
        state[1] = this.qd.getDoubleValue();
        state[2] = this.joint2.q.getDoubleValue();
        state[3] = this.joint2.qd.getDoubleValue();
    }

    @Override
    public void getRotationToWorld(Orientation3DBasics rotation) {
        rotation.set((Orientation3DReadOnly)this.joint2.transformToNext.getRotation());
    }
}

