/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JOptionPane;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ParameterFileChooser;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.SaveParametersConstructor;
import us.ihmc.yoVariables.parameters.XmlParameterWriter;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SaveParametersGenerator
implements SaveParametersConstructor {
    private final SimulationConstructionSet scs;
    private ParameterFileChooser fileChooser;

    public SaveParametersGenerator(SimulationConstructionSet scs) {
        this.scs = scs;
        this.fileChooser = new ParameterFileChooser();
    }

    @Override
    public void constructDialog() {
        if (this.fileChooser.showDialog(this.scs.getJFrame(), this.scs.getRootRegistry(), this.scs.getParameterRootPath(), this.scs.getDefaultParameterFile(), true)) {
            XmlParameterWriter writer = new XmlParameterWriter();
            for (YoRegistry child : this.fileChooser.getRegistries()) {
                writer.addParameters(child);
            }
            try {
                FileOutputStream os = new FileOutputStream(this.fileChooser.getFile());
                writer.write((OutputStream)os);
                os.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.scs.getJFrame(), "Cannot write to " + this.fileChooser.getFile() + "\n" + e.getMessage(), "Cannot write to file", 0);
            }
        }
    }

    @Override
    public void closeAndDispose() {
        this.fileChooser.closeAndDispose();
        this.fileChooser = null;
    }
}

