/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.environments;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.input.SelectedListener;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.simulationConstructionSetTools.util.environments.SimpleCombinedTerrainObjectsEnvironment;
import us.ihmc.simulationConstructionSetTools.util.environments.environmentRobots.ContactableSelectableBoxRobot;
import us.ihmc.simulationconstructionset.DoNothingController;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.GroundContactPointsHolder;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.util.LinearStickSlipGroundContactModel;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.tools.inputDevices.keyboard.ModifierKeyInterface;

public class SimpleCombinedTerrainObjectEnvinronmentTest {
    private static boolean SHOW_GUI = false;

    @Test
    public void testSimpleCombinedTerrainObjectEnvironment() {
        double z;
        double y;
        double x;
        LinearStickSlipGroundContactModel linearGroundModel;
        DoNothingController controller;
        ContactableSelectableBoxRobot newBox;
        int i;
        SimpleCombinedTerrainObjectsEnvironment combinedEnvironment = new SimpleCombinedTerrainObjectsEnvironment();
        double[][] flatTableAndRampPointsToVerify = new double[][]{{0.14757379494298717, -0.528196925606796, 1.3991187639167517}, {-0.6665780714615179, 0.5706114790109398, 1.39911876391675}, {2.379822956194785, 0.5927861756072765, 1.3991187639167517}, {2.6293935658528262, -0.6993563754125409, 1.39911876391675}, {4.322231651900529, 5.4181228985108625, 1.499118763916755}, {3.2528838119957477, 3.877529705170268, 1.4991187639167478}, {4.215421541015941, 3.4536751228920437, 1.4991187639167514}, {4.677244691476593, 3.980283461828673, 1.4991187639167478}, {-0.5235290536441202, -2.529367714770496, 0.4921569821186278}, {-1.6987170600911963, -3.627642774366805, 0.10042764663626969}, {1.880654300374344, -3.695081247578262, 1.2935514334581129}, {2.8913312337222643, -2.676090460597649, 1.6304437445740891}};
        double[][] conePointsToVerify = new double[][]{{7.157353139692312, 2.1164659571710356, 0.24790711092972373}, {7.379343183126132, 0.7192852272101726, 0.37399268702625044}, {6.473096554552568, -0.4560414750781806, 0.31268495347342273}, {6.471167128152199, 0.5389925159503166, 0.8888498945112264}};
        double[][][] allPointsToVerify = new double[][][]{flatTableAndRampPointsToVerify, conePointsToVerify};
        double[] epsilons = new double[]{0.001, 0.025};
        int numBoxes = 100;
        Robot[] robotBoxes = new Robot[numBoxes];
        Random random = new Random(3L);
        double xSpread = 15.0;
        double ySpread = 15.0;
        double zHeight = 3.0;
        double minZ = 1.5;
        double boxSize = 0.7;
        for (i = 0; i < numBoxes / 3; ++i) {
            newBox = new ContactableSelectableBoxRobot("box" + i, random.nextDouble() * boxSize + 0.001, random.nextDouble() * boxSize + 0.001, random.nextDouble() * boxSize + 0.001, 5.0);
            controller = new DoNothingController();
            newBox.setController((RobotController)controller);
            linearGroundModel = new LinearStickSlipGroundContactModel((GroundContactPointsHolder)newBox, 40000.0, 10.0, 80.0, 500.0, 1.2, 1.2, newBox.getRobotsYoRegistry());
            linearGroundModel.setGroundProfile3D((GroundProfile3D)combinedEnvironment);
            newBox.setGroundContactModel((GroundContactModel)linearGroundModel);
            newBox.setGravity(-9.81);
            x = random.nextDouble() * xSpread - xSpread / 2.0;
            y = random.nextDouble() * ySpread - ySpread / 2.0;
            z = random.nextDouble() * (zHeight - minZ) + minZ;
            newBox.setPosition(x, y, z);
            robotBoxes[i] = newBox;
        }
        for (i = numBoxes / 3; i < numBoxes / 3 * 2; ++i) {
            newBox = ContactableSelectableBoxRobot.createContactableCardboardBoxRobot((String)("carboardbox" + i), (double)(random.nextDouble() * boxSize + 0.001), (double)(random.nextDouble() * boxSize + 0.001), (double)(random.nextDouble() * boxSize + 0.001), (double)5.0);
            controller = new DoNothingController();
            newBox.setController((RobotController)controller);
            linearGroundModel = new LinearStickSlipGroundContactModel((GroundContactPointsHolder)newBox, 40000.0, 10.0, 80.0, 500.0, 1.2, 1.2, newBox.getRobotsYoRegistry());
            linearGroundModel.setGroundProfile3D((GroundProfile3D)combinedEnvironment);
            newBox.setGroundContactModel((GroundContactModel)linearGroundModel);
            newBox.setGravity(-9.81);
            x = random.nextDouble() * xSpread - xSpread / 2.0;
            y = random.nextDouble() * ySpread - ySpread / 2.0;
            z = random.nextDouble() * (zHeight - minZ) + minZ;
            newBox.setPosition(x, y, z);
            robotBoxes[i] = newBox;
        }
        for (i = numBoxes / 3 * 2; i < numBoxes; ++i) {
            newBox = ContactableSelectableBoxRobot.createContactableWoodBoxRobot((String)("woodbox" + i), (double)(random.nextDouble() * boxSize + 0.001), (double)(random.nextDouble() * boxSize + 0.001), (double)(random.nextDouble() * boxSize + 0.001), (double)5.0);
            controller = new DoNothingController();
            newBox.setController((RobotController)controller);
            linearGroundModel = new LinearStickSlipGroundContactModel((GroundContactPointsHolder)newBox, 40000.0, 10.0, 80.0, 500.0, 1.2, 1.2, newBox.getRobotsYoRegistry());
            linearGroundModel.setGroundProfile3D((GroundProfile3D)combinedEnvironment);
            newBox.setGroundContactModel((GroundContactModel)linearGroundModel);
            newBox.setGravity(-9.81);
            x = random.nextDouble() * xSpread - xSpread / 2.0;
            y = random.nextDouble() * ySpread - ySpread / 2.0;
            z = random.nextDouble() * (zHeight - minZ) + minZ;
            newBox.setPosition(x, y, z);
            robotBoxes[i] = newBox;
        }
        if (SHOW_GUI) {
            SimulationConstructionSet scs = new SimulationConstructionSet(robotBoxes);
            scs.addStaticLinkGraphics(combinedEnvironment.getLinkGraphics());
            scs.setGroundVisible(false);
            scs.attachSelectedListener(new SelectedListener(){

                public void selected(Graphics3DNode graphics3dNode, ModifierKeyInterface modifierKeyHolder, Point3DReadOnly location, Point3DReadOnly cameraLocation, QuaternionReadOnly cameraRotation) {
                    System.out.println("Clicked on Point " + String.valueOf(location));
                }
            });
            scs.startOnAThread();
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

